/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thrift;

import com.twitter.finagle.Service;
import com.twitter.finagle.SimpleFilter;
import com.twitter.finagle.thrift.SeqIdFilter$;
import com.twitter.finagle.thrift.SeqMismatchException;
import com.twitter.finagle.thrift.ThriftClientRequest;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time$;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001y<Q!\u0001\u0002\t\u0002-\t1bU3r\u0013\u00124\u0015\u000e\u001c;fe*\u00111\u0001B\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\u0005\u00151\u0011a\u00024j]\u0006<G.\u001a\u0006\u0003\u000f!\tq\u0001^<jiR,'OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0001\u0010\u0005-\u0019V-]%e\r&dG/\u001a:\u0014\u00055\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\rC\u0003\u0018\u001b\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!9!$\u0004b\u0001\n\u0003Y\u0012a\u0003,feNLwN\\'bg.,\u0012\u0001\b\t\u0003#uI!A\b\n\u0003\u0007%sG\u000f\u0003\u0004!\u001b\u0001\u0006I\u0001H\u0001\r-\u0016\u00148/[8o\u001b\u0006\u001c8\u000e\t\u0005\bE5\u0011\r\u0011\"\u0001\u001c\u0003!1VM]:j_:\f\u0004B\u0002\u0013\u000eA\u0003%A$A\u0005WKJ\u001c\u0018n\u001c82A\u0019!aB\u0001\u0001''\t)s\u0005\u0005\u0003)S-rS\"\u0001\u0003\n\u0005)\"!\u0001D*j[BdWMR5mi\u0016\u0014\bC\u0001\u0007-\u0013\ti#AA\nUQJLg\r^\"mS\u0016tGOU3rk\u0016\u001cH\u000fE\u0002\u0012_EJ!\u0001\r\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0005E\u0011\u0014BA\u001a\u0013\u0005\u0011\u0011\u0015\u0010^3\t\u000b])C\u0011A\u001b\u0015\u0003Y\u0002\"\u0001D\u0013\t\ra*\u0003\u0015!\u0003:\u0003\r\u0011hn\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003yI\tA!\u001e;jY&\u0011ah\u000f\u0002\u0007%\u0006tGm\\7\t\r\u0001+\u0003\u0015\"\u0003B\u0003\u00159W\r^\u001a3)\ra\"\t\u0012\u0005\u0006\u0007~\u0002\rAL\u0001\u0004EV4\u0007\"B#@\u0001\u0004a\u0012aA8gM\"1q)\nQ\u0005\n!\u000bQ\u0001];ugI\"B!\u0013'N\u001dB\u0011\u0011CS\u0005\u0003\u0017J\u0011A!\u00168ji\")1I\u0012a\u0001]!)QI\u0012a\u00019!)qJ\u0012a\u00019\u0005\t\u0001\u0010\u0003\u0004RK\u0001&IAU\u0001\u0007E\u0006$Wj]4\u0015\u0005M[\u0006c\u0001+W16\tQK\u0003\u0002=\r%\u0011q+\u0016\u0002\u0006)\"\u0014xn\u001e\t\u0003#eK!A\u0017\n\u0003\u000f9{G\u000f[5oO\")A\f\u0015a\u0001;\u0006\u0019q\u000f[=\u0011\u0005y+gBA0d!\t\u0001'#D\u0001b\u0015\t\u0011'\"\u0001\u0004=e>|GOP\u0005\u0003IJ\ta\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011AM\u0005\u0005\u0007S\u0016\u0002K\u0011\u00026\u0002\u0017\u001d,G/\u00118e'\u0016$\u0018\n\u001a\u000b\u0004W:|\u0007c\u0001+m9%\u0011Q.\u0016\u0002\u0004)JL\b\"B\"i\u0001\u0004q\u0003\"\u00029i\u0001\u0004a\u0012!\u00028fo&#\u0007\"\u0002:&\t\u0003\u0019\u0018!B1qa2LHc\u0001;xsB\u0019A+\u001e\u0018\n\u0005Y,&A\u0002$viV\u0014X\rC\u0003yc\u0002\u00071&A\u0002sKFDQA_9A\u0002m\fqa]3sm&\u001cW\r\u0005\u0003)y.r\u0013BA?\u0005\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class SeqIdFilter
extends SimpleFilter<ThriftClientRequest, byte[]> {
    private final Random rng = new Random(Time$.MODULE$.now().inMilliseconds());

    public static int Version1() {
        return SeqIdFilter$.MODULE$.Version1();
    }

    public static int VersionMask() {
        return SeqIdFilter$.MODULE$.VersionMask();
    }

    private int get32(byte[] buf, int off) {
        return (buf[off + 0] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
    }

    private void put32(byte[] buf, int off, int x) {
        buf[off] = (byte)(x >> 24 & 0xFF);
        buf[off + 1] = (byte)(x >> 16 & 0xFF);
        buf[off + 2] = (byte)(x >> 8 & 0xFF);
        buf[off + 3] = (byte)(x & 0xFF);
    }

    private Throw<Nothing$> badMsg(String why) {
        return new Throw((Throwable)new IllegalArgumentException(why));
    }

    private Try<Object> getAndSetId(byte[] buf, int newId) {
        int off;
        int n;
        if (buf.length < 4) {
            return this.badMsg("short header");
        }
        int header = this.get32(buf, 0);
        if (header < 0) {
            if ((header & SeqIdFilter$.MODULE$.VersionMask()) != SeqIdFilter$.MODULE$.Version1()) {
                return this.badMsg(new StringOps(Predef$.MODULE$.augmentString("bad version %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(header & SeqIdFilter$.MODULE$.VersionMask()))})));
            }
            if (buf.length < 8) {
                return this.badMsg("short name size");
            }
            n = 8 + this.get32(buf, 4);
        } else {
            n = off = 4 + header + 1;
        }
        if (buf.length < off + 4) {
            return this.badMsg("short buffer");
        }
        int currentId = this.get32(buf, off);
        this.put32(buf, off, newId);
        return new Return((Object)BoxesRunTime.boxToInteger((int)currentId));
    }

    public Future<byte[]> apply(ThriftClientRequest req, Service<ThriftClientRequest, byte[]> service) {
        Future future;
        if (req.oneway) {
            future = service.apply((Object)req);
        } else {
            int id;
            int id2;
            byte[] reqBuf = (byte[])req.message.clone();
            Try<Object> try_ = this.getAndSetId(reqBuf, id2 = this.rng.nextInt());
            if (!(try_ instanceof Return)) {
                if (try_ instanceof Throw) {
                    Throw throw_ = (Throw)try_;
                    Throwable exc = throw_.e();
                    return Future$.MODULE$.exception(exc);
                }
                throw new MatchError(try_);
            }
            Return return_ = (Return)try_;
            int n = id = BoxesRunTime.unboxToInt((Object)return_.r());
            int givenId = n;
            ThriftClientRequest newReq = new ThriftClientRequest(reqBuf, req.oneway);
            future = service.apply((Object)newReq).flatMap((Function1 & Serializable & scala.Serializable)resBuf -> {
                boolean bl = false;
                Return return_ = null;
                Try<Object> try_ = this.getAndSetId((byte[])resBuf, givenId);
                if (try_ instanceof Return) {
                    bl = true;
                    return_ = (Return)try_;
                    int n = BoxesRunTime.unboxToInt((Object)return_.r());
                    if (id2 == n) {
                        return Future$.MODULE$.value(resBuf);
                    }
                }
                if (bl) {
                    int badId = BoxesRunTime.unboxToInt((Object)return_.r());
                    return Future$.MODULE$.exception((Throwable)((Object)new SeqMismatchException(badId, id2)));
                }
                if (!(try_ instanceof Throw)) throw new MatchError(try_);
                Throw throw_ = (Throw)try_;
                Throwable exc = throw_.e();
                return Future$.MODULE$.exception(exc);
            });
        }
        return future;
    }
}

