/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thrift.exp.partitioning;

import com.twitter.finagle.Address;
import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.Stack;
import com.twitter.finagle.loadbalancer.LoadBalancerFactory;
import com.twitter.finagle.loadbalancer.TrafficDistributor$;
import com.twitter.finagle.param.Label;
import com.twitter.finagle.param.Label$;
import com.twitter.finagle.partitioning.PartitionNodeManager;
import com.twitter.finagle.partitioning.PartitioningService;
import com.twitter.finagle.partitioning.SnapPartitioner;
import com.twitter.finagle.thrift.ClientDeserializeCtx$;
import com.twitter.finagle.thrift.ThriftClientRequest;
import com.twitter.finagle.thrift.exp.partitioning.ClientClusterStrategy;
import com.twitter.finagle.thrift.exp.partitioning.ClientCustomStrategy;
import com.twitter.finagle.thrift.exp.partitioning.ClientCustomStrategy$;
import com.twitter.finagle.thrift.exp.partitioning.CustomPartitioningStrategy;
import com.twitter.finagle.thrift.exp.partitioning.MethodBuilderCustomStrategy;
import com.twitter.finagle.thrift.exp.partitioning.ThriftPartitioningService;
import com.twitter.finagle.thrift.exp.partitioning.ThriftPartitioningService$PartitioningStrategyException$;
import com.twitter.finagle.thrift.exp.partitioning.ThriftPartitioningUtil$;
import com.twitter.finagle.thrift.exp.partitioning.ThriftRequestSerializer;
import com.twitter.scrooge.ThriftStructIface;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Time;
import com.twitter.util.Try;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue!B\b\u0011\u0001Ya\u0002\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005;\")\u0011\r\u0001C\u0001E\"1\u0001\u000e\u0001Q\u0001\nuCa!\u001b\u0001!\u0002\u0013Q\u0007\u0002CA\f\u0001\u0001\u0006I!!\u0007\t\u0011\u0005}\u0001\u0001)C\u0005\u0003CAq!a\r\u0001\t+\t)\u0004\u0003\u0005\u0002>\u0001!)BFA \u0011\u001d\t\u0019\u0006\u0001C\u000b\u0003+B\u0001\"!\u001c\u0001\t\u0003\u0001\u0012q\u000e\u0005\b\u0003\u000f\u0003A\u0011IAE\u0005}!\u0006N]5gi\u000e+8\u000f^8n!\u0006\u0014H/\u001b;j_:LgnZ*feZL7-\u001a\u0006\u0003#I\tA\u0002]1si&$\u0018n\u001c8j]\u001eT!a\u0005\u000b\u0002\u0007\u0015D\bO\u0003\u0002\u0016-\u00051A\u000f\u001b:jMRT!a\u0006\r\u0002\u000f\u0019Lg.Y4mK*\u0011\u0011DG\u0001\bi^LG\u000f^3s\u0015\u0005Y\u0012aA2p[V\u0019Q$J\u001a\u0014\u0005\u0001q\u0002\u0003B\u0010\"GIj\u0011\u0001\t\u0006\u0003#YI!A\t\u0011\u0003'A\u000b'\u000f^5uS>t\u0017N\\4TKJ4\u0018nY3\u0011\u0005\u0011*C\u0002\u0001\u0003\u0006M\u0001\u0011\r\u0001\u000b\u0002\u0004%\u0016\f8\u0001A\t\u0003S=\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012qAT8uQ&tw\r\u0005\u0002+a%\u0011\u0011g\u000b\u0002\u0004\u0003:L\bC\u0001\u00134\t\u0015!\u0004A1\u0001)\u0005\r\u0011V\r]\u0001\u000bk:$WM\u001d7zS:<\u0007cA\u001c9u5\ta#\u0003\u0002:-\t)1\u000b^1dWB!qgO\u00123\u0013\tadC\u0001\bTKJ4\u0018nY3GC\u000e$xN]=\u0002%QD'/\u001b4u\u001b\u0006\u00148\u000f[1mY\u0006\u0014G.\u001a\t\u0005\u007fE\u001b#G\u0004\u0002A\u001f:\u0011\u0011I\u0014\b\u0003\u00056s!a\u0011'\u000f\u0005\u0011[eBA#K\u001d\t1\u0015*D\u0001H\u0015\tAu%\u0001\u0004=e>|GOP\u0005\u00027%\u0011\u0011DG\u0005\u0003/aI!!\u0006\f\n\u0005M!\u0012BA\t\u0013\u0013\t\u0001\u0006#A\rUQJLg\r\u001e)beRLG/[8oS:<7+\u001a:wS\u000e,\u0017B\u0001*T\u0005I\u0011V-\u001d*fa6\u000b'o\u001d5bY2\f'\r\\3\u000b\u0005A\u0003\u0012A\u00029be\u0006l7\u000f\u0005\u0002W3:\u0011qgV\u0005\u00031Z\tQa\u0015;bG.L!AW.\u0003\rA\u000b'/Y7t\u0015\tAf#\u0001\nd_:4\u0017nZ;sK\u0012\u001cFO]1uK\u001eL\bC\u00010`\u001b\u0005\u0001\u0012B\u00011\u0011\u0005i\u0019Uo\u001d;p[B\u000b'\u000f^5uS>t\u0017N\\4TiJ\fG/Z4z\u0003\u0019a\u0014N\\5u}Q)1\rZ3gOB!a\fA\u00123\u0011\u0015)T\u00011\u00017\u0011\u0015iT\u00011\u0001?\u0011\u0015!V\u00011\u0001V\u0011\u0015aV\u00011\u0001^\u00039\u0019Wo\u001d;p[N#(/\u0019;fOf\f1B\\8eK6\u000bg.Y4feB\u00121n\u001c\t\u0007?1\u001c#G\\9\n\u00055\u0004#\u0001\u0006)beRLG/[8o\u001d>$W-T1oC\u001e,'\u000f\u0005\u0002%_\u0012I\u0001oBA\u0001\u0002\u0003\u0015\t\u0001\u000b\u0002\u0004?\u0012\n\u0004\u0003\u0002\u0016sijL!a]\u0016\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004\"!\u001e=\u000e\u0003YT!a\u001e\r\u0002\u000fM\u001c'o\\8hK&\u0011\u0011P\u001e\u0002\u0012)\"\u0014\u0018N\u001a;TiJ,8\r^%gC\u000e,\u0007\u0003B>\u007f\u0003\u0003i\u0011\u0001 \u0006\u0003{b\tA!\u001e;jY&\u0011q\u0010 \u0002\u0007\rV$XO]3\u0011\u000f\u0005\r\u0011QBA\ti6\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0005j[6,H/\u00192mK*\u0019\u00111B\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0010\u0005\u0015!aA'baB\u0019!&a\u0005\n\u0007\u0005U1FA\u0002J]R\f!b]3sS\u0006d\u0017N_3s!\rq\u00161D\u0005\u0004\u0003;\u0001\"a\u0006+ie&4GOU3rk\u0016\u001cHoU3sS\u0006d\u0017N_3s\u0003\u001d\u0011\bo\u0019(b[\u0016,\"!a\t\u0011\t\u0005\u0015\u0012Q\u0006\b\u0005\u0003O\tI\u0003\u0005\u0002GW%\u0019\u00111F\u0016\u0002\rA\u0013X\rZ3g\u0013\u0011\ty#!\r\u0003\rM#(/\u001b8h\u0015\r\tYcK\u0001\u001e]>\u0004\u0016M\u001d;ji&|g.\u00138g_Jl\u0017\r^5p]\"\u000bg\u000e\u001a7feR!\u0011qGA\u001d!\rYh0\u000b\u0005\u0007\u0003wQ\u0001\u0019A\u0012\u0002\u0007I,\u0017/\u0001\tqCJ$\u0018\u000e^5p]J+\u0017/^3tiR!\u0011\u0011IA(!\u0011Yh0a\u0011\u0011\u000f\u0005\u0015\u0012QI\u0012\u0002H%!\u0011qBA\u0019!\u0011Yh0!\u0013\u0011\u000b]\nYe\t\u001a\n\u0007\u00055cCA\u0004TKJ4\u0018nY3\t\r\u0005E3\u00021\u0001$\u0003!y'/[4j]\u0006d\u0017AD7fe\u001e,'+Z:q_:\u001cXm\u001d\u000b\u0006e\u0005]\u00131\f\u0005\u0007\u00033b\u0001\u0019A\u0012\u0002\u0017=\u0014\u0018nZ5oC2\u0014V-\u001d\u0005\b\u0003;b\u0001\u0019AA0\u0003\u001d\u0011Xm];miN\u0004b!!\u0019\u0002h\r\u0012dbA\u0010\u0002d%\u0019\u0011Q\r\u0011\u0002'A\u000b'\u000f^5uS>t\u0017N\\4TKJ4\u0018nY3\n\t\u0005%\u00141\u000e\u0002\u0013!\u0006\u0014H/\u001b;j_:,GMU3tk2$8OC\u0002\u0002f\u0001\n1dZ3u!\u0006\u0014H/\u001b;j_:LE-\u00118e%\u0016\fX/Z:u\u001b\u0006\u0004H\u0003BA9\u0003k\u0002Ba\u001f@\u0002tA9\u0011QEA#\u0003#!\bbBA<\u001b\u0001\u0007\u0011\u0011P\u0001\u0003a\u001a\u0004B!a\u001f\u0002\u0002:\u0019a,! \n\u0007\u0005}\u0004#\u0001\u000bDY&,g\u000e^\"vgR|Wn\u0015;sCR,w-_\u0005\u0005\u0003\u0007\u000b)I\u0001\tU_B\u000b'\u000f^5uS>tW\rZ'ba*\u0019\u0011q\u0010\t\u0002\u000b\rdwn]3\u0015\t\u0005-\u00151\u0013\t\u0005wz\fi\tE\u0002+\u0003\u001fK1!!%,\u0005\u0011)f.\u001b;\t\u000f\u0005Ue\u00021\u0001\u0002\u0018\u0006AA-Z1eY&tW\rE\u0002|\u00033K1!a'}\u0005\u0011!\u0016.\\3")
public class ThriftCustomPartitioningService<Req, Rep>
extends PartitioningService<Req, Rep> {
    private final ThriftPartitioningService.ReqRepMarshallable<Req, Rep> thriftMarshallable;
    private final CustomPartitioningStrategy customStrategy;
    private final PartitionNodeManager<Req, Rep, ?, PartialFunction<ThriftStructIface, Future<Map<Object, ThriftStructIface>>>> nodeManager;
    private final ThriftRequestSerializer serializer;

    private String rpcName() {
        return (String)ClientDeserializeCtx$.MODULE$.get().rpcName().getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A");
    }

    public final Future<Nothing$> noPartitionInformationHandler(Req req) {
        ThriftPartitioningService.PartitioningStrategyException ex = new ThriftPartitioningService.PartitioningStrategyException(new StringBuilder(43).append("No Partitioning Ids for the thrift method: ").append(this.rpcName()).toString(), ThriftPartitioningService$PartitioningStrategyException$.MODULE$.$lessinit$greater$default$2(), ThriftPartitioningService$PartitioningStrategyException$.MODULE$.$lessinit$greater$default$3());
        return Future$.MODULE$.exception((Throwable)ex);
    }

    public final Future<Map<Req, Future<Service<Req, Rep>>>> partitionRequest(Req original) {
        SnapPartitioner snapPartitioner = this.nodeManager.snapshotSharder();
        Future<Map<Object, ThriftStructIface>> partitionIdAndRequest = this.getPartitionIdAndRequestMap((PartialFunction<ThriftStructIface, Future<Map<Object, ThriftStructIface>>>)((PartialFunction)snapPartitioner.partitionFunction()));
        return partitionIdAndRequest.flatMap((Function1 & Serializable & scala.Serializable)idsAndRequests -> idsAndRequests.isEmpty() ? this.noPartitionInformationHandler(original) : (idsAndRequests.size() == 1 ? Future$.MODULE$.value((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(original), (Object)snapPartitioner.getServiceByPartitionId(((Tuple2)idsAndRequests.head())._1$mcI$sp()))}))) : Future$.MODULE$.value(idsAndRequests.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            ThriftStructIface request = (ThriftStructIface)tuple2._2();
            ThriftClientRequest thriftClientRequest = $this.serializer.serialize(this.rpcName(), request, $this.thriftMarshallable.isOneway(original));
            Object partitionedReq = $this.thriftMarshallable.framePartitionedRequest(thriftClientRequest, original);
            Tuple2 tuple22 = new Tuple2(partitionedReq, (Object)snapPartitioner.getServiceByPartitionId(id));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()))));
    }

    public final Rep mergeResponses(Req originalReq, PartitioningService.PartitionedResults<Req, Rep> results) {
        Function2 merger;
        Object mergerOption;
        Object object;
        CustomPartitioningStrategy customPartitioningStrategy = this.customStrategy;
        if (customPartitioningStrategy instanceof ClientCustomStrategy) {
            ClientCustomStrategy clientCustomStrategy = (ClientCustomStrategy)customPartitioningStrategy;
            object = clientCustomStrategy.responseMergerRegistry().get(this.rpcName());
        } else if (customPartitioningStrategy instanceof MethodBuilderCustomStrategy) {
            MethodBuilderCustomStrategy methodBuilderCustomStrategy = (MethodBuilderCustomStrategy)customPartitioningStrategy;
            object = methodBuilderCustomStrategy.responseMerger();
        } else {
            if (customPartitioningStrategy instanceof ClientClusterStrategy) {
                ClientClusterStrategy clientClusterStrategy = (ClientClusterStrategy)customPartitioningStrategy;
                throw new IllegalStateException(new StringBuilder(164).append("found a ClientClusterStrategy ").append(clientClusterStrategy).append(" after it").append(" should have been converted to a ClientCustomStrategy.  This state should be ").append("impossible to reach. It indicates a serious bug.").toString());
            }
            throw new MatchError((Object)customPartitioningStrategy);
        }
        Object object2 = mergerOption = object;
        if (!(object2 instanceof Some)) {
            if (None$.MODULE$.equals(object2)) {
                throw new IllegalArgumentException(new StringBuilder(51).append("cannot find the response merger for thrift method: ").append(this.rpcName()).toString());
            }
            throw new MatchError(object2);
        }
        Some some = (Some)object2;
        Function2 function2 = merger = (Function2)some.value();
        Function2 responseMerger = function2;
        Try<Object> mergedResponse = ThriftPartitioningUtil$.MODULE$.mergeResponses(results, (Function2<Seq<Object>, Seq<Throwable>, Try<Object>>)responseMerger, (Function1 & Serializable & scala.Serializable)rep -> $this.thriftMarshallable.fromResponseToBytes(rep));
        ClientDeserializeCtx$.MODULE$.get().mergedDeserializedResponse(mergedResponse);
        return this.thriftMarshallable.emptyResponse();
    }

    public Future<Map<Object, ThriftStructIface>> getPartitionIdAndRequestMap(PartialFunction<ThriftStructIface, Future<Map<Object, ThriftStructIface>>> pf) {
        Future future;
        ThriftStructIface inputArg = (ThriftStructIface)ClientDeserializeCtx$.MODULE$.get().request();
        try {
            Function1 & Serializable & scala.Serializable getPartitionIdAndRequest = (Function1 & Serializable & scala.Serializable)ts -> {
                Future future;
                CustomPartitioningStrategy customPartitioningStrategy = $this.customStrategy;
                if (customPartitioningStrategy instanceof ClientCustomStrategy) {
                    future = (Future)pf.applyOrElse(ts, ClientCustomStrategy$.MODULE$.defaultPartitionIdAndRequest());
                } else if (customPartitioningStrategy instanceof MethodBuilderCustomStrategy) {
                    MethodBuilderCustomStrategy methodBuilderCustomStrategy = (MethodBuilderCustomStrategy)customPartitioningStrategy;
                    future = (Future)methodBuilderCustomStrategy.getPartitionIdAndRequest().apply(ts);
                } else {
                    if (customPartitioningStrategy instanceof ClientClusterStrategy) {
                        ClientClusterStrategy clientClusterStrategy = (ClientClusterStrategy)customPartitioningStrategy;
                        throw new IllegalStateException(new StringBuilder(164).append("found a ClientClusterStrategy ").append(clientClusterStrategy).append(" after it should have been ").append("converted to a ClientCustomStrategy.  This state should be impossible").append(" to reach. It indicates a serious bug.").toString());
                    }
                    throw new MatchError((Object)customPartitioningStrategy);
                }
                return future;
            };
            future = (Future)getPartitionIdAndRequest.apply((Object)inputArg);
        }
        catch (Throwable throwable) {
            Future future2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassCastException) {
                ClassCastException classCastException = (ClassCastException)throwable2;
                future2 = Future$.MODULE$.exception((Throwable)new ThriftPartitioningService.PartitioningStrategyException("MethodBuilder Strategy request type doesn't match with the actual request type, please check the MethodBuilderCustomStrategy type.", classCastException, ThriftPartitioningService$PartitioningStrategyException$.MODULE$.$lessinit$greater$default$3()));
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    future2 = Future$.MODULE$.exception((Throwable)new ThriftPartitioningService.PartitioningStrategyException(e));
                } else {
                    throw throwable;
                }
            }
            future = future2;
        }
        return future;
    }

    public Future<BoxedUnit> close(Time deadline) {
        return Future$.MODULE$.join((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Future[]{this.nodeManager.close(deadline), super.close(deadline)})));
    }

    public ThriftCustomPartitioningService(Stack<ServiceFactory<Req, Rep>> underlying, ThriftPartitioningService.ReqRepMarshallable<Req, Rep> thriftMarshallable, Stack.Params params, CustomPartitioningStrategy configuredStrategy) {
        ClientCustomStrategy<Set<Address>> clientCustomStrategy;
        this.thriftMarshallable = thriftMarshallable;
        ClientCustomStrategy<Set<Address>> clientCustomStrategy2 = configuredStrategy;
        if (clientCustomStrategy2 instanceof ClientClusterStrategy) {
            ClientClusterStrategy clientClusterStrategy = (ClientClusterStrategy)((Object)clientCustomStrategy2);
            clientCustomStrategy = new ClientCustomStrategy<Set<Address>>(clientClusterStrategy.getPartitionIdAndRequestFn(), clientClusterStrategy.getLogicalPartitionIdFn(), TrafficDistributor$.MODULE$.varAddrToActivity(((LoadBalancerFactory.Dest)params.apply(LoadBalancerFactory.Dest$.MODULE$.param())).va(), ((Label)params.apply(Label$.MODULE$.param())).label()));
        } else {
            clientCustomStrategy = configuredStrategy;
        }
        this.customStrategy = clientCustomStrategy;
        this.nodeManager = this.customStrategy.newNodeManager(underlying, params);
        this.serializer = new ThriftRequestSerializer(params);
    }
}

