/**
 * Generated by Scrooge
 *   version: 22.12.0
 *   rev: ab627fbf226b4411683fe424493b17028bcc7917
 *   built at: 20221226-041621
 *   source file: /home/runner/work/dodo/dodo/finagle/finagle-thrift/src/main/thrift/scribe.thrift
 */
package com.twitter.finagle.thrift.scribe.thriftscala

import com.twitter.finagle.{
  Filter => _,
  Service => _,
  thrift => _,
  _
}
import com.twitter.finagle.stats.{NullStatsReceiver, StatsReceiver}
import com.twitter.finagle.thrift.RichServerParam
import com.twitter.io.Buf
import com.twitter.util.Future
import org.apache.thrift.protocol._
import org.apache.thrift.TApplicationException
import org.apache.thrift.transport.TMemoryInputTransport


@javax.annotation.Generated(value = Array("com.twitter.scrooge.Compiler"))
class Scribe$FinagleService(
  iface: Scribe.MethodPerEndpoint,
  serverParam: RichServerParam
) extends com.twitter.finagle.Service[Array[Byte], Array[Byte]] {
  import Scribe._

  @deprecated("Use com.twitter.finagle.thrift.RichServerParam", "2017-08-16")
  def this(
    iface: Scribe.MethodPerEndpoint,
    protocolFactory: TProtocolFactory,
    stats: StatsReceiver = NullStatsReceiver,
    maxThriftBufferSize: Int = Thrift.param.maxThriftBufferSize,
    serviceName: String = "Scribe"
  ) = this(iface, RichServerParam(protocolFactory, serviceName, maxThriftBufferSize, stats))

  @deprecated("Use com.twitter.finagle.thrift.RichServerParam", "2017-08-16")
  def this(
    iface: Scribe.MethodPerEndpoint,
    protocolFactory: TProtocolFactory,
    stats: StatsReceiver,
    maxThriftBufferSize: Int
  ) = this(iface, protocolFactory, stats, maxThriftBufferSize, "Scribe")

  @deprecated("Use com.twitter.finagle.thrift.RichServerParam", "2017-08-16")
  def this(
    iface: Scribe.MethodPerEndpoint,
    protocolFactory: TProtocolFactory
  ) = this(iface, protocolFactory, NullStatsReceiver, Thrift.param.maxThriftBufferSize)

  def serviceName: String = serverParam.serviceName
  private[this] val filters: Filter = new Filter(serverParam)

  private[this] def protocolFactory: TProtocolFactory = serverParam.restrictedProtocolFactory

  protected val serviceMap: _root_.scala.collection.mutable.HashMap[String, _root_.com.twitter.finagle.Service[(TProtocol, Int), Array[Byte]]] =
    new _root_.scala.collection.mutable.HashMap[String, _root_.com.twitter.finagle.Service[(TProtocol, Int), Array[Byte]]]()

  protected def addService(name: String, service: _root_.com.twitter.finagle.Service[(TProtocol, Int), Array[Byte]]): Unit = {
    serviceMap(name) = service
  }

  final def apply(request: Array[Byte]): Future[Array[Byte]] = {
    val iprot = protocolFactory.getProtocol(new TMemoryInputTransport(request))

    try {
      val msg = iprot.readMessageBegin()
      val svcOpt = serviceMap.get(msg.name)
      if (svcOpt.isDefined) {
        svcOpt.get.apply((iprot, msg.seqid))
      } else {
        TProtocolUtil.skip(iprot, TType.STRUCT)
        invalidMethodNameFuture(msg)
      }
    } catch {
      case e: Exception => Future.exception(e)
    }
  }

  private[this] def invalidMethodNameFuture(msg: TMessage): Future[Array[Byte]] = {
     Future.value(Buf.ByteArray.Owned.extract(
       filters.exception(msg.name, msg.seqid, TApplicationException.UNKNOWN_METHOD,
         "Invalid method name: '" + msg.name + "'")))
  }
  // ---- end boilerplate.

  addService("Log", {
    val methodService = new _root_.com.twitter.finagle.Service[Log.Args, Log.SuccessType] {
      def apply(args: Log.Args): Future[Log.SuccessType] = {
        _root_.com.twitter.finagle.thrift.ServerAnnotations.annotate("Log", "com.twitter.finagle.thrift.scribe.thriftscala.Scribe#log()")
        iface.log(args.messages)
      }
    }
  
    filters.log.andThen(methodService)
  })
}