/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thrift;

import com.twitter.finagle.Thrift$param$;
import com.twitter.finagle.service.ReqRep;
import com.twitter.finagle.service.ResponseClass;
import com.twitter.finagle.service.ResponseClassifier$;
import com.twitter.finagle.stats.ClientStatsReceiver$;
import com.twitter.finagle.stats.LazyStatsReceiver;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.thrift.Protocols$;
import com.twitter.finagle.thrift.RichClientParam;
import com.twitter.scrooge.TReusableBuffer;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple7;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class RichClientParam$
implements scala.Serializable {
    public static RichClientParam$ MODULE$;
    private final Function0<TReusableBuffer> NO_THRIFT_REUSABLE_BUFFER_FACTORY;

    static {
        new RichClientParam$();
    }

    public Function0<TReusableBuffer> NO_THRIFT_REUSABLE_BUFFER_FACTORY() {
        return this.NO_THRIFT_REUSABLE_BUFFER_FACTORY;
    }

    public RichClientParam apply(TProtocolFactory protocolFactory, String serviceName, int maxThriftBufferSize, Function0<TReusableBuffer> thriftReusableBufferFactory, PartialFunction<ReqRep, ResponseClass> responseClassifier, StatsReceiver clientStats, boolean perEndpointStats) {
        return new RichClientParam(protocolFactory, serviceName, maxThriftBufferSize, thriftReusableBufferFactory, responseClassifier, (StatsReceiver)new LazyStatsReceiver(clientStats), perEndpointStats);
    }

    public RichClientParam apply(TProtocolFactory protocolFactory, String serviceName, int maxThriftBufferSize, PartialFunction<ReqRep, ResponseClass> responseClassifier, StatsReceiver clientStats) {
        TProtocolFactory x$1 = protocolFactory;
        String x$2 = serviceName;
        int x$3 = maxThriftBufferSize;
        PartialFunction<ReqRep, ResponseClass> x$4 = responseClassifier;
        StatsReceiver x$5 = clientStats;
        boolean x$6 = false;
        Function0<TReusableBuffer> x$7 = this.apply$default$4();
        return this.apply(x$1, x$2, x$3, x$7, x$4, x$5, x$6);
    }

    public RichClientParam apply(TProtocolFactory protocolFactory, int maxThriftBufferSize, PartialFunction<ReqRep, ResponseClass> responseClassifier) {
        return this.apply(protocolFactory, "", maxThriftBufferSize, responseClassifier, (StatsReceiver)ClientStatsReceiver$.MODULE$);
    }

    public RichClientParam apply(TProtocolFactory protocolFactory, PartialFunction<ReqRep, ResponseClass> responseClassifier) {
        return this.apply(protocolFactory, Thrift$param$.MODULE$.maxThriftBufferSize(), responseClassifier);
    }

    public RichClientParam apply(TProtocolFactory protocolFactory) {
        return this.apply(protocolFactory, (PartialFunction<ReqRep, ResponseClass>)ResponseClassifier$.MODULE$.Default());
    }

    public RichClientParam apply() {
        return this.apply(Thrift$param$.MODULE$.protocolFactory());
    }

    public TProtocolFactory apply$default$1() {
        return Thrift$param$.MODULE$.protocolFactory();
    }

    public String apply$default$2() {
        return "";
    }

    public int apply$default$3() {
        return Thrift$param$.MODULE$.maxThriftBufferSize();
    }

    public Function0<TReusableBuffer> apply$default$4() {
        return this.NO_THRIFT_REUSABLE_BUFFER_FACTORY();
    }

    public PartialFunction<ReqRep, ResponseClass> apply$default$5() {
        return ResponseClassifier$.MODULE$.Default();
    }

    public StatsReceiver apply$default$6() {
        return ClientStatsReceiver$.MODULE$;
    }

    public boolean apply$default$7() {
        return false;
    }

    public TReusableBuffer createThriftReusableBuffer(int thriftBufferSize) {
        return new TReusableBuffer(thriftBufferSize, thriftBufferSize);
    }

    public int createThriftReusableBuffer$default$1() {
        return Thrift$param$.MODULE$.maxThriftBufferSize();
    }

    public TProtocolFactory restrictedProtocolFactory(TProtocolFactory protocolFactory) {
        TProtocolFactory tProtocolFactory;
        if (Protocols$.MODULE$.SysPropStringLengthLimit().isDefined() || Protocols$.MODULE$.SysPropContainerLengthLimit().isDefined()) {
            TBinaryProtocol.Factory factory;
            TProtocolFactory tProtocolFactory2 = protocolFactory;
            if (tProtocolFactory2 instanceof TBinaryProtocol.Factory) {
                TBinaryProtocol.Factory factory2 = (TBinaryProtocol.Factory)tProtocolFactory2;
                factory = this.restrictedTBinaryProtocolFactory(factory2);
            } else if (tProtocolFactory2 instanceof TCompactProtocol.Factory) {
                TCompactProtocol.Factory factory3 = (TCompactProtocol.Factory)tProtocolFactory2;
                factory = this.restrictedTCompactProtocolFactory(factory3);
            } else {
                factory = tProtocolFactory2;
            }
            tProtocolFactory = factory;
        } else {
            tProtocolFactory = protocolFactory;
        }
        return tProtocolFactory;
    }

    private TBinaryProtocol.Factory restrictedTBinaryProtocolFactory(TBinaryProtocol.Factory tbf) {
        TBinaryProtocol.Factory factory;
        try {
            Field strictReadField = tbf.getClass().getDeclaredField("strictRead_");
            strictReadField.setAccessible(true);
            boolean strictRead = BoxesRunTime.unboxToBoolean((Object)strictReadField.get(tbf));
            Field strictWriteField = tbf.getClass().getDeclaredField("strictWrite_");
            strictWriteField.setAccessible(true);
            boolean strictWrite = BoxesRunTime.unboxToBoolean((Object)strictWriteField.get(tbf));
            Field stringLengthLimitField = tbf.getClass().getDeclaredField("stringLengthLimit_");
            stringLengthLimitField.setAccessible(true);
            long stringLengthLimit = BoxesRunTime.unboxToLong((Object)Protocols$.MODULE$.minLimit(Protocols$.MODULE$.limitToOption(BoxesRunTime.unboxToLong((Object)stringLengthLimitField.get(tbf))), Protocols$.MODULE$.SysPropStringLengthLimit()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Protocols$.MODULE$.NoLimit()));
            Field containerLengthLimitField = tbf.getClass().getDeclaredField("containerLengthLimit_");
            containerLengthLimitField.setAccessible(true);
            long containerLengthLimit = BoxesRunTime.unboxToLong((Object)Protocols$.MODULE$.minLimit(Protocols$.MODULE$.limitToOption(BoxesRunTime.unboxToLong((Object)containerLengthLimitField.get(tbf))), Protocols$.MODULE$.SysPropContainerLengthLimit()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Protocols$.MODULE$.NoLimit()));
            factory = new TBinaryProtocol.Factory(strictRead, strictWrite, stringLengthLimit, containerLengthLimit);
        }
        catch (Throwable throwable) {
            Logger.getLogger("finagle-thrift").log(Level.WARNING, "System Property length limits are not applied on ProtocolFactory");
            factory = tbf;
        }
        return factory;
    }

    private TCompactProtocol.Factory restrictedTCompactProtocolFactory(TCompactProtocol.Factory tcf) {
        TCompactProtocol.Factory factory;
        try {
            Field stringLengthLimitField = tcf.getClass().getDeclaredField("stringLengthLimit_");
            stringLengthLimitField.setAccessible(true);
            long stringLengthLimit = BoxesRunTime.unboxToLong((Object)Protocols$.MODULE$.minLimit(Protocols$.MODULE$.limitToOption(BoxesRunTime.unboxToLong((Object)stringLengthLimitField.get(tcf))), Protocols$.MODULE$.SysPropStringLengthLimit()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Protocols$.MODULE$.NoLimit()));
            Field containerLengthLimitField = tcf.getClass().getDeclaredField("containerLengthLimit_");
            containerLengthLimitField.setAccessible(true);
            long containerLengthLimit = BoxesRunTime.unboxToLong((Object)Protocols$.MODULE$.minLimit(Protocols$.MODULE$.limitToOption(BoxesRunTime.unboxToLong((Object)containerLengthLimitField.get(tcf))), Protocols$.MODULE$.SysPropContainerLengthLimit()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Protocols$.MODULE$.NoLimit()));
            factory = new TCompactProtocol.Factory(stringLengthLimit, containerLengthLimit);
        }
        catch (Throwable throwable) {
            Logger.getLogger("finagle-thrift").log(Level.WARNING, "System Property length limits are not applied on ProtocolFactory");
            factory = tcf;
        }
        return factory;
    }

    public Option<Tuple7<TProtocolFactory, String, Object, Function0<TReusableBuffer>, PartialFunction<ReqRep, ResponseClass>, StatsReceiver, Object>> unapply(RichClientParam x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.protocolFactory(), (Object)x$0.serviceName(), (Object)BoxesRunTime.boxToInteger((int)x$0.maxThriftBufferSize()), x$0.thriftReusableBufferFactory(), x$0.responseClassifier(), (Object)x$0.clientStats(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.perEndpointStats())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RichClientParam$() {
        MODULE$ = this;
        int n = this.createThriftReusableBuffer$default$1();
        this.NO_THRIFT_REUSABLE_BUFFER_FACTORY = (Function0 & Serializable & scala.Serializable)() -> MODULE$.createThriftReusableBuffer(n);
    }
}

