/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.thriftmux.pushsession;

import com.twitter.finagle.Failure;
import com.twitter.finagle.Failure$;
import com.twitter.finagle.Mux;
import com.twitter.finagle.Service;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Status;
import com.twitter.finagle.Thrift;
import com.twitter.finagle.mux.Request;
import com.twitter.finagle.mux.Response;
import com.twitter.finagle.mux.pushsession.MessageWriter;
import com.twitter.finagle.mux.pushsession.MuxChannelHandle;
import com.twitter.finagle.mux.pushsession.MuxMessageDecoder;
import com.twitter.finagle.mux.pushsession.Negotiation;
import com.twitter.finagle.mux.pushsession.SharedNegotiationStats;
import com.twitter.finagle.mux.transport.BadMessageException;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.param.Timer;
import com.twitter.finagle.param.Timer$;
import com.twitter.finagle.pushsession.PushChannelHandle;
import com.twitter.finagle.pushsession.PushSession;
import com.twitter.finagle.pushsession.RefPushSession;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.thrift.InputBuffer;
import com.twitter.finagle.thrift.OutputBuffer;
import com.twitter.finagle.thrift.OutputBuffer$;
import com.twitter.finagle.thrift.ThriftTracing$;
import com.twitter.finagle.thrift.thrift.ResponseHeader;
import com.twitter.finagle.thrift.thrift.UpgradeReply;
import com.twitter.finagle.thriftmux.pushsession.MuxDowngradingNegotiator$;
import com.twitter.finagle.thriftmux.pushsession.VanillaThriftSession;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.io.ByteReader$;
import com.twitter.util.Closable;
import com.twitter.util.Closable$;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import java.io.Serializable;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocolFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015c!B\u0012%\u0005!r\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"Aq\u000b\u0001B\u0001B\u0003%\u0001\fC\u0003c\u0001\u0011\u00051\r\u0003\u0004l\u0001\u0001\u0006I\u0001\u001c\u0005\u0007q\u0002\u0001\u000b\u0011B=\t\u000f}\u0004\u0001\u0015!\u0003\u0002\u0002!A\u0011q\u0001\u0001!\u0002\u0013\t\t\u0001C\u0004\u0002\n\u0001!\t!a\u0003\t\u0011\u0005u\u0001\u0001)C\u0005\u0003?Aq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002F\u0001!\t!a\u0012\t\u0011\u0005=\u0003\u0001)C\u0005\u0003#B\u0001\"a\u0016\u0001A\u0013%\u0011\u0011\f\u0005\t\u0003;\u0002\u0001\u0015\"\u0003\u0002`!A\u00111\r\u0001!\n\u0013\t)\u0007\u0003\u0005\u0002\f\u0002\u0001K\u0011BAG\u000f!\ty\n\nE\u0001Q\u0005\u0005faB\u0012%\u0011\u0003A\u00131\u0015\u0005\u0007EV!\t!a+\t\u0013\u00055VC1A\u0005\n\u0005=\u0006\u0002CA_+\u0001\u0006I!!-\u0007\r\u0005}VCBAa\u0011)\tI-\u0007B\u0001B\u0003%\u00111\u001a\u0005\t\u0005f\u0011\t\u0011)A\u0005\u0007\"A1*\u0007B\u0001B\u0003%A\n\u0003\u0005X3\t\u0005\t\u0015!\u0003Y\u0011\u0019\u0011\u0017\u0004\"\u0001\u0002R\u00161\u0011q\\\r!\u0003CDq!a:\u001a\t#\tI\u000fC\u0004\u0003\u0018e!\tF!\u0007\t\u000f\tER\u0003\"\u0001\u00034\tAR*\u001e=E_^twM]1eS:<g*Z4pi&\fGo\u001c:\u000b\u0005\u00152\u0013a\u00039vg\"\u001cXm]:j_:T!a\n\u0015\u0002\u0013QD'/\u001b4u[VD(BA\u0015+\u0003\u001d1\u0017N\\1hY\u0016T!a\u000b\u0017\u0002\u000fQ<\u0018\u000e\u001e;fe*\tQ&A\u0002d_6\u001c\"\u0001A\u0018\u0011\tA\u0012DGO\u0007\u0002c)\u0011Q\u0005K\u0005\u0003gE\u00121\u0002U;tQN+7o]5p]B\u0011Q\u0007O\u0007\u0002m)\u0011qGK\u0001\u0003S>L!!\u000f\u001c\u0003\u0015\tKH/\u001a*fC\u0012,'\u000f\u0005\u00026w%\u0011AH\u000e\u0002\u0004\u0005V4\u0017A\u0003:fMN+7o]5p]\u000e\u0001\u0001\u0003\u0002\u0019AiiJ!!Q\u0019\u0003\u001dI+g\rU;tQN+7o]5p]\u00061\u0001/\u0019:b[N\u0004\"\u0001\u0012%\u000f\u0005\u00153U\"\u0001\u0015\n\u0005\u001dC\u0013!B*uC\u000e\\\u0017BA%K\u0005\u0019\u0001\u0016M]1ng*\u0011q\tK\u0001\fg\"\f'/\u001a3Ti\u0006$8\u000f\u0005\u0002N#6\taJ\u0003\u0002&\u001f*\u0011\u0001\u000bK\u0001\u0004[VD\u0018B\u0001*O\u0005Y\u0019\u0006.\u0019:fI:+wm\u001c;jCRLwN\\*uCR\u001c\u0018A\u00025b]\u0012dW\r\u0005\u0002N+&\u0011aK\u0014\u0002\u0011\u001bVD8\t[1o]\u0016d\u0007*\u00198eY\u0016\fqa]3sm&\u001cW\r\u0005\u0003F3n{\u0016B\u0001.)\u0005\u001d\u0019VM\u001d<jG\u0016\u0004\"\u0001X/\u000e\u0003=K!AX(\u0003\u000fI+\u0017/^3tiB\u0011A\fY\u0005\u0003C>\u0013\u0001BU3ta>t7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u00114w\r[5k!\t)\u0007!D\u0001%\u0011\u0015id\u00011\u0001@\u0011\u0015\u0011e\u00011\u0001D\u0011\u0015Ye\u00011\u0001M\u0011\u0015\u0019f\u00011\u0001U\u0011\u00159f\u00011\u0001Y\u00035A\u0017M\u001c3tQ\u0006\\W\rR8oKB\u0019Q\u000e\u001d:\u000e\u00039T!a\u001c\u0016\u0002\tU$\u0018\u000e\\\u0005\u0003c:\u0014q\u0001\u0015:p[&\u001cX\r\u0005\u0002tm6\tAOC\u0001v\u0003\u0015\u00198-\u00197b\u0013\t9HO\u0001\u0003V]&$\u0018AA:s!\tQX0D\u0001|\u0015\ta\b&A\u0003ti\u0006$8/\u0003\u0002\u007fw\ni1\u000b^1ugJ+7-Z5wKJ\f\u0011\u0003\u001e5sS\u001a$X.\u001e=D_:tWm\u0019;t!\rQ\u00181A\u0005\u0004\u0003\u000bY(aB\"pk:$XM]\u0001\u0013I><hn\u001a:bI\u0016$7i\u001c8oK\u000e$8/A\u0003dY>\u001cX\r\u0006\u0003\u0002\u000e\u0005M\u0001\u0003B7\u0002\u0010IL1!!\u0005o\u0005\u00191U\u000f^;sK\"9\u0011QC\u0006A\u0002\u0005]\u0011\u0001\u00033fC\u0012d\u0017N\\3\u0011\u00075\fI\"C\u0002\u0002\u001c9\u0014A\u0001V5nK\u0006\u00112\r\\8tK^KG\u000f[#yG\u0016\u0004H/[8o)\u0011\ti!!\t\t\u000f\u0005\rB\u00021\u0001\u0002&\u0005\tA\u000f\u0005\u0003\u0002(\u0005]b\u0002BA\u0015\u0003gqA!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_q\u0014A\u0002\u001fs_>$h(C\u0001v\u0013\r\t)\u0004^\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI$a\u000f\u0003\u0013QC'o\\<bE2,'bAA\u001bi\u00069!/Z2fSZ,Gc\u0001:\u0002B!1\u00111I\u0007A\u0002Q\naA]3bI\u0016\u0014\u0018AB:uCR,8/\u0006\u0002\u0002JA\u0019Q)a\u0013\n\u0007\u00055\u0003F\u0001\u0004Ti\u0006$Xo]\u0001\u000fG\",7m\u001b#po:<'/\u00193f)\r\u0011\u00181\u000b\u0005\u0007\u0003+z\u0001\u0019\u0001\u001e\u0002\u0007\t,h-A\u0007j]&$H\u000b\u001b:jMRlU\u000f\u001f\u000b\u0004e\u0006m\u0003BBA+!\u0001\u0007!(A\nj]&$H\u000b\u001b:jMR$un\u001e8he\u0006$W\rF\u0002s\u0003CBa!!\u0016\u0012\u0001\u0004Q\u0014!D2iK\u000e\\G\u000bV<jiR,'\u000f\u0006\u0004\u0002h\u00055\u0014\u0011\u0012\t\u0004g\u0006%\u0014bAA6i\n9!i\\8mK\u0006t\u0007bBA8%\u0001\u0007\u0011\u0011O\u0001\u0010aJ|Go\\2pY\u001a\u000b7\r^8ssB!\u00111OAC\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014\u0001\u00039s_R|7m\u001c7\u000b\t\u0005m\u0014QP\u0001\u0007i\"\u0014\u0018N\u001a;\u000b\t\u0005}\u0014\u0011Q\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0015aA8sO&!\u0011qQA;\u0005A!\u0006K]8u_\u000e|GNR1di>\u0014\u0018\u0010\u0003\u0004\u0002VI\u0001\rAO\u0001\u0014e\u0016lw\u000e^3BI\u0012\u0014Xm]:TiJLgnZ\u000b\u0003\u0003\u001f\u0003B!!%\u0002\u001a:!\u00111SAK!\r\tY\u0003^\u0005\u0004\u0003/#\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0006u%AB*ue&twMC\u0002\u0002\u0018R\f\u0001$T;y\t><hn\u001a:bI&twMT3h_RL\u0017\r^8s!\t)WcE\u0002\u0016\u0003K\u00032a]AT\u0013\r\tI\u000b\u001e\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u0005\u0016a\u00017pOV\u0011\u0011\u0011\u0017\t\u0005\u0003g\u000bI,\u0004\u0002\u00026*\u0019\u0011q\u0017\u0016\u0002\u000f1|wmZ5oO&!\u00111XA[\u0005\u0019aunZ4fe\u0006!An\\4!\u0005Q!un\u001e8he\u0006$WMT3h_RL\u0017\r^5peN\u0019\u0011$a1\u0011\u00075\u000b)-C\u0002\u0002H:\u00131BT3h_RL\u0017\r^5p]\u0006qA\u000f^<jiR,'\u000fS3bI\u0016\u0014\b\u0003B:\u0002NjJ1!a4u\u0005\u0019y\u0005\u000f^5p]RQ\u00111[Al\u00033\fY.!8\u0011\u0007\u0005U\u0017$D\u0001\u0016\u0011\u001d\tIM\ba\u0001\u0003\u0017DQA\u0011\u0010A\u0002\rCQa\u0013\u0010A\u00021CQa\u0016\u0010A\u0002a\u0013\u0001bU3tg&|g\u000e\u0016\t\u0004K\u0006\r\u0018bAAsI\t!b+\u00198jY2\fG\u000b\u001b:jMR\u001cVm]:j_:\fAC\\3h_RL\u0017\r^3D_6\u0004(/Z:tS>tG#\u0002:\u0002l\u0006M\bBB*!\u0001\u0004\ti\u000fE\u00031\u0003_$$(C\u0002\u0002rF\u0012\u0011\u0003U;tQ\u000eC\u0017M\u001c8fY\"\u000bg\u000e\u001a7f\u0011\u001d\t)\u0010\ta\u0001\u0003o\f1\u0002]3fe\"+\u0017\rZ3sgB)1/!4\u0002zB!\u00111 B\t\u001d\u0011\tiP!\u0004\u000f\t\u0005}(1\u0002\b\u0005\u0005\u0003\u0011IA\u0004\u0003\u0003\u0004\t\u001da\u0002BA\u0016\u0005\u000bI\u0011!L\u0005\u0003W1J!!\u000b\u0016\n\u0005AC\u0013b\u0001B\b\u001f\u0006I\u0001*\u00198eg\"\f7.Z\u0005\u0005\u0005'\u0011)BA\u0004IK\u0006$WM]:\u000b\u0007\t=q*A\u0004ck&dG-\u001a:\u0015\u0011\u0005\u0005(1\u0004B\u000f\u0005OAaaU\u0011A\u0002\u00055\bb\u0002B\u0010C\u0001\u0007!\u0011E\u0001\u0007oJLG/\u001a:\u0011\u00075\u0013\u0019#C\u0002\u0003&9\u0013Q\"T3tg\u0006<Wm\u0016:ji\u0016\u0014\bb\u0002B\u0015C\u0001\u0007!1F\u0001\bI\u0016\u001cw\u000eZ3s!\ri%QF\u0005\u0004\u0005_q%!E'vq6+7o]1hK\u0012+7m\u001c3fe\u0006)!-^5mIRa!Q\u0007B\u001d\u0005{\u0011yD!\u0011\u0003D9!!q\u0007B\u001d\u0019\u0001AaAa\u000f#\u0001\u0004y\u0014a\u0001:fM\")!I\ta\u0001\u0007\")1J\ta\u0001\u0019\")1K\ta\u0001)\")qK\ta\u00011\u0002")
public final class MuxDowngradingNegotiator
extends PushSession<ByteReader, Buf> {
    private final RefPushSession<ByteReader, Buf> refSession;
    private final Stack.Params params;
    private final SharedNegotiationStats sharedStats;
    private final MuxChannelHandle handle;
    private final Service<Request, Response> service;
    private final Promise<BoxedUnit> handshakeDone;
    private final StatsReceiver sr;
    private final Counter thriftmuxConnects;
    private final Counter downgradedConnects;

    public static RefPushSession<ByteReader, Buf> build(RefPushSession<ByteReader, Buf> ref, Stack.Params params, SharedNegotiationStats sharedStats, MuxChannelHandle handle, Service<Request, Response> service) {
        return MuxDowngradingNegotiator$.MODULE$.build(ref, params, sharedStats, handle, service);
    }

    public Future<BoxedUnit> close(Time deadline) {
        return this.handshakeDone.by(deadline, ((Timer)this.params.apply(Timer$.MODULE$.param())).timer()).transform((Function1 & Serializable)x0$1 -> {
            Future<BoxedUnit> future;
            Try try_ = x0$1;
            if (try_ instanceof Return) {
                future = $this.refSession.close(deadline);
            } else if (try_ instanceof Throw) {
                Throw throw_ = (Throw)try_;
                Throwable t = throw_.e();
                future = this.closeWithException(t);
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Future<BoxedUnit> closeWithException(Throwable t) {
        void var2_2;
        Future f = Closable$.MODULE$.all((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Closable[]{this.handle, this.service})).close();
        this.handshakeDone.updateIfEmpty((Try)new Throw(t));
        return var2_2;
    }

    public void receive(ByteReader reader) {
        block6: {
            try {
                try {
                    Buf buf = reader.readAll();
                    this.checkDowngrade(buf);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        MuxDowngradingNegotiator$.MODULE$.com$twitter$finagle$thriftmux$pushsession$MuxDowngradingNegotiator$$log().error(ex, "Uncaught exception during mux downgrade negotiation. Closing session.", (Seq)Nil$.MODULE$);
                        this.closeWithException(ex);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    throw throwable;
                }
            }
            finally {
                reader.close();
            }
        }
    }

    public Status status() {
        return this.handle.status();
    }

    private void checkDowngrade(Buf buf) {
        Message.Rerr rerr;
        int n;
        Return return_;
        Message message;
        Message.Rerr rerr2;
        int n2;
        Return return_2;
        Message message2;
        Some some;
        Option option;
        Failure failure;
        Option option2;
        Throw throw_;
        Throwable throwable;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Message$.MODULE$.decode(buf));
        boolean bl = try_ instanceof Throw && (throwable = (throw_ = (Throw)try_).e()) instanceof Failure && !(option2 = Failure$.MODULE$.unapply(failure = (Failure)throwable)).isEmpty() && (option = (Option)option2.get()) instanceof Some && (some = (Some)option).value() instanceof BadMessageException ? true : (try_ instanceof Return && (message2 = (Message)(return_2 = (Return)try_).r()) instanceof Message.Rerr && 65537 == (n2 = (rerr2 = (Message.Rerr)message2).tag()) ? true : try_ instanceof Return && (message = (Message)(return_ = (Return)try_).r()) instanceof Message.Rerr && 65540 == (n = (rerr = (Message.Rerr)message).tag()));
        if (bl) {
            this.initThriftDowngrade(buf);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Return) {
            this.initThriftMux(buf);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Throw) {
            Throw throw_2 = (Throw)try_;
            Throwable exc = throw_2.e();
            String msg = new StringBuilder(34).append("Unable to determine the protocol. ").append(this.remoteAddressString()).toString();
            MuxDowngradingNegotiator$.MODULE$.com$twitter$finagle$thriftmux$pushsession$MuxDowngradingNegotiator$$log().info(exc, msg, (Seq)Nil$.MODULE$);
            this.closeWithException(exc);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private void initThriftMux(Buf buf) {
        this.thriftmuxConnects.incr();
        Mux.Server$.MODULE$.defaultSessionFactory().apply(this.refSession, (Object)this.params, (Object)this.sharedStats, (Object)this.handle, this.service);
        this.refSession.receive((Object)ByteReader$.MODULE$.apply(buf));
        this.handshakeDone.setDone((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void initThriftDowngrade(Buf buf) {
        this.downgradedConnects.incr();
        TProtocolFactory protocolFactory = ((Thrift.param$.ProtocolFactory)this.params.apply((Stack.Param)Thrift.param$.ProtocolFactory$.MODULE$)).protocolFactory();
        boolean isTTwitter = this.checkTTwitter(protocolFactory, buf);
        None$ ttwitterHeader = !isTTwitter ? None$.MODULE$ : new Some((Object)Buf.ByteArray$.Owned$.MODULE$.apply(OutputBuffer$.MODULE$.messageToArray((TBase)new ResponseHeader(), protocolFactory)));
        try {
            VanillaThriftSession nextSession = (VanillaThriftSession)new DowngradeNegotiatior((Option<Buf>)ttwitterHeader, this.params, this.sharedStats, this.service).negotiate((PushChannelHandle)this.handle, (Option)None$.MODULE$);
            this.refSession.updateRef((PushSession)nextSession);
            if (!isTTwitter) {
                this.refSession.receive((Object)ByteReader$.MODULE$.apply(buf));
            } else {
                OutputBuffer buffer = new OutputBuffer(protocolFactory);
                buffer.apply().writeMessageBegin(new TMessage(ThriftTracing$.MODULE$.CanTraceMethodName(), 2, 0));
                UpgradeReply upgradeReply = new UpgradeReply();
                upgradeReply.write(buffer.apply());
                buffer.apply().writeMessageEnd();
                this.handle.sendAndForget((Object)Buf.ByteArray$.Shared$.MODULE$.apply(buffer.toArray()));
            }
            this.handshakeDone.setDone((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable t = (Throwable)option.get();
                MuxDowngradingNegotiator$.MODULE$.com$twitter$finagle$thriftmux$pushsession$MuxDowngradingNegotiator$$log().warning(t, new StringBuilder(37).append("Negotiation failed. Closing session. ").append(this.remoteAddressString()).toString(), (Seq)Nil$.MODULE$);
                this.closeWithException(t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private boolean checkTTwitter(TProtocolFactory protocolFactory, Buf buf) {
        boolean bl;
        block5: {
            try {
                InputBuffer buffer = new InputBuffer(Buf.ByteArray$.Owned$.MODULE$.extract(buf), protocolFactory);
                TMessage msg = buffer.apply().readMessageBegin();
                if (msg.type == 1) {
                    String string = msg.name;
                    String string2 = ThriftTracing$.MODULE$.CanTraceMethodName();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        bl = true;
                        break block5;
                    }
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                boolean bl2 = false;
                bl = bl2;
            }
        }
        return bl;
    }

    private String remoteAddressString() {
        return new StringBuilder(8).append("Remote: ").append(this.handle.remoteAddress()).toString();
    }

    public MuxDowngradingNegotiator(RefPushSession<ByteReader, Buf> refSession, Stack.Params params, SharedNegotiationStats sharedStats, MuxChannelHandle handle, Service<Request, Response> service) {
        this.refSession = refSession;
        this.params = params;
        this.sharedStats = sharedStats;
        this.handle = handle;
        this.service = service;
        super((PushChannelHandle)handle);
        this.handshakeDone = Promise$.MODULE$.apply();
        this.sr = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
        this.thriftmuxConnects = this.sr.counter((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"thriftmux", "connects"}));
        this.downgradedConnects = this.sr.counter((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"thriftmux", "downgraded_connects"}));
        handle.onClose().ensure((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if ($this.handshakeDone.isDefined()) break block0;
                this.close();
            }
        });
    }

    private static final class DowngradeNegotiatior
    extends Negotiation {
        private final Option<Buf> ttwitterHeader;
        private final Stack.Params params;
        private final Service<Request, Response> service;

        public void negotiateCompression(PushChannelHandle<ByteReader, Buf> handle, Option<Seq<Tuple2<Buf, Buf>>> peerHeaders) {
        }

        public VanillaThriftSession builder(PushChannelHandle<ByteReader, Buf> handle, MessageWriter writer, MuxMessageDecoder decoder) {
            return new VanillaThriftSession(handle, this.ttwitterHeader, this.params, this.service);
        }

        public DowngradeNegotiatior(Option<Buf> ttwitterHeader, Stack.Params params, SharedNegotiationStats sharedStats, Service<Request, Response> service) {
            this.ttwitterHeader = ttwitterHeader;
            this.params = params;
            this.service = service;
            super(params, sharedStats, true);
        }
    }
}

