/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.internal.routing;

import com.twitter.finagle.http.Method;
import com.twitter.finatra.http.exceptions.UnsupportedMethodException;
import com.twitter.finatra.http.internal.routing.MatchedNonConstantRoute;
import com.twitter.finatra.http.internal.routing.MatchedNonConstantRoute$;
import com.twitter.finatra.http.internal.routing.PathPattern;
import com.twitter.finatra.http.internal.routing.PathPattern$;
import com.twitter.finatra.http.internal.routing.Route;
import com.twitter.finatra.http.internal.routing.RouteAndParameter;
import com.twitter.finatra.http.internal.routing.TrieNode;
import com.twitter.finatra.http.internal.routing.TrieNode$;
import com.twitter.finatra.http.request.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005y4Q!\u0003\u0006\u0001\u001dYA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006_\u0001!\t\u0001\r\u0005\u0007g\u0001\u0001\u000b\u0011\u0002\u001b\t\u000b]\u0002A\u0011\u0001\u001d\t\rI\u0003\u0001\u0015\"\u0003T\u0011\u0019\u0001\u0007\u0001)C\u0005C\"1\u0001\u000f\u0001Q\u0005\nEDa\u0001\u001f\u0001!\n\u0013I(\u0001\u0002+sS\u0016T!a\u0003\u0007\u0002\u000fI|W\u000f^5oO*\u0011QBD\u0001\tS:$XM\u001d8bY*\u0011q\u0002E\u0001\u0005QR$\bO\u0003\u0002\u0012%\u00059a-\u001b8biJ\f'BA\n\u0015\u0003\u001d!x/\u001b;uKJT\u0011!F\u0001\u0004G>l7C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u00061!o\\;uKN\u001c\u0001\u0001E\u0002!Q-r!!\t\u0014\u000f\u0005\t*S\"A\u0012\u000b\u0005\u0011r\u0012A\u0002\u001fs_>$h(C\u0001\u001b\u0013\t9\u0013$A\u0004qC\u000e\\\u0017mZ3\n\u0005%R#aA*fc*\u0011q%\u0007\t\u0003Y5j\u0011AC\u0005\u0003])\u0011QAU8vi\u0016\fa\u0001P5oSRtDCA\u00193!\ta\u0003\u0001C\u0003\u001e\u0005\u0001\u0007q$\u0001\u0003s_>$\bC\u0001\u00176\u0013\t1$B\u0001\u0005Ue&,gj\u001c3f\u0003\u00111\u0017N\u001c3\u0015\u0007ez\u0014\nE\u0002\u0019uqJ!aO\r\u0003\r=\u0003H/[8o!\taS(\u0003\u0002?\u0015\t\t\"k\\;uK\u0006sG\rU1sC6,G/\u001a:\t\u000b\u0001#\u0001\u0019A!\u0002\tA\fG\u000f\u001b\t\u0003\u0005\u001as!a\u0011#\u0011\u0005\tJ\u0012BA#\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011q\t\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015K\u0002\"\u0002&\u0005\u0001\u0004Y\u0015AB7fi\"|G\r\u0005\u0002M!6\tQJ\u0003\u0002\u0010\u001d*\u0011qJE\u0001\bM&t\u0017m\u001a7f\u0013\t\tVJ\u0001\u0004NKRDw\u000eZ\u0001\u0015M&tGMT8o\u0007>t7\u000f^1oiJ{W\u000f^3\u0015\u000bQ;\u0016LW.\u0011\u00051*\u0016B\u0001,\u000b\u0005]i\u0015\r^2iK\u0012tuN\\\"p]N$\u0018M\u001c;S_V$X\rC\u0003Y\u000b\u0001\u0007A'\u0001\u0003o_\u0012,\u0007\"\u0002&\u0006\u0001\u0004Y\u0005\"\u0002!\u0006\u0001\u0004\t\u0005\"\u0002/\u0006\u0001\u0004i\u0016AC:uCJ$\u0018J\u001c3fqB\u0011\u0001DX\u0005\u0003?f\u00111!\u00138u\u00031\t\u0007\u000f]3oI\"+G\u000e]3s)\u0011\u0011WM\u001a5\u0011\u0005a\u0019\u0017B\u00013\u001a\u0005\u0011)f.\u001b;\t\u000ba3\u0001\u0019\u0001\u001b\t\u000b\u001d4\u0001\u0019A\u0016\u0002\u000bI|W\u000f^3\t\u000bq3\u0001\u0019A/)\u0005\u0019Q\u0007CA6o\u001b\u0005a'BA7\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0003_2\u0014q\u0001^1jYJ,7-\u0001\bjg6\u000bGo\u00195fIJ{W\u000f^3\u0015\tI,ho\u001e\t\u00031ML!\u0001^\r\u0003\u000f\t{w\u000e\\3b]\")\u0001l\u0002a\u0001i!)qm\u0002a\u0001W!)\u0001i\u0002a\u0001\u0003\u0006YAo\\'bi\u000eD\u0007+\u0019;i)\r\t%\u0010 \u0005\u0006w\"\u0001\rA]\u0001\u0019Q\u0006\u001cx\n\u001d;j_:\fG\u000e\u0016:bS2LgnZ*mCND\u0007\"B?\t\u0001\u0004\t\u0015\u0001D5oG>l\u0017N\\4QCRD\u0007")
public class Trie {
    private final TrieNode root = new TrieNode("", TrieNode$.MODULE$.apply$default$2(), TrieNode$.MODULE$.apply$default$3(), TrieNode$.MODULE$.apply$default$4());

    public Option<RouteAndParameter> find(String path, Method method) {
        MatchedNonConstantRoute matchedNonConstantRoute = this.findNonConstantRoute(this.root, method, path, 1);
        if (matchedNonConstantRoute.routeAndParamOpt().isEmpty() && matchedNonConstantRoute.methodNotAllowed()) {
            throw new UnsupportedMethodException(new StringBuilder(35).append("The method ").append(method).append(" is not allowed on path ").append(path).toString());
        }
        return matchedNonConstantRoute.routeAndParamOpt();
    }

    private MatchedNonConstantRoute findNonConstantRoute(TrieNode node, Method method, String path, int startIndex) {
        MatchedNonConstantRoute matchedNonConstantRoute;
        int nextIndex = path.indexOf(47, startIndex);
        if (startIndex == 0 || startIndex >= path.length()) {
            if (node.routes().isEmpty()) {
                matchedNonConstantRoute = new MatchedNonConstantRoute(MatchedNonConstantRoute$.MODULE$.apply$default$1(), MatchedNonConstantRoute$.MODULE$.apply$default$2());
            } else {
                MatchedNonConstantRoute matchedNonConstantRoute2;
                Option option2 = node.routes().get((Object)method.name()).orElse((Function0 & Serializable)() -> node.routes().get((Object)package$.MODULE$.AnyMethod().name()));
                if (option2 instanceof Some) {
                    MatchedNonConstantRoute matchedNonConstantRoute3;
                    Some some = (Some)option2;
                    Route route = (Route)some.value();
                    if (this.isMatchedRoute(node, route, path)) {
                        String incomingPath = this.toMatchPath(route.hasOptionalTrailingSlash(), path);
                        Map matchedParams = (Map)((PathPattern)node.pattern().head()).extract(incomingPath).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
                        if (matchedParams.isEmpty()) {
                            matchedNonConstantRoute3 = new MatchedNonConstantRoute(MatchedNonConstantRoute$.MODULE$.apply$default$1(), MatchedNonConstantRoute$.MODULE$.apply$default$2());
                        } else {
                            Some routeAndParameter = new Some((Object)new RouteAndParameter(route, (Map<String, String>)matchedParams));
                            matchedNonConstantRoute3 = new MatchedNonConstantRoute((Option<RouteAndParameter>)routeAndParameter, MatchedNonConstantRoute$.MODULE$.apply$default$2());
                        }
                    } else {
                        matchedNonConstantRoute3 = new MatchedNonConstantRoute(MatchedNonConstantRoute$.MODULE$.apply$default$1(), MatchedNonConstantRoute$.MODULE$.apply$default$2());
                    }
                    matchedNonConstantRoute2 = matchedNonConstantRoute3;
                } else {
                    matchedNonConstantRoute2 = new MatchedNonConstantRoute((Option<RouteAndParameter>)None$.MODULE$, true);
                }
                matchedNonConstantRoute = matchedNonConstantRoute2;
            }
        } else {
            String currentSegment = nextIndex == -1 ? path.substring(startIndex, path.length()) : path.substring(startIndex, nextIndex);
            MatchedNonConstantRoute result = new MatchedNonConstantRoute(MatchedNonConstantRoute$.MODULE$.apply$default$1(), MatchedNonConstantRoute$.MODULE$.apply$default$2());
            boolean methodNotAllowed = false;
            Iterator childIterator = node.children().valuesIterator();
            while (childIterator.hasNext()) {
                TrieNode child = (TrieNode)childIterator.next();
                if (!result.routeAndParamOpt().isEmpty()) continue;
                if (child.constantSegment()) {
                    if (child.segment().endsWith("/") && child.segment().regionMatches(true, 0, currentSegment, 0, currentSegment.length())) {
                        result = this.findNonConstantRoute(child, method, path, nextIndex + 1);
                        methodNotAllowed = methodNotAllowed || result.methodNotAllowed();
                        continue;
                    }
                    if (!child.segment().equals(currentSegment)) continue;
                    result = this.findNonConstantRoute(child, method, path, nextIndex + 1);
                    methodNotAllowed = methodNotAllowed || result.methodNotAllowed();
                    continue;
                }
                if (StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(child.segment())) == '*') {
                    result = this.findNonConstantRoute(child, method, path, 0);
                    methodNotAllowed = methodNotAllowed || result.methodNotAllowed();
                    continue;
                }
                result = this.findNonConstantRoute(child, method, path, nextIndex + 1);
                methodNotAllowed = methodNotAllowed || result.methodNotAllowed();
            }
            matchedNonConstantRoute = new MatchedNonConstantRoute(result.routeAndParamOpt(), methodNotAllowed);
        }
        return matchedNonConstantRoute;
    }

    private void appendHelper(TrieNode node, Route route, int startIndex) {
        while (true) {
            String segment;
            BoxedUnit boxedUnit;
            String path = route.path();
            int nextIndex = path.indexOf(47, startIndex);
            if (startIndex == 0 || startIndex >= path.length()) {
                node.routes().update((Object)route.method().name(), (Object)route);
                node.pattern().$plus$eq((Object)PathPattern$.MODULE$.apply(path));
                boxedUnit = BoxedUnit.UNIT;
                break;
            }
            String string = segment = nextIndex == -1 || nextIndex == path.length() - 1 ? path.substring(startIndex, path.length()) : path.substring(startIndex, nextIndex);
            String string2 = ":*";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                node.routes().update((Object)route.method().name(), (Object)route);
                node.pattern().$plus$eq((Object)PathPattern$.MODULE$.apply(path));
                Option option2 = node.children().get((Object)"*");
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    TrieNode child = (TrieNode)some.value();
                    child.routes().update((Object)route.method().name(), (Object)route);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    node.children().update((Object)"*", (Object)new TrieNode("*", false, (AnyRefMap<String, Route>)AnyRefMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)route.method().name()), (Object)route)})), (ArrayBuffer<PathPattern>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PathPattern[]{PathPattern$.MODULE$.apply(path)})))));
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
                break;
            }
            String string3 = segment;
            String string4 = "";
            boolean isConstantSegment = !(string3 == null ? string4 != null : !string3.equals(string4)) || !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(segment), ':');
            String key = isConstantSegment ? segment : segment.substring(1);
            TrieNode child = (TrieNode)node.children().getOrElseUpdate((Object)key, (Function0 & Serializable)() -> new TrieNode(key, isConstantSegment, TrieNode$.MODULE$.apply$default$3(), TrieNode$.MODULE$.apply$default$4()));
            startIndex = nextIndex + 1;
            node = child;
        }
    }

    private boolean isMatchedRoute(TrieNode node, Route route, String path) {
        char storedPathLast = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(route.path()));
        boolean pathHasTrailingSlash = route.hasOptionalTrailingSlash() || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path)) == '/';
        boolean routeHasTrailingSlash = storedPathLast == '/';
        boolean matchedTrailingSlash = !(pathHasTrailingSlash ^ routeHasTrailingSlash);
        return matchedTrailingSlash || storedPathLast == '*';
    }

    private String toMatchPath(boolean hasOptionalTrailingSlash, String incomingPath) {
        return hasOptionalTrailingSlash && StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(incomingPath)) != '/' ? new StringBuilder(0).append(incomingPath).append('/').toString() : incomingPath;
    }

    public Trie(Seq<Route> routes) {
        routes.foreach((Function1 & Serializable)route -> {
            this.appendHelper(this.root, route, 1);
            return BoxedUnit.UNIT;
        });
    }
}

