/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.request;

import com.twitter.finagle.http.MediaType;
import java.util.HashMap;
import java.util.Map;

public enum ContentType {
    ALL("*/*"),
    CSS("text/css"),
    JSON(MediaType.Json()),
    HTML(MediaType.Html()),
    PLAIN(MediaType.PlainText()),
    XML(MediaType.Xml()),
    RSS(MediaType.Rss()),
    JAVASCRIPT(MediaType.Javascript()),
    GIF(MediaType.Gif()),
    FORM(MediaType.WwwForm()),
    OCTET_STREAM(MediaType.OctetStream()),
    JPEG(MediaType.Jpeg()),
    PNG(MediaType.Png()),
    XLS(MediaType.Xls()),
    CSV(MediaType.Csv()),
    ZIP(MediaType.Zip()),
    ATOM(MediaType.Atom()),
    WWWFORM(MediaType.WwwForm()),
    IFRAME(MediaType.Iframe());

    public final String contentTypeName;
    private static final Map<String, ContentType> CONTENT_TYPE_LOOKUP_MAP;

    private ContentType(String string2) {
        this.contentTypeName = string2;
    }

    public static ContentType fromString(String string) {
        return CONTENT_TYPE_LOOKUP_MAP.get(string);
    }

    public String toString() {
        return this.contentTypeName;
    }

    static {
        CONTENT_TYPE_LOOKUP_MAP = new HashMap<String, ContentType>();
        for (ContentType contentType : ContentType.values()) {
            CONTENT_TYPE_LOOKUP_MAP.put(contentType.contentTypeName, contentType);
        }
    }
}

