/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.jsonpatch;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.twitter.finatra.http.jsonpatch.JsonPatchException;
import com.twitter.finatra.http.jsonpatch.PatchOperation;
import com.twitter.finatra.json.FinatraObjectMapper;
import javax.inject.Inject;
import javax.inject.Singleton;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u00015\u0011\u0011CS:p]B\u000bGo\u00195Pa\u0016\u0014\u0018\r^8s\u0015\t\u0019A!A\u0005kg>t\u0007/\u0019;dQ*\u0011QAB\u0001\u0005QR$\bO\u0003\u0002\b\u0011\u00059a-\u001b8biJ\f'BA\u0005\u000b\u0003\u001d!x/\u001b;uKJT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\r5\f\u0007\u000f]3s!\t9\"$D\u0001\u0019\u0015\tIb!\u0001\u0003kg>t\u0017BA\u000e\u0019\u0005M1\u0015N\\1ue\u0006|%M[3di6\u000b\u0007\u000f]3s\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\u0011q$\t\t\u0003A\u0001i\u0011A\u0001\u0005\u0006+q\u0001\rA\u0006\u0015\u00039\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\r%t'.Z2u\u0015\u0005A\u0013!\u00026bm\u0006D\u0018B\u0001\u0016&\u0005\u0019IeN[3di\")A\u0006\u0001C\u0001[\u0005QAo\u001c&t_:tu\u000eZ3\u0016\u00059jDCA\u0018:!\t\u0001t'D\u00012\u0015\t\u00114'\u0001\u0005eCR\f'-\u001b8e\u0015\t!T'A\u0004kC\u000e\\7o\u001c8\u000b\u0005YR\u0011!\u00034bgR,'\u000f_7m\u0013\tA\u0014G\u0001\u0005Kg>tgj\u001c3f\u0011\u0015Q4\u00061\u0001<\u0003!y'/[4j]\u0006d\u0007C\u0001\u001f>\u0019\u0001!QAP\u0016C\u0002}\u0012\u0011\u0001V\t\u0003\u0001\u000e\u0003\"aD!\n\u0005\t\u0003\"a\u0002(pi\"Lgn\u001a\t\u0003\u001f\u0011K!!\u0012\t\u0003\u0007\u0005s\u0017\u0010C\u0003-\u0001\u0011\u0005q\t\u0006\u00020\u0011\")!H\u0012a\u0001\u0013B\u0011!*\u0014\b\u0003\u001f-K!\u0001\u0014\t\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019BAQ!\u0015\u0001\u0005\u0002I\u000b1!\u00193e)\r\u0019fk\u0017\t\u0003\u001fQK!!\u0016\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006/B\u0003\r\u0001W\u0001\u0006a\u0006$8\r\u001b\t\u0003AeK!A\u0017\u0002\u0003\u001dA\u000bGo\u00195Pa\u0016\u0014\u0018\r^5p]\")A\f\u0015a\u0001_\u00051A/\u0019:hKRDQA\u0018\u0001\u0005\u0002}\u000baA]3n_Z,GcA*aC\")q+\u0018a\u00011\")A,\u0018a\u0001_!)1\r\u0001C\u0001I\u00069!/\u001a9mC\u000e,GcA*fM\")qK\u0019a\u00011\")AL\u0019a\u0001_!)\u0001\u000e\u0001C\u0001S\u0006!Qn\u001c<f)\r\u0019&n\u001b\u0005\u0006/\u001e\u0004\r\u0001\u0017\u0005\u00069\u001e\u0004\ra\f\u0005\u0006[\u0002!\tA\\\u0001\u0005G>\u0004\u0018\u0010F\u0002T_BDQa\u00167A\u0002aCQ\u0001\u00187A\u0002=BQA\u001d\u0001\u0005\u0002M\fA\u0001^3tiR\u00191\u000b^;\t\u000b]\u000b\b\u0019\u0001-\t\u000bq\u000b\b\u0019A\u0018\t\u000f]\u0004!\u0019!C\u0005q\u0006\u0011B.Y:u\u000b2,W.\u001a8u!>Lg\u000e^3s+\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?4\u0003\u0011\u0019wN]3\n\u0005y\\(a\u0003&t_:\u0004v.\u001b8uKJDq!!\u0001\u0001A\u0003%\u00110A\nmCN$X\t\\3nK:$\bk\\5oi\u0016\u0014\b\u0005C\u0004\u0002\u0006\u0001!I!a\u0002\u0002\u0015\rDWmY6C_VtG\rF\u0003T\u0003\u0013\ti\u0001C\u0004\u0002\f\u0005\r\u0001\u0019A%\u0002\u0013=\u0004XM]1uS>t\u0007\u0002CA\b\u0003\u0007\u0001\r!!\u0005\u0002\u0013\r|g\u000eZ5uS>t\u0007cA\b\u0002\u0014%\u0019\u0011Q\u0003\t\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0011\u0001D4fi2+\u0017MZ%oI\u0016DH\u0003CA\u000f\u0003G\t9#!\u000e\u0011\u0007=\ty\"C\u0002\u0002\"A\u00111!\u00138u\u0011\u001d\t)#a\u0006A\u0002e\fA\u0001]1uQ\"9A,a\u0006A\u0002\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0012'\u0001\u0003o_\u0012,\u0017\u0002BA\u001a\u0003[\u0011\u0011\"\u0011:sCftu\u000eZ3\t\u000f\u0005-\u0011q\u0003a\u0001\u0013\"9\u0011\u0011\b\u0001\u0005\n\u0005m\u0012A\u00048fqRtu\u000eZ3CsB\u000bG\u000f\u001b\u000b\b_\u0005u\u0012qHA!\u0011\u001d\t)#a\u000eA\u0002eDa\u0001XA\u001c\u0001\u0004y\u0003bBA\u0006\u0003o\u0001\r!\u0013\u0005\b\u0003\u000b\u0002A\u0011BA$\u0003-\u0019\u0018MZ3HKRtu\u000eZ3\u0015\u000f=\nI%a\u0013\u0002N!9\u0011QEA\"\u0001\u0004I\bB\u0002/\u0002D\u0001\u0007q\u0006C\u0004\u0002\f\u0005\r\u0003\u0019A%)\t\u0005\r\u0013\u0011\u000b\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011q\u000b\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\\\u0005U#a\u0002;bS2\u0014Xm\u0019\u0005\b\u0003?\u0002A\u0011BA1\u0003\u001d\tG\r\u001a(pI\u0016$raUA2\u0003K\nI\u0007C\u0004\u0002&\u0005u\u0003\u0019A=\t\u000f\u0005\u001d\u0014Q\fa\u0001_\u0005)a/\u00197vK\"1A,!\u0018A\u0002=BC!!\u0018\u0002R!9\u0011q\u000e\u0001\u0005\n\u0005E\u0014A\u0003:f[>4XMT8eKR)1+a\u001d\u0002v!9\u0011QEA7\u0001\u0004I\bB\u0002/\u0002n\u0001\u0007q\u0006\u000b\u0003\u0002n\u0005E\u0003bBA>\u0001\u0011%\u0011QP\u0001\fe\u0016\u0004H.Y2f\u001d>$W\rF\u0004T\u0003\u007f\n\t)a!\t\u000f\u0005\u0015\u0012\u0011\u0010a\u0001s\"9\u0011qMA=\u0001\u0004y\u0003B\u0002/\u0002z\u0001\u0007q\u0006\u000b\u0003\u0002z\u0005E\u0003bBAE\u0001\u0011%\u00111R\u0001\t[>4XMT8eKR91+!$\u0002\u0010\u0006E\u0005bBA\u0013\u0003\u000f\u0003\r!\u001f\u0005\u00079\u0006\u001d\u0005\u0019A\u0018\t\u000f\u0005M\u0015q\u0011a\u0001s\u0006!aM]8n\u0011\u001d\t9\n\u0001C\u0005\u00033\u000b\u0001bY8qs:{G-\u001a\u000b\b'\u0006m\u0015QTAP\u0011\u001d\t)#!&A\u0002eDa\u0001XAK\u0001\u0004y\u0003bBAJ\u0003+\u0003\r!\u001f\u0005\b\u0003G\u0003A\u0011BAS\u0003!!Xm\u001d;O_\u0012,GcB*\u0002(\u0006%\u00161\u0016\u0005\b\u0003K\t\t\u000b1\u0001z\u0011\u0019a\u0016\u0011\u0015a\u0001_!9\u0011qMAQ\u0001\u0004y\u0003f\u0001\u0001\u00020B\u0019A%!-\n\u0007\u0005MVEA\u0005TS:<G.\u001a;p]\u0002")
public class JsonPatchOperator {
    private final FinatraObjectMapper mapper;
    private final JsonPointer lastElementPointer;

    public <T> JsonNode toJsonNode(T original) {
        String str = this.mapper.writeValueAsString(original);
        return (JsonNode)this.mapper.parse(str, ManifestFactory$.MODULE$.classType(JsonNode.class));
    }

    public JsonNode toJsonNode(String original) {
        return (JsonNode)this.mapper.parse(original, ManifestFactory$.MODULE$.classType(JsonNode.class));
    }

    public void add(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option2 = patch2.value();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            JsonNode v = (JsonNode)some.x();
            this.addNode(patch2.path(), v, target);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for add operation");
    }

    public void remove(PatchOperation patch2, JsonNode target) {
        this.removeNode(patch2.path(), target);
    }

    public void replace(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option2 = patch2.value();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            JsonNode v = (JsonNode)some.x();
            this.replaceNode(patch2.path(), v, target);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for replace operation");
    }

    public void move(PatchOperation patch2, JsonNode target) {
        Option<JsonPointer> option2 = patch2.from();
        if (option2 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option2;
            JsonPointer f = (JsonPointer)some.x();
            JsonPointer jsonPointer = patch2.path();
            JsonPointer jsonPointer2 = f;
            if (!(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.moveNode(patch2.path(), target, f);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new JsonPatchException("invalid from for move operation");
    }

    public void copy(PatchOperation patch2, JsonNode target) {
        Option<JsonPointer> option2 = patch2.from();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            JsonPointer f = (JsonPointer)some.x();
            this.copyNode(patch2.path(), target, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid from for copy operation");
    }

    public void test(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option2 = patch2.value();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            JsonNode v = (JsonNode)some.x();
            this.testNode(patch2.path(), target, v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for test operation");
    }

    private JsonPointer lastElementPointer() {
        return this.lastElementPointer;
    }

    private void checkBound(String operation, boolean condition) {
        if (((Object)BoxesRunTime.boxToBoolean((boolean)condition)).equals(BoxesRunTime.boxToBoolean((boolean)true))) {
            return;
        }
        throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid path for ", " operation, array index out of bounds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
    }

    private int getLeafIndex(JsonPointer path, ArrayNode target, String operation) {
        JsonPointer jsonPointer = path;
        JsonPointer jsonPointer2 = this.lastElementPointer();
        int index = !(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null) ? target.size() - 1 : path.getMatchingIndex();
        this.checkBound(operation, index < target.size() && index >= 0);
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonNode nextNodeByPath(JsonPointer path, JsonNode target, String operation) {
        JsonNode jsonNode = target;
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            if (!path.mayMatchElement()) throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid path for ", " operation, expected array index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
            int index = path.getMatchingIndex();
            this.checkBound(operation, index < arrayNode.size() && index >= 0);
            return arrayNode.get(index);
        }
        if (jsonNode != null) return target.get(path.getMatchingProperty());
        throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid target for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
    }

    private JsonNode safeGetNode(JsonPointer path, JsonNode target, String operation) {
        while (true) {
            block5: {
                block8: {
                    JsonNode jsonNode;
                    block7: {
                        JsonNode jsonNode2;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid path for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode2 = target;
                            if (!(jsonNode2 instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode2;
                            jsonNode = objectNode.get(path.getMatchingProperty());
                            break block7;
                        }
                        if (!(jsonNode2 instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode2;
                        jsonNode = arrayNode.get(this.getLeafIndex(path, arrayNode, operation));
                    }
                    return jsonNode;
                }
                throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid target for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
            }
            JsonNode jsonNode = this.nextNodeByPath(path, target, operation);
            target = jsonNode;
            path = path.tail();
        }
    }

    private void addNode(JsonPointer path, JsonNode value, JsonNode target) {
        while (true) {
            block5: {
                block8: {
                    block7: {
                        JsonNode jsonNode;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException("invalid path for add operation");
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode = target;
                            if (!(jsonNode instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode;
                            objectNode.set(path.getMatchingProperty(), value);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (!(jsonNode instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        JsonPointer jsonPointer = path;
                        JsonPointer jsonPointer2 = this.lastElementPointer();
                        int index = !(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null) ? arrayNode.size() : path.getMatchingIndex();
                        this.checkBound("add", index <= arrayNode.size() && index >= 0);
                        arrayNode.insert(index, value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new JsonPatchException("invalid target for add");
            }
            target = this.nextNodeByPath(path, target, "add");
            path = path.tail();
        }
    }

    private void removeNode(JsonPointer path, JsonNode target) {
        while (true) {
            block5: {
                block8: {
                    block7: {
                        JsonNode jsonNode;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException("invalid path for remove operation");
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode = target;
                            if (!(jsonNode instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode;
                            objectNode.remove(path.getMatchingProperty());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (!(jsonNode instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        arrayNode.remove(this.getLeafIndex(path, arrayNode, "remove"));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new JsonPatchException("invalid target for remove");
            }
            target = this.nextNodeByPath(path, target, "remove");
            path = path.tail();
        }
    }

    private void replaceNode(JsonPointer path, JsonNode value, JsonNode target) {
        while (true) {
            block5: {
                block8: {
                    block7: {
                        JsonNode jsonNode;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException("invalid path for replace operation");
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode = target;
                            if (!(jsonNode instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode;
                            objectNode.set(path.getMatchingProperty(), value);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (!(jsonNode instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        arrayNode.set(this.getLeafIndex(path, arrayNode, "replace"), value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new JsonPatchException("invalid target for replace");
            }
            target = this.nextNodeByPath(path, target, "replace");
            path = path.tail();
        }
    }

    private void moveNode(JsonPointer path, JsonNode target, JsonPointer from) {
        JsonNode nodeToMove = this.safeGetNode(from, target, "move");
        this.removeNode(from, target);
        this.addNode(path, nodeToMove, target);
    }

    private void copyNode(JsonPointer path, JsonNode target, JsonPointer from) {
        this.addNode(path, this.safeGetNode(from, target, "copy"), target);
    }

    private void testNode(JsonPointer path, JsonNode target, JsonNode value) {
        JsonNode jsonNode = this.safeGetNode(path, target, "test");
        JsonNode jsonNode2 = value;
        if (!(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null)) {
            return;
        }
        throw new JsonPatchException("test operation failed");
    }

    @Inject
    public JsonPatchOperator(FinatraObjectMapper mapper2) {
        this.mapper = mapper2;
        this.lastElementPointer = JsonPointer.compile((String)"/-");
    }
}

