/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.request;

import com.google.common.net.MediaType;
import com.twitter.finagle.http.Request;
import com.twitter.finatra.http.HttpHeaders$;
import com.twitter.finatra.http.exceptions.BadRequestException;
import com.twitter.finatra.http.exceptions.NotAcceptableException;
import com.twitter.finatra.http.fileupload.FinagleRequestFileUpload;
import com.twitter.finatra.http.fileupload.MultipartItem;
import com.twitter.finatra.http.request.ContentType;
import com.twitter.finatra.http.request.MediaRange;
import com.twitter.finatra.http.request.MediaRange$parseAndSort$;
import com.twitter.inject.conversions.string;
import com.twitter.inject.conversions.string$;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class RequestUtils$ {
    public static final RequestUtils$ MODULE$;

    static {
        new RequestUtils$();
    }

    public String pathUrl(Request request) {
        String scheme = this.getScheme(request);
        String hostHeader = this.getHost(request);
        String pathWithTrailingSlash = request.path().endsWith("/") ? request.path() : new StringBuilder().append((Object)request.path()).append((Object)"/").toString();
        return new StringBuilder().append((Object)scheme).append((Object)"://").append((Object)hostHeader).append((Object)pathWithTrailingSlash).toString();
    }

    public String normalizedURIWithoutScheme(URI uri, Request request) {
        URI normalizedURI = uri.normalize();
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getScheme(request)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"//", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getAuthority(request, normalizedURI)}))).append((Object)this.getPath(request, normalizedURI.getPath())).append((Object)this.getQuery(normalizedURI)).append((Object)this.getFragment(normalizedURI)).toString();
    }

    private String getScheme(Request request) {
        String string2;
        Option option2 = request.headerMap().get("x-forwarded-proto");
        if (option2 instanceof Some) {
            String protocol;
            Some some = (Some)option2;
            string2 = protocol = (String)some.x();
        } else {
            string2 = "http";
        }
        return string2;
    }

    private String getAuthority(Request request, URI uri) {
        String string2;
        Option option2 = string.RichString$.MODULE$.toOption$extension(string$.MODULE$.RichString(uri.getAuthority()));
        if (option2 instanceof Some) {
            String authority;
            Some some = (Some)option2;
            string2 = authority = (String)some.x();
        } else {
            string2 = this.getHost(request);
        }
        return string2;
    }

    private String getHost(Request request) {
        Option option2 = request.host();
        if (option2 instanceof Some) {
            String host;
            Some some = (Some)option2;
            String string2 = host = (String)some.x();
            return string2;
        }
        throw new BadRequestException("Host header not set");
    }

    private String getPath(Request request, String requestPath) {
        String string2;
        Option option2 = string.RichString$.MODULE$.toOption$extension(string$.MODULE$.RichString(requestPath));
        if (option2 instanceof Some) {
            String string3;
            Some some = (Some)option2;
            String path = (String)some.x();
            if (path.startsWith("/")) {
                string3 = path;
            } else {
                String pathWithTrailingSlash = request.path().endsWith("/") ? request.path() : new StringBuilder().append((Object)request.path()).append((Object)"/").toString();
                string3 = new StringBuilder().append((Object)pathWithTrailingSlash).append((Object)path).toString();
            }
            string2 = string3;
        } else {
            string2 = "";
        }
        return string2;
    }

    private String getQuery(URI uri) {
        String string2;
        Option option2 = string.RichString$.MODULE$.toOption$extension(string$.MODULE$.RichString(uri.getQuery()));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String query = (String)some.x();
            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"?", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query}));
        } else {
            string2 = "";
        }
        return string2;
    }

    private String getFragment(URI uri) {
        String string2;
        Option option2 = string.RichString$.MODULE$.toOption$extension(string$.MODULE$.RichString(uri.getFragment()));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String fragment = (String)some.x();
            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"#", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fragment}));
        } else {
            string2 = "";
        }
        return string2;
    }

    public Map<String, MultipartItem> multiParams(Request request) {
        return new FinagleRequestFileUpload().parseMultipartItems(request);
    }

    public <T> T respondTo(Request request, PartialFunction<ContentType, T> callback) {
        String acceptHeader = (String)request.headerMap().getOrElse((Object)HttpHeaders$.MODULE$.Accept(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "*/*";
            }
        });
        Seq<MediaRange> mediaRanges = MediaRange$parseAndSort$.MODULE$.apply(acceptHeader);
        Seq contentTypes = (Seq)mediaRanges.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ContentType apply(MediaRange mediaRange) {
                return ContentType.fromString(mediaRange.contentType());
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (T)contentTypes.collectFirst(callback).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new NotAcceptableException(MediaType.PLAIN_TEXT_UTF_8, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not Acceptable Media Type"}))));
            }
        });
    }

    private RequestUtils$() {
        MODULE$ = this;
    }
}

