/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.jsonpatch;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.twitter.finatra.http.jsonpatch.JsonPatchException;
import com.twitter.finatra.http.jsonpatch.PatchOperation;
import com.twitter.finatra.json.FinatraObjectMapper;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u00015\u0011\u0011CS:p]B\u000bGo\u00195Pa\u0016\u0014\u0018\r^8s\u0015\t\u0019A!A\u0005kg>t\u0007/\u0019;dQ*\u0011QAB\u0001\u0005QR$\bO\u0003\u0002\b\u0011\u00059a-\u001b8biJ\f'BA\u0005\u000b\u0003\u001d!x/\u001b;uKJT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\r5\f\u0007\u000f]3s!\t9\"$D\u0001\u0019\u0015\tIb!\u0001\u0003kg>t\u0017BA\u000e\u0019\u0005M1\u0015N\\1ue\u0006|%M[3di6\u000b\u0007\u000f]3s\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\u0011q$\t\t\u0003A\u0001i\u0011A\u0001\u0005\u0006+q\u0001\rA\u0006\u0015\u00039\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\r%t'.Z2u\u0015\tA#\"\u0001\u0004h_><G.Z\u0005\u0003U\u0015\u0012a!\u00138kK\u000e$\b\"\u0002\u0017\u0001\t\u0003i\u0013A\u0003;p\u0015N|gNT8eKV\u0011a&\u0010\u000b\u0003_e\u0002\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u0011\u0011\fG/\u00192j]\u0012T!\u0001N\u001b\u0002\u000f)\f7m[:p]*\u0011aGC\u0001\nM\u0006\u001cH/\u001a:y[2L!\u0001O\u0019\u0003\u0011)\u001bxN\u001c(pI\u0016DQAO\u0016A\u0002m\n\u0001b\u001c:jO&t\u0017\r\u001c\t\u0003yub\u0001\u0001B\u0003?W\t\u0007qHA\u0001U#\t\u00015\t\u0005\u0002\u0010\u0003&\u0011!\t\u0005\u0002\b\u001d>$\b.\u001b8h!\tyA)\u0003\u0002F!\t\u0019\u0011I\\=\t\u000b1\u0002A\u0011A$\u0015\u0005=B\u0005\"\u0002\u001eG\u0001\u0004I\u0005C\u0001&N\u001d\ty1*\u0003\u0002M!\u00051\u0001K]3eK\u001aL!AT(\u0003\rM#(/\u001b8h\u0015\ta\u0005\u0003C\u0003R\u0001\u0011\u0005!+A\u0002bI\u0012$2a\u0015,\\!\tyA+\u0003\u0002V!\t!QK\\5u\u0011\u00159\u0006\u000b1\u0001Y\u0003\u0015\u0001\u0018\r^2i!\t\u0001\u0013,\u0003\u0002[\u0005\tq\u0001+\u0019;dQ>\u0003XM]1uS>t\u0007\"\u0002/Q\u0001\u0004y\u0013A\u0002;be\u001e,G\u000fC\u0003_\u0001\u0011\u0005q,\u0001\u0004sK6|g/\u001a\u000b\u0004'\u0002\f\u0007\"B,^\u0001\u0004A\u0006\"\u0002/^\u0001\u0004y\u0003\"B2\u0001\t\u0003!\u0017a\u0002:fa2\f7-\u001a\u000b\u0004'\u00164\u0007\"B,c\u0001\u0004A\u0006\"\u0002/c\u0001\u0004y\u0003\"\u00025\u0001\t\u0003I\u0017\u0001B7pm\u0016$2a\u00156l\u0011\u00159v\r1\u0001Y\u0011\u0015av\r1\u00010\u0011\u0015i\u0007\u0001\"\u0001o\u0003\u0011\u0019w\u000e]=\u0015\u0007M{\u0007\u000fC\u0003XY\u0002\u0007\u0001\fC\u0003]Y\u0002\u0007q\u0006C\u0003s\u0001\u0011\u00051/\u0001\u0003uKN$HcA*uk\")q+\u001da\u00011\")A,\u001da\u0001_!9q\u000f\u0001b\u0001\n\u0013A\u0018A\u00057bgR,E.Z7f]R\u0004v.\u001b8uKJ,\u0012!\u001f\t\u0003uvl\u0011a\u001f\u0006\u0003yN\nAaY8sK&\u0011ap\u001f\u0002\f\u0015N|g\u000eU8j]R,'\u000fC\u0004\u0002\u0002\u0001\u0001\u000b\u0011B=\u0002'1\f7\u000f^#mK6,g\u000e\u001e)pS:$XM\u001d\u0011\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b\u0005Q1\r[3dW\n{WO\u001c3\u0015\u000bM\u000bI!!\u0004\t\u000f\u0005-\u00111\u0001a\u0001\u0013\u0006Iq\u000e]3sCRLwN\u001c\u0005\t\u0003\u001f\t\u0019\u00011\u0001\u0002\u0012\u0005I1m\u001c8eSRLwN\u001c\t\u0004\u001f\u0005M\u0011bAA\u000b!\t9!i\\8mK\u0006t\u0007bBA\r\u0001\u0011%\u00111D\u0001\rO\u0016$H*Z1g\u0013:$W\r\u001f\u000b\t\u0003;\t\u0019#a\n\u00026A\u0019q\"a\b\n\u0007\u0005\u0005\u0002CA\u0002J]RDq!!\n\u0002\u0018\u0001\u0007\u00110\u0001\u0003qCRD\u0007b\u0002/\u0002\u0018\u0001\u0007\u0011\u0011\u0006\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF\u0019\u0002\t9|G-Z\u0005\u0005\u0003g\tiCA\u0005BeJ\f\u0017PT8eK\"9\u00111BA\f\u0001\u0004I\u0005bBA\u001d\u0001\u0011%\u00111H\u0001\u000f]\u0016DHOT8eK\nK\b+\u0019;i)\u001dy\u0013QHA \u0003\u0003Bq!!\n\u00028\u0001\u0007\u0011\u0010\u0003\u0004]\u0003o\u0001\ra\f\u0005\b\u0003\u0017\t9\u00041\u0001J\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000f\n1b]1gK\u001e+GOT8eKR9q&!\u0013\u0002L\u00055\u0003bBA\u0013\u0003\u0007\u0002\r!\u001f\u0005\u00079\u0006\r\u0003\u0019A\u0018\t\u000f\u0005-\u00111\ta\u0001\u0013\"\"\u00111IA)!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0013Q\u000b\u0002\bi\u0006LGN]3d\u0011\u001d\ty\u0006\u0001C\u0005\u0003C\nq!\u00193e\u001d>$W\rF\u0004T\u0003G\n)'!\u001b\t\u000f\u0005\u0015\u0012Q\fa\u0001s\"9\u0011qMA/\u0001\u0004y\u0013!\u0002<bYV,\u0007B\u0002/\u0002^\u0001\u0007q\u0006\u000b\u0003\u0002^\u0005E\u0003bBA8\u0001\u0011%\u0011\u0011O\u0001\u000be\u0016lwN^3O_\u0012,G#B*\u0002t\u0005U\u0004bBA\u0013\u0003[\u0002\r!\u001f\u0005\u00079\u00065\u0004\u0019A\u0018)\t\u00055\u0014\u0011\u000b\u0005\b\u0003w\u0002A\u0011BA?\u0003-\u0011X\r\u001d7bG\u0016tu\u000eZ3\u0015\u000fM\u000by(!!\u0002\u0004\"9\u0011QEA=\u0001\u0004I\bbBA4\u0003s\u0002\ra\f\u0005\u00079\u0006e\u0004\u0019A\u0018)\t\u0005e\u0014\u0011\u000b\u0005\b\u0003\u0013\u0003A\u0011BAF\u0003!iwN^3O_\u0012,GcB*\u0002\u000e\u0006=\u0015\u0011\u0013\u0005\b\u0003K\t9\t1\u0001z\u0011\u0019a\u0016q\u0011a\u0001_!9\u00111SAD\u0001\u0004I\u0018\u0001\u00024s_6Dq!a&\u0001\t\u0013\tI*\u0001\u0005d_BLhj\u001c3f)\u001d\u0019\u00161TAO\u0003?Cq!!\n\u0002\u0016\u0002\u0007\u0011\u0010\u0003\u0004]\u0003+\u0003\ra\f\u0005\b\u0003'\u000b)\n1\u0001z\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003K\u000b\u0001\u0002^3ti:{G-\u001a\u000b\b'\u0006\u001d\u0016\u0011VAV\u0011\u001d\t)#!)A\u0002eDa\u0001XAQ\u0001\u0004y\u0003bBA4\u0003C\u0003\ra\f\u0015\u0004\u0001\u0005=\u0006c\u0001\u0013\u00022&\u0019\u00111W\u0013\u0003\u0013MKgn\u001a7fi>t\u0007")
public class JsonPatchOperator {
    private final FinatraObjectMapper mapper;
    private final JsonPointer lastElementPointer;

    public <T> JsonNode toJsonNode(T original) {
        String str = this.mapper.writeValueAsString(original);
        return (JsonNode)this.mapper.parse(str, ManifestFactory$.MODULE$.classType(JsonNode.class));
    }

    public JsonNode toJsonNode(String original) {
        return (JsonNode)this.mapper.parse(original, ManifestFactory$.MODULE$.classType(JsonNode.class));
    }

    public void add(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option = patch2.value();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode v = (JsonNode)some.x();
            this.addNode(patch2.path(), v, target);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for add operation");
    }

    public void remove(PatchOperation patch2, JsonNode target) {
        this.removeNode(patch2.path(), target);
    }

    public void replace(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option = patch2.value();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode v = (JsonNode)some.x();
            this.replaceNode(patch2.path(), v, target);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for replace operation");
    }

    public void move(PatchOperation patch2, JsonNode target) {
        Option<JsonPointer> option = patch2.from();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            JsonPointer f = (JsonPointer)some.x();
            JsonPointer jsonPointer = patch2.path();
            JsonPointer jsonPointer2 = f;
            if (!(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.moveNode(patch2.path(), target, f);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new JsonPatchException("invalid from for move operation");
    }

    public void copy(PatchOperation patch2, JsonNode target) {
        Option<JsonPointer> option = patch2.from();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonPointer f = (JsonPointer)some.x();
            this.copyNode(patch2.path(), target, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid from for copy operation");
    }

    public void test(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option = patch2.value();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode v = (JsonNode)some.x();
            this.testNode(patch2.path(), target, v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for test operation");
    }

    private JsonPointer lastElementPointer() {
        return this.lastElementPointer;
    }

    private void checkBound(String operation, boolean condition) {
        if (((Object)BoxesRunTime.boxToBoolean((boolean)condition)).equals(BoxesRunTime.boxToBoolean((boolean)true))) {
            return;
        }
        throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid path for ", " operation, array index out of bounds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
    }

    private int getLeafIndex(JsonPointer path, ArrayNode target, String operation) {
        JsonPointer jsonPointer = path;
        JsonPointer jsonPointer2 = this.lastElementPointer();
        int index = !(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null) ? target.size() - 1 : path.getMatchingIndex();
        this.checkBound(operation, index < target.size() && index >= 0);
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonNode nextNodeByPath(JsonPointer path, JsonNode target, String operation) {
        JsonNode jsonNode = target;
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            if (!path.mayMatchElement()) throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid path for ", " operation, expected array index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
            int index = path.getMatchingIndex();
            this.checkBound(operation, index < arrayNode.size() && index >= 0);
            return arrayNode.get(index);
        }
        if (jsonNode != null) return target.get(path.getMatchingProperty());
        throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid target for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
    }

    private JsonNode safeGetNode(JsonPointer path, JsonNode target, String operation) {
        while (true) {
            block5: {
                block8: {
                    JsonNode jsonNode;
                    block7: {
                        JsonNode jsonNode2;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid path for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode2 = target;
                            if (!(jsonNode2 instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode2;
                            jsonNode = objectNode.get(path.getMatchingProperty());
                            break block7;
                        }
                        if (!(jsonNode2 instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode2;
                        jsonNode = arrayNode.get(this.getLeafIndex(path, arrayNode, operation));
                    }
                    return jsonNode;
                }
                throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid target for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
            }
            JsonNode jsonNode = this.nextNodeByPath(path, target, operation);
            target = jsonNode;
            path = path.tail();
        }
    }

    private void addNode(JsonPointer path, JsonNode value, JsonNode target) {
        while (true) {
            block5: {
                block8: {
                    block7: {
                        JsonNode jsonNode;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException("invalid path for add operation");
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode = target;
                            if (!(jsonNode instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode;
                            objectNode.put(path.getMatchingProperty(), value);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (!(jsonNode instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        JsonPointer jsonPointer = path;
                        JsonPointer jsonPointer2 = this.lastElementPointer();
                        int index = !(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null) ? arrayNode.size() : path.getMatchingIndex();
                        this.checkBound("add", index <= arrayNode.size() && index >= 0);
                        arrayNode.insert(index, value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new JsonPatchException("invalid target for add");
            }
            target = this.nextNodeByPath(path, target, "add");
            path = path.tail();
        }
    }

    private void removeNode(JsonPointer path, JsonNode target) {
        while (true) {
            block5: {
                block8: {
                    block7: {
                        JsonNode jsonNode;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException("invalid path for remove operation");
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode = target;
                            if (!(jsonNode instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode;
                            objectNode.remove(path.getMatchingProperty());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (!(jsonNode instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        arrayNode.remove(this.getLeafIndex(path, arrayNode, "remove"));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new JsonPatchException("invalid target for remove");
            }
            target = this.nextNodeByPath(path, target, "remove");
            path = path.tail();
        }
    }

    private void replaceNode(JsonPointer path, JsonNode value, JsonNode target) {
        while (true) {
            block5: {
                block8: {
                    block7: {
                        JsonNode jsonNode;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException("invalid path for replace operation");
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode = target;
                            if (!(jsonNode instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode;
                            objectNode.put(path.getMatchingProperty(), value);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (!(jsonNode instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        arrayNode.set(this.getLeafIndex(path, arrayNode, "replace"), value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new JsonPatchException("invalid target for replace");
            }
            target = this.nextNodeByPath(path, target, "replace");
            path = path.tail();
        }
    }

    private void moveNode(JsonPointer path, JsonNode target, JsonPointer from) {
        JsonNode nodeToMove = this.safeGetNode(from, target, "move");
        this.removeNode(from, target);
        this.addNode(path, nodeToMove, target);
    }

    private void copyNode(JsonPointer path, JsonNode target, JsonPointer from) {
        this.addNode(path, this.safeGetNode(from, target, "copy"), target);
    }

    private void testNode(JsonPointer path, JsonNode target, JsonNode value) {
        JsonNode jsonNode = this.safeGetNode(path, target, "test");
        JsonNode jsonNode2 = value;
        if (!(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null)) {
            return;
        }
        throw new JsonPatchException("test operation failed");
    }

    @Inject
    public JsonPatchOperator(FinatraObjectMapper mapper) {
        this.mapper = mapper;
        this.lastElementPointer = JsonPointer.compile((String)"/-");
    }
}

