/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http;

import com.twitter.finagle.http.Response;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class HttpHeaders$ {
    public static final HttpHeaders$ MODULE$;
    private final String ContentType;
    private final String ContentLength;
    private final String Date;
    private final String Server;
    private final String Accept;
    private final String RetryAfter;
    private final DateTimeZone GMT;
    private final String RFC7231DateFormat;
    private final DateTimeFormatter DateFormat;

    static {
        new HttpHeaders$();
    }

    public String ContentType() {
        return this.ContentType;
    }

    public String ContentLength() {
        return this.ContentLength;
    }

    public String Date() {
        return this.Date;
    }

    public String Server() {
        return this.Server;
    }

    public String Accept() {
        return this.Accept;
    }

    public String RetryAfter() {
        return this.RetryAfter;
    }

    public DateTimeZone GMT() {
        return this.GMT;
    }

    public String RFC7231DateFormat() {
        return this.RFC7231DateFormat;
    }

    private DateTimeFormatter DateFormat() {
        return this.DateFormat;
    }

    public void setDate(Response response, String header, DateTime date) {
        this.set(response, header, this.DateFormat().print((ReadableInstant)date));
    }

    public void set(Response response, String header, String value) {
        response.headerMap().set(header, value);
    }

    private HttpHeaders$() {
        MODULE$ = this;
        this.ContentType = "Content-Type";
        this.ContentLength = "Content-Length";
        this.Date = "Date";
        this.Server = "Server";
        this.Accept = "Accept";
        this.RetryAfter = "Retry-After";
        this.GMT = DateTimeZone.forID((String)"GMT");
        this.RFC7231DateFormat = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
        this.DateFormat = DateTimeFormat.forPattern((String)this.RFC7231DateFormat()).withZone(this.GMT()).withLocale(Locale.US);
    }
}

