/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http;

import com.google.inject.Module;
import com.twitter.finagle.Service;
import com.twitter.finagle.http.HttpMuxer$;
import com.twitter.finagle.http.Method;
import com.twitter.finatra.http.HttpServer;
import com.twitter.finatra.http.internal.routing.Route;
import com.twitter.finatra.http.modules.AccessLogModule$;
import com.twitter.finatra.http.modules.DocRootModule$;
import com.twitter.finatra.http.modules.ExceptionManagerModule$;
import com.twitter.finatra.http.modules.ExceptionMapperModule$;
import com.twitter.finatra.http.modules.MessageBodyModule$;
import com.twitter.finatra.http.modules.MustacheModule$;
import com.twitter.finatra.http.routing.AdminIndexInfo;
import com.twitter.finatra.http.routing.HttpRouter;
import com.twitter.finatra.http.routing.HttpRouter$;
import com.twitter.finatra.json.modules.FinatraJacksonModule$;
import com.twitter.finatra.logging.modules.Slf4jBridgeModule$;
import com.twitter.inject.TwitterModule;
import com.twitter.server.AdminHttpServer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public abstract class HttpServer$class {
    public static void postInjectorStartup(HttpServer $this) {
        $this.com$twitter$finatra$http$HttpServer$$super$postInjectorStartup();
        HttpRouter httpRouter = (HttpRouter)$this.injector().instance(ManifestFactory$.MODULE$.classType(HttpRouter.class));
        $this.configureHttp(httpRouter);
    }

    public static final Service httpService(HttpServer $this) {
        HttpRouter router = (HttpRouter)$this.injector().instance(ManifestFactory$.MODULE$.classType(HttpRouter.class));
        HttpServer$class.addAdminRoutes($this, router);
        return router.services().externalService();
    }

    public static Module accessLogModule(HttpServer $this) {
        return AccessLogModule$.MODULE$;
    }

    public static Module mustacheModule(HttpServer $this) {
        return MustacheModule$.MODULE$;
    }

    public static Module messageBodyModule(HttpServer $this) {
        return MessageBodyModule$.MODULE$;
    }

    public static Module exceptionMapperModule(HttpServer $this) {
        return ExceptionMapperModule$.MODULE$;
    }

    public static TwitterModule exceptionManagerModule(HttpServer $this) {
        return ExceptionManagerModule$.MODULE$;
    }

    public static Module jacksonModule(HttpServer $this) {
        return FinatraJacksonModule$.MODULE$;
    }

    private static void addAdminRoutes(HttpServer $this, HttpRouter router) {
        Seq allTwitterServerAdminRoutes = (Seq)((SeqLike)$this.routes().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(AdminHttpServer.Route x$1) {
                return x$1.path();
            }
        }, Seq$.MODULE$.canBuildFrom())).union((GenSeq)HttpMuxer$.MODULE$.patterns(), Seq$.MODULE$.canBuildFrom());
        Seq conflicts = (Seq)allTwitterServerAdminRoutes.intersect((GenSeq)router.routesByType().admin().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Route x$2) {
                return x$2.path();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        if (conflicts.nonEmpty()) {
            String errorMessage = "Adding admin routes with paths that overlap with pre-defined TwitterServer admin route paths is not allowed.";
            $this.error((Function0)new Serializable($this, conflicts, errorMessage){
                public static final long serialVersionUID = 0L;
                private final Seq conflicts$1;
                private final String errorMessage$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " \\nConflicting route paths: \\n\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.errorMessage$1, this.conflicts$1.mkString("\n\t")}));
                }
                {
                    this.conflicts$1 = conflicts$1;
                    this.errorMessage$1 = errorMessage$1;
                }
            });
            throw new Exception(errorMessage);
        }
        Tuple2 tuple2 = router.routesByType().admin().partition((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Route route) {
                return !route.path().startsWith(HttpRouter$.MODULE$.FinatraAdminPrefix()) && route.constantRoute();
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq adminIndexRoutes = (Seq)tuple2._1();
            Seq adminRichHandlerRoutes = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)adminIndexRoutes, (Object)adminRichHandlerRoutes);
            Seq adminIndexRoutes2 = (Seq)tuple23._1();
            Seq adminRichHandlerRoutes2 = (Seq)tuple23._2();
            HttpServer$class.warnIfRoutesDefineAdminIndexInfo($this, adminRichHandlerRoutes2, (Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Route route) {
                    return true;
                }
            });
            HttpServer$class.warnIfRoutesDefineAdminIndexInfo($this, adminIndexRoutes2, (Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Route route) {
                    Method method = route.method();
                    Method.Get$ get$ = Method.Get$.MODULE$;
                    return method != null ? !method.equals(get$) : get$ != null;
                }
            });
            $this.addAdminRoutes(HttpServer$class.toAdminHttpServerRoutes($this, adminIndexRoutes2, router));
            if (adminRichHandlerRoutes2.nonEmpty()) {
                HttpMuxer$.MODULE$.addRichHandler(HttpRouter$.MODULE$.FinatraAdminPrefix(), router.services().adminService());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static void warnIfRoutesDefineAdminIndexInfo(HttpServer $this, Seq routes, Function1 predicate) {
        routes.withFilter((Function1)new Serializable($this, predicate){
            public static final long serialVersionUID = 0L;
            private final Function1 predicate$1;

            public final boolean apply(Route route) {
                return BoxesRunTime.unboxToBoolean((Object)this.predicate$1.apply((Object)route)) && route.adminIndexInfo().isDefined();
            }
            {
                this.predicate$1 = predicate$1;
            }
        }).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServer $outer;

            public final void apply(Route route) {
                this.$outer.warn((Function0)new Serializable(this, route){
                    public static final long serialVersionUID = 0L;
                    private final Route route$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " defines an AdminIndexInfo but is not eligible to be added to the admin UI index. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.route$1.path()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only constant /GET routes that do not start with ", " can be added to the admin UI index."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HttpRouter$.MODULE$.FinatraAdminPrefix()}))).toString();
                    }
                    {
                        this.route$1 = route$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private static Seq toAdminHttpServerRoutes(HttpServer $this, Seq routes, HttpRouter router) {
        return (Seq)routes.map((Function1)new Serializable($this, router){
            public static final long serialVersionUID = 0L;
            private final HttpRouter router$1;

            /*
             * Unable to fully structure code
             */
            public final AdminHttpServer.Route apply(Route route) {
                if (!route.adminIndexInfo().isDefined()) ** GOTO lbl-1000
                v0 = route.method();
                var3_2 = Method.Get$.MODULE$;
                if (!(v0 != null ? v0.equals(var3_2) == false : var3_2 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                includeInIndex = v1;
                var5_4 = route.adminIndexInfo();
                var8_7 = var5_4 instanceof Some != false && new StringOps(Predef$.MODULE$.augmentString((info = (AdminIndexInfo)(var6_5 = (Some)var5_4).x()).alias())).nonEmpty() != false ? info.alias() : route.path();
                alias = var8_7;
                group = (String)route.adminIndexInfo().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AdminIndexInfo x$4) {
                        return x$4.group();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Finatra";
                    }
                });
                return new AdminHttpServer.Route(route.path(), this.router$1.services().adminService(), alias, (Option)new Some((Object)group), includeInIndex);
            }
            {
                this.router$1 = router$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static void $init$(HttpServer $this) {
        $this.addFrameworkModules((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Module[]{$this.mustacheModule(), $this.messageBodyModule(), $this.exceptionMapperModule(), $this.exceptionManagerModule(), $this.jacksonModule(), DocRootModule$.MODULE$, $this.accessLogModule(), Slf4jBridgeModule$.MODULE$}));
    }
}

