/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.request;

import com.google.common.net.MediaType;
import com.twitter.finagle.http.Request;
import com.twitter.finatra.http.HttpHeaders$;
import com.twitter.finatra.http.exceptions.BadRequestException;
import com.twitter.finatra.http.exceptions.NotAcceptableException;
import com.twitter.finatra.http.fileupload.FinagleRequestFileUpload;
import com.twitter.finatra.http.fileupload.MultipartItem;
import com.twitter.finatra.http.request.MediaRange;
import com.twitter.finatra.http.request.MediaRange$parseAndSort$;
import com.twitter.finatra.request.ContentType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class RequestUtils$ {
    public static final RequestUtils$ MODULE$;

    static {
        new RequestUtils$();
    }

    public String pathUrl(Request request) {
        String string2;
        Option option2 = request.headerMap().get((Object)"x-forwarded-proto");
        if (option2 instanceof Some) {
            String protocol;
            Some some = (Some)option2;
            string2 = protocol = (String)some.x();
        } else {
            string2 = "http";
        }
        String scheme = string2;
        Option option3 = request.host();
        if (option3 instanceof Some) {
            String host;
            String string3;
            Some some = (Some)option3;
            String hostHeader = string3 = (host = (String)some.x());
            String pathWithTrailingSlash = request.path().endsWith("/") ? request.path() : new StringBuilder().append((Object)request.path()).append((Object)"/").toString();
            return new StringBuilder().append((Object)scheme).append((Object)"://").append((Object)hostHeader).append((Object)pathWithTrailingSlash).toString();
        }
        throw new BadRequestException("Host header not set");
    }

    public Map<String, MultipartItem> multiParams(Request request) {
        return new FinagleRequestFileUpload().parseMultipartItems(request);
    }

    public <T> T respondTo(Request request, PartialFunction<ContentType, T> callback) {
        String acceptHeader = (String)request.headerMap().getOrElse((Object)HttpHeaders$.MODULE$.Accept(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "*/*";
            }
        });
        Seq<MediaRange> mediaRanges = MediaRange$parseAndSort$.MODULE$.apply(acceptHeader);
        Seq contentTypes = (Seq)mediaRanges.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ContentType apply(MediaRange mediaRange) {
                return ContentType.fromString(mediaRange.contentType());
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (T)contentTypes.collectFirst(callback).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new NotAcceptableException(MediaType.PLAIN_TEXT_UTF_8, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not Acceptable Media Type"}))));
            }
        });
    }

    private RequestUtils$() {
        MODULE$ = this;
    }
}

