/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.jsonpatch;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.twitter.finatra.http.jsonpatch.JsonPatchException;
import com.twitter.finatra.http.jsonpatch.PatchOperation;
import com.twitter.finatra.json.FinatraObjectMapper;
import scala.Option;
import scala.Some;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u00015\u0011\u0011CS:p]B\u000bGo\u00195Pa\u0016\u0014\u0018\r^8s\u0015\t\u0019A!A\u0005kg>t\u0007/\u0019;dQ*\u0011QAB\u0001\u0005QR$\bO\u0003\u0002\b\u0011\u00059a-\u001b8biJ\f'BA\u0005\u000b\u0003\u001d!x/\u001b;uKJT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\r5\f\u0007\u000f]3s!\t9\"$D\u0001\u0019\u0015\tIb!\u0001\u0003kg>t\u0017BA\u000e\u0019\u0005M1\u0015N\\1ue\u0006|%M[3di6\u000b\u0007\u000f]3s\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\u0011q$\t\t\u0003A\u0001i\u0011A\u0001\u0005\u0006+q\u0001\rA\u0006\u0015\u00039\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\r%t'.Z2u\u0015\tA#\"\u0001\u0004h_><G.Z\u0005\u0003U\u0015\u0012a!\u00138kK\u000e$\b\"\u0002\u0017\u0001\t\u0003i\u0013A\u0003;p\u0015N|gNT8eKV\u0011a&\u0010\u000b\u0003_e\u0002\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u0011\u0011\fG/\u00192j]\u0012T!\u0001N\u001b\u0002\u000f)\f7m[:p]*\u0011aGC\u0001\nM\u0006\u001cH/\u001a:y[2L!\u0001O\u0019\u0003\u0011)\u001bxN\u001c(pI\u0016DQAO\u0016A\u0002m\n\u0001b\u001c:jO&t\u0017\r\u001c\t\u0003yub\u0001\u0001B\u0003?W\t\u0007qHA\u0001U#\t\u00015\t\u0005\u0002\u0010\u0003&\u0011!\t\u0005\u0002\b\u001d>$\b.\u001b8h!\tyA)\u0003\u0002F!\t\u0019\u0011I\\=\t\u000b1\u0002A\u0011A$\u0015\u0005=B\u0005\"\u0002\u001eG\u0001\u0004I\u0005C\u0001&N\u001d\ty1*\u0003\u0002M!\u00051\u0001K]3eK\u001aL!AT(\u0003\rM#(/\u001b8h\u0015\ta\u0005\u0003C\u0003R\u0001\u0011\u0005!+A\u0002bI\u0012$2a\u0015,\\!\tyA+\u0003\u0002V!\t!QK\\5u\u0011\u00159\u0006\u000b1\u0001Y\u0003\u0015\u0001\u0018\r^2i!\t\u0001\u0013,\u0003\u0002[\u0005\tq\u0001+\u0019;dQ>\u0003XM]1uS>t\u0007\"\u0002/Q\u0001\u0004y\u0013A\u0002;be\u001e,G\u000fC\u0003_\u0001\u0011\u0005q,\u0001\u0004sK6|g/\u001a\u000b\u0004'\u0002\f\u0007\"B,^\u0001\u0004A\u0006\"\u0002/^\u0001\u0004y\u0003\"B2\u0001\t\u0003!\u0017a\u0002:fa2\f7-\u001a\u000b\u0004'\u00164\u0007\"B,c\u0001\u0004A\u0006\"\u0002/c\u0001\u0004y\u0003\"\u00025\u0001\t\u0003I\u0017\u0001B7pm\u0016$2a\u00156l\u0011\u00159v\r1\u0001Y\u0011\u0015av\r1\u00010\u0011\u0015i\u0007\u0001\"\u0001o\u0003\u0011\u0019w\u000e]=\u0015\u0007M{\u0007\u000fC\u0003XY\u0002\u0007\u0001\fC\u0003]Y\u0002\u0007q\u0006C\u0003s\u0001\u0011\u00051/\u0001\u0003uKN$HcA*uk\")q+\u001da\u00011\")A,\u001da\u0001_!)q\u000f\u0001C\u0005q\u00069\u0011\r\u001a3O_\u0012,GCB*z\u0003\u0007\t9\u0001C\u0003{m\u0002\u000710\u0001\u0003qCRD\u0007C\u0001?\u0000\u001b\u0005i(B\u0001@4\u0003\u0011\u0019wN]3\n\u0007\u0005\u0005QPA\u0006Kg>t\u0007k\\5oi\u0016\u0014\bBBA\u0003m\u0002\u0007q&A\u0003wC2,X\rC\u0003]m\u0002\u0007q\u0006K\u0002w\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#\u0001\u0012AC1o]>$\u0018\r^5p]&!\u0011QCA\b\u0005\u001d!\u0018-\u001b7sK\u000eDq!!\u0007\u0001\t\u0013\tY\"\u0001\u0006sK6|g/\u001a(pI\u0016$RaUA\u000f\u0003?AaA_A\f\u0001\u0004Y\bB\u0002/\u0002\u0018\u0001\u0007q\u0006\u000b\u0003\u0002\u0018\u0005-\u0001bBA\u0013\u0001\u0011%\u0011qE\u0001\fe\u0016\u0004H.Y2f\u001d>$W\rF\u0004T\u0003S\tY#!\f\t\ri\f\u0019\u00031\u0001|\u0011\u001d\t)!a\tA\u0002=Ba\u0001XA\u0012\u0001\u0004y\u0003\u0006BA\u0012\u0003\u0017Aq!a\r\u0001\t\u0013\t)$\u0001\u0005n_Z,gj\u001c3f)\u001d\u0019\u0016qGA\u001d\u0003wAaA_A\u0019\u0001\u0004Y\bB\u0002/\u00022\u0001\u0007q\u0006C\u0004\u0002>\u0005E\u0002\u0019A>\u0002\t\u0019\u0014x.\u001c\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0003!\u0019w\u000e]=O_\u0012,GcB*\u0002F\u0005\u001d\u0013\u0011\n\u0005\u0007u\u0006}\u0002\u0019A>\t\rq\u000by\u00041\u00010\u0011\u001d\ti$a\u0010A\u0002mDq!!\u0014\u0001\t\u0013\ty%\u0001\u0005uKN$hj\u001c3f)\u001d\u0019\u0016\u0011KA*\u0003+BaA_A&\u0001\u0004Y\bB\u0002/\u0002L\u0001\u0007q\u0006C\u0004\u0002\u0006\u0005-\u0003\u0019A\u0018)\u0007\u0001\tI\u0006E\u0002%\u00037J1!!\u0018&\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class JsonPatchOperator {
    private final FinatraObjectMapper mapper;

    public <T> JsonNode toJsonNode(T original) {
        String str = this.mapper.writeValueAsString(original);
        return (JsonNode)this.mapper.parse(str, ManifestFactory$.MODULE$.classType(JsonNode.class));
    }

    public JsonNode toJsonNode(String original) {
        return (JsonNode)this.mapper.parse(original, ManifestFactory$.MODULE$.classType(JsonNode.class));
    }

    public void add(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option = patch2.value();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode v = (JsonNode)some.x();
            this.addNode(patch2.path(), v, target);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for add operation");
    }

    public void remove(PatchOperation patch2, JsonNode target) {
        this.removeNode(patch2.path(), target);
    }

    public void replace(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option = patch2.value();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode v = (JsonNode)some.x();
            this.replaceNode(patch2.path(), v, target);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for replace operation");
    }

    public void move(PatchOperation patch2, JsonNode target) {
        Option<JsonPointer> option = patch2.from();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            JsonPointer f = (JsonPointer)some.x();
            JsonPointer jsonPointer = patch2.path();
            JsonPointer jsonPointer2 = f;
            if (!(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.moveNode(patch2.path(), target, f);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new JsonPatchException("invalid from for move operation");
    }

    public void copy(PatchOperation patch2, JsonNode target) {
        Option<JsonPointer> option = patch2.from();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonPointer f = (JsonPointer)some.x();
            this.copyNode(patch2.path(), target, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid from for copy operation");
    }

    public void test(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option = patch2.value();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode v = (JsonNode)some.x();
            this.testNode(patch2.path(), target, v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for test operation");
    }

    private void addNode(JsonPointer path, JsonNode value, JsonNode target) {
        while (true) {
            if (path.tail() == null) {
                throw new JsonPatchException("Invalid path for add operation");
            }
            if (path.tail().matches()) {
                JsonNode jsonNode = target;
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    objectNode.put(path.getMatchingProperty(), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new JsonPatchException("invalid target for add");
            }
            target = target.get(path.getMatchingProperty());
            path = path.tail();
        }
    }

    private void removeNode(JsonPointer path, JsonNode target) {
        while (true) {
            if (path.tail() == null) {
                throw new JsonPatchException("Invalid path for remove operation");
            }
            if (path.tail().matches()) {
                JsonNode jsonNode = target;
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    objectNode.remove(path.getMatchingProperty());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new JsonPatchException("invalid target for remove");
            }
            target = target.get(path.getMatchingProperty());
            path = path.tail();
        }
    }

    private void replaceNode(JsonPointer path, JsonNode value, JsonNode target) {
        while (true) {
            if (path.tail() == null) {
                throw new JsonPatchException("Invalid path for replace operation");
            }
            if (path.tail().matches()) {
                JsonNode jsonNode = target;
                if (jsonNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    objectNode.put(path.getMatchingProperty(), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new JsonPatchException("invalid target for replace");
            }
            target = target.get(path.getMatchingProperty());
            path = path.tail();
        }
    }

    private void moveNode(JsonPointer path, JsonNode target, JsonPointer from) {
        this.addNode(path, target.at(from), target);
        this.removeNode(from, target);
    }

    private void copyNode(JsonPointer path, JsonNode target, JsonPointer from) {
        this.addNode(path, target.at(from), target);
    }

    private void testNode(JsonPointer path, JsonNode target, JsonNode value) {
        JsonNode jsonNode = target.at(path);
        JsonNode jsonNode2 = value;
        if (!(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null)) {
            return;
        }
        throw new JsonPatchException("test operation failed");
    }

    @Inject
    public JsonPatchOperator(FinatraObjectMapper mapper) {
        this.mapper = mapper;
    }
}

