/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http;

import com.google.inject.Module;
import com.twitter.app.Flag;
import com.twitter.app.Flaggable$;
import com.twitter.conversions.DurationOps;
import com.twitter.conversions.DurationOps$;
import com.twitter.conversions.StorageUnitOps;
import com.twitter.conversions.StorageUnitOps$;
import com.twitter.finagle.Http;
import com.twitter.finagle.Http$;
import com.twitter.finagle.ListeningServer;
import com.twitter.finagle.NullServer$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finatra.http.HttpServerTrait;
import com.twitter.finatra.http.HttpServerTrait$;
import com.twitter.finatra.http.modules.HttpResponseClassifierModule$;
import com.twitter.finatra.http.response.HttpResponseClassifier;
import com.twitter.inject.conversions.string;
import com.twitter.inject.conversions.string$;
import com.twitter.inject.server.PortUtils$;
import com.twitter.util.Await$;
import com.twitter.util.Awaitable;
import com.twitter.util.Duration;
import com.twitter.util.StorageUnit;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class HttpServerTrait$class {
    public static String defaultHttpPort(HttpServerTrait $this) {
        return ":8888";
    }

    public static String defaultHttpsPort(HttpServerTrait $this) {
        return "";
    }

    public static StorageUnit defaultMaxRequestSize(HttpServerTrait $this) {
        return StorageUnitOps.RichStorageUnit$.MODULE$.megabytes$extension(StorageUnitOps$.MODULE$.RichStorageUnit(5L));
    }

    public static Duration defaultShutdownTimeout(HttpServerTrait $this) {
        return DurationOps.RichDuration$.MODULE$.minute$extension(DurationOps$.MODULE$.RichDuration(1L));
    }

    public static String defaultHttpServerName(HttpServerTrait $this) {
        return "http";
    }

    public static String defaultHttpsServerName(HttpServerTrait $this) {
        return "https";
    }

    public static String defaultHttpAnnouncement(HttpServerTrait $this) {
        return HttpServerTrait$.MODULE$.NoHttpAnnouncement();
    }

    public static String defaultHttpsAnnouncement(HttpServerTrait $this) {
        return HttpServerTrait$.MODULE$.NoHttpAnnouncement();
    }

    public static final Option httpBoundAddress(HttpServerTrait $this) {
        ListeningServer listeningServer = $this.com$twitter$finatra$http$HttpServerTrait$$httpServer();
        NullServer$ nullServer$ = NullServer$.MODULE$;
        return !(listeningServer != null ? !listeningServer.equals(nullServer$) : nullServer$ != null) ? None$.MODULE$ : new Some((Object)((InetSocketAddress)$this.com$twitter$finatra$http$HttpServerTrait$$httpServer().boundAddress()));
    }

    public static final Option httpsBoundAddress(HttpServerTrait $this) {
        ListeningServer listeningServer = $this.com$twitter$finatra$http$HttpServerTrait$$httpsServer();
        NullServer$ nullServer$ = NullServer$.MODULE$;
        return !(listeningServer != null ? !listeningServer.equals(nullServer$) : nullServer$ != null) ? None$.MODULE$ : new Some((Object)((InetSocketAddress)$this.com$twitter$finatra$http$HttpServerTrait$$httpsServer().boundAddress()));
    }

    public static Http.Server com$twitter$finatra$http$HttpServerTrait$$defaultHttpServer(HttpServerTrait $this, String name) {
        return Http$.MODULE$.server().withMaxRequestSize((StorageUnit)$this.com$twitter$finatra$http$HttpServerTrait$$maxRequestSizeFlag().apply()).withStreaming($this.streamRequest()).withLabel(name).withStatsReceiver((StatsReceiver)$this.injector().instance(ManifestFactory$.MODULE$.classType(StatsReceiver.class))).withResponseClassifier((PartialFunction)$this.injector().instance(ManifestFactory$.MODULE$.classType(HttpResponseClassifier.class)));
    }

    public static void postWarmup(HttpServerTrait $this) {
        $this.com$twitter$finatra$http$HttpServerTrait$$super$postWarmup();
        HttpServerTrait$class.parsePort($this, $this.com$twitter$finatra$http$HttpServerTrait$$httpPortFlag()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServerTrait $outer;

            public final void apply(InetSocketAddress address) {
                BoxedUnit boxedUnit;
                this.$outer.com$twitter$finatra$http$HttpServerTrait$$httpServer_$eq(this.$outer.build(address, this.$outer.frameworkConfigureHttpServer(this.$outer.configureHttpServer(HttpServerTrait$class.com$twitter$finatra$http$HttpServerTrait$$defaultHttpServer(this.$outer, (String)this.$outer.com$twitter$finatra$http$HttpServerTrait$$httpServerNameFlag().apply())))));
                this.$outer.onExit((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpServerTrait$.anonfun.postWarmup.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Await$.MODULE$.result((Awaitable)this.$outer.com$twitter$finatra$http$HttpServerTrait$$anonfun$$$outer().com$twitter$finatra$http$HttpServerTrait$$httpServer().close(((Duration)this.$outer.com$twitter$finatra$http$HttpServerTrait$$anonfun$$$outer().com$twitter$finatra$http$HttpServerTrait$$shutdownTimeoutFlag().apply()).fromNow()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.await((Awaitable)this.$outer.com$twitter$finatra$http$HttpServerTrait$$httpServer());
                String string2 = (String)this.$outer.com$twitter$finatra$http$HttpServerTrait$$httpAnnounceFlag().apply();
                String string3 = HttpServerTrait$.MODULE$.NoHttpAnnouncement();
                String string4 = string2;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.info((Function0)new Serializable(this, string2){
                        public static final long serialVersionUID = 0L;
                        private final String x1$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http server announced to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1}));
                        }
                        {
                            this.x1$1 = x1$1;
                        }
                    });
                    boxedUnit = this.$outer.com$twitter$finatra$http$HttpServerTrait$$httpServer().announce(string2);
                }
                this.$outer.info((Function0)new Serializable(this, address){
                    public static final long serialVersionUID = 0L;
                    private final InetSocketAddress address$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http server started on port: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.address$1}));
                    }
                    {
                        this.address$1 = address$1;
                    }
                });
            }

            public /* synthetic */ HttpServerTrait com$twitter$finatra$http$HttpServerTrait$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        HttpServerTrait$class.parsePort($this, $this.com$twitter$finatra$http$HttpServerTrait$$httpsPortFlag()).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServerTrait $outer;

            public final void apply(InetSocketAddress address) {
                BoxedUnit boxedUnit;
                this.$outer.com$twitter$finatra$http$HttpServerTrait$$httpsServer_$eq(this.$outer.build(address, this.$outer.frameworkConfigureHttpsServer(this.$outer.configureHttpsServer(HttpServerTrait$class.com$twitter$finatra$http$HttpServerTrait$$defaultHttpServer(this.$outer, (String)this.$outer.com$twitter$finatra$http$HttpServerTrait$$httpsServerNameFlag().apply())))));
                this.$outer.onExit((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpServerTrait$.anonfun.postWarmup.2 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Await$.MODULE$.result((Awaitable)this.$outer.com$twitter$finatra$http$HttpServerTrait$$anonfun$$$outer().com$twitter$finatra$http$HttpServerTrait$$httpsServer().close(((Duration)this.$outer.com$twitter$finatra$http$HttpServerTrait$$anonfun$$$outer().com$twitter$finatra$http$HttpServerTrait$$shutdownTimeoutFlag().apply()).fromNow()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.await((Awaitable)this.$outer.com$twitter$finatra$http$HttpServerTrait$$httpsServer());
                String string2 = (String)this.$outer.com$twitter$finatra$http$HttpServerTrait$$httpsAnnounceFlag().apply();
                String string3 = HttpServerTrait$.MODULE$.NoHttpAnnouncement();
                String string4 = string2;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.info((Function0)new Serializable(this, string2){
                        public static final long serialVersionUID = 0L;
                        private final String x1$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https server announced to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$2}));
                        }
                        {
                            this.x1$2 = x1$2;
                        }
                    });
                    boxedUnit = this.$outer.com$twitter$finatra$http$HttpServerTrait$$httpsServer().announce(string2);
                }
                this.$outer.info((Function0)new Serializable(this, address){
                    public static final long serialVersionUID = 0L;
                    private final InetSocketAddress address$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https server started on port: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.address$2}));
                    }
                    {
                        this.address$2 = address$2;
                    }
                });
            }

            public /* synthetic */ HttpServerTrait com$twitter$finatra$http$HttpServerTrait$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Option httpExternalPort(HttpServerTrait $this) {
        ListeningServer listeningServer = $this.com$twitter$finatra$http$HttpServerTrait$$httpServer();
        Object object = NullServer$.MODULE$.equals(listeningServer) ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)PortUtils$.MODULE$.getPort($this.com$twitter$finatra$http$HttpServerTrait$$httpServer())));
        return object;
    }

    public static Option httpsExternalPort(HttpServerTrait $this) {
        ListeningServer listeningServer = $this.com$twitter$finatra$http$HttpServerTrait$$httpsServer();
        Object object = NullServer$.MODULE$.equals(listeningServer) ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)PortUtils$.MODULE$.getPort($this.com$twitter$finatra$http$HttpServerTrait$$httpsServer())));
        return object;
    }

    public static Module httpResponseClassifierModule(HttpServerTrait $this) {
        return HttpResponseClassifierModule$.MODULE$;
    }

    public static boolean streamRequest(HttpServerTrait $this) {
        return false;
    }

    public static Http.Server configureHttpServer(HttpServerTrait $this, Http.Server server) {
        return server;
    }

    public static Http.Server configureHttpsServer(HttpServerTrait $this, Http.Server server) {
        return server;
    }

    public static Http.Server frameworkConfigureHttpServer(HttpServerTrait $this, Http.Server server) {
        return server;
    }

    public static Http.Server frameworkConfigureHttpsServer(HttpServerTrait $this, Http.Server server) {
        return server;
    }

    public static ListeningServer build(HttpServerTrait $this, InetSocketAddress addr, Http.Server server) {
        return server.serve((SocketAddress)addr, $this.httpService());
    }

    private static Option parsePort(HttpServerTrait $this, Flag port) {
        return string.RichString$.MODULE$.toOption$extension(string$.MODULE$.RichString((String)port.apply())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final InetSocketAddress apply(String addrStr) {
                return PortUtils$.MODULE$.parseAddr(addrStr);
            }
        });
    }

    public static void $init$(HttpServerTrait $this) {
        $this.addFrameworkModule($this.httpResponseClassifierModule());
        $this.com$twitter$finatra$http$HttpServerTrait$_setter_$com$twitter$finatra$http$HttpServerTrait$$httpPortFlag_$eq($this.flag().apply("http.port", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServerTrait $outer;

            public final String apply() {
                return this.$outer.defaultHttpPort();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "External HTTP server port", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$HttpServerTrait$_setter_$com$twitter$finatra$http$HttpServerTrait$$httpsPortFlag_$eq($this.flag().apply("https.port", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServerTrait $outer;

            public final String apply() {
                return this.$outer.defaultHttpsPort();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "External HTTPS server port", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$HttpServerTrait$_setter_$com$twitter$finatra$http$HttpServerTrait$$maxRequestSizeFlag_$eq($this.flag().apply("maxRequestSize", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServerTrait $outer;

            public final StorageUnit apply() {
                return this.$outer.defaultMaxRequestSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "HTTP(s) Max Request Size", Flaggable$.MODULE$.ofStorageUnit()));
        $this.com$twitter$finatra$http$HttpServerTrait$_setter_$com$twitter$finatra$http$HttpServerTrait$$shutdownTimeoutFlag_$eq($this.flag().apply("http.shutdown.time", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServerTrait $outer;

            public final Duration apply() {
                return this.$outer.defaultShutdownTimeout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Maximum amount of time to wait for pending requests to complete on shutdown", Flaggable$.MODULE$.ofDuration()));
        $this.com$twitter$finatra$http$HttpServerTrait$_setter_$com$twitter$finatra$http$HttpServerTrait$$httpServerNameFlag_$eq($this.flag().apply("http.name", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServerTrait $outer;

            public final String apply() {
                return this.$outer.defaultHttpServerName();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Http server name", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$HttpServerTrait$_setter_$com$twitter$finatra$http$HttpServerTrait$$httpsServerNameFlag_$eq($this.flag().apply("https.name", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServerTrait $outer;

            public final String apply() {
                return this.$outer.defaultHttpsServerName();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Https server name", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$HttpServerTrait$_setter_$com$twitter$finatra$http$HttpServerTrait$$httpAnnounceFlag_$eq($this.flag().apply("http.announce", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServerTrait $outer;

            public final String apply() {
                return this.$outer.defaultHttpAnnouncement();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Address for announcing HTTP server. Empty string indicates no announcement.", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$HttpServerTrait$_setter_$com$twitter$finatra$http$HttpServerTrait$$httpsAnnounceFlag_$eq($this.flag().apply("https.announce", (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HttpServerTrait $outer;

            public final String apply() {
                return this.$outer.defaultHttpsAnnouncement();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Address for announcing HTTPS server. Empty string indicates no announcement.", Flaggable$.MODULE$.ofString()));
        $this.com$twitter$finatra$http$HttpServerTrait$$httpServer_$eq((ListeningServer)NullServer$.MODULE$);
        $this.com$twitter$finatra$http$HttpServerTrait$$httpsServer_$eq((ListeningServer)NullServer$.MODULE$);
    }
}

