/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.http.jsonpatch;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.twitter.finatra.http.jsonpatch.JsonPatchException;
import com.twitter.finatra.http.jsonpatch.PatchOperation;
import com.twitter.finatra.jackson.ScalaObjectMapper;
import javax.inject.Inject;
import javax.inject.Singleton;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u00015\u0011\u0011CS:p]B\u000bGo\u00195Pa\u0016\u0014\u0018\r^8s\u0015\t\u0019A!A\u0005kg>t\u0007/\u0019;dQ*\u0011QAB\u0001\u0005QR$\bO\u0003\u0002\b\u0011\u00059a-\u001b8biJ\f'BA\u0005\u000b\u0003\u001d!x/\u001b;uKJT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\r5\f\u0007\u000f]3s!\t9\"$D\u0001\u0019\u0015\tIb!A\u0004kC\u000e\\7o\u001c8\n\u0005mA\"!E*dC2\fwJ\u00196fGRl\u0015\r\u001d9fe\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\"aH\u0011\u0011\u0005\u0001\u0002Q\"\u0001\u0002\t\u000bUa\u0002\u0019\u0001\f)\u0005q\u0019\u0003C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0019IgN[3di*\t\u0001&A\u0003kCZ\f\u00070\u0003\u0002+K\t1\u0011J\u001c6fGRDQ\u0001\f\u0001\u0005\u00025\n!\u0002^8Kg>tgj\u001c3f+\tqC\b\u0006\u00020qA\u0011\u0001GN\u0007\u0002c)\u0011!gM\u0001\tI\u0006$\u0018MY5oI*\u0011\u0011\u0004\u000e\u0006\u0003k)\t\u0011BZ1ti\u0016\u0014\b0\u001c7\n\u0005]\n$\u0001\u0003&t_:tu\u000eZ3\t\u000beZ\u0003\u0019\u0001\u001e\u0002\u0011=\u0014\u0018nZ5oC2\u0004\"a\u000f\u001f\r\u0001\u0011)Qh\u000bb\u0001}\t\tA+\u0005\u0002@\u0005B\u0011q\u0002Q\u0005\u0003\u0003B\u0011qAT8uQ&tw\r\u0005\u0002\u0010\u0007&\u0011A\t\u0005\u0002\u0004\u0003:L\b\"\u0002\u0017\u0001\t\u00031ECA\u0018H\u0011\u0015IT\t1\u0001I!\tIEJ\u0004\u0002\u0010\u0015&\u00111\nE\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002L!!)\u0001\u000b\u0001C\u0001#\u0006\u0019\u0011\r\u001a3\u0015\u0007I+&\f\u0005\u0002\u0010'&\u0011A\u000b\u0005\u0002\u0005+:LG\u000fC\u0003W\u001f\u0002\u0007q+A\u0003qCR\u001c\u0007\u000e\u0005\u0002!1&\u0011\u0011L\u0001\u0002\u000f!\u0006$8\r[(qKJ\fG/[8o\u0011\u0015Yv\n1\u00010\u0003\u0019!\u0018M]4fi\")Q\f\u0001C\u0001=\u00061!/Z7pm\u0016$2AU0a\u0011\u00151F\f1\u0001X\u0011\u0015YF\f1\u00010\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003\u001d\u0011X\r\u001d7bG\u0016$2A\u00153f\u0011\u00151\u0016\r1\u0001X\u0011\u0015Y\u0016\r1\u00010\u0011\u00159\u0007\u0001\"\u0001i\u0003\u0011iwN^3\u0015\u0007IK'\u000eC\u0003WM\u0002\u0007q\u000bC\u0003\\M\u0002\u0007q\u0006C\u0003m\u0001\u0011\u0005Q.\u0001\u0003d_BLHc\u0001*o_\")ak\u001ba\u0001/\")1l\u001ba\u0001_!)\u0011\u000f\u0001C\u0001e\u0006!A/Z:u)\r\u00116\u000f\u001e\u0005\u0006-B\u0004\ra\u0016\u0005\u00067B\u0004\ra\f\u0005\bm\u0002\u0011\r\u0011\"\u0003x\u0003Ia\u0017m\u001d;FY\u0016lWM\u001c;Q_&tG/\u001a:\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a_\u001a\u0002\t\r|'/Z\u0005\u0003{j\u00141BS:p]B{\u0017N\u001c;fe\"1q\u0010\u0001Q\u0001\na\f1\u0003\\1ti\u0016cW-\\3oiB{\u0017N\u001c;fe\u0002Bq!a\u0001\u0001\t\u0013\t)!\u0001\u0006dQ\u0016\u001c7NQ8v]\u0012$RAUA\u0004\u0003\u0017Aq!!\u0003\u0002\u0002\u0001\u0007\u0001*A\u0005pa\u0016\u0014\u0018\r^5p]\"A\u0011QBA\u0001\u0001\u0004\ty!A\u0005d_:$\u0017\u000e^5p]B\u0019q\"!\u0005\n\u0007\u0005M\u0001CA\u0004C_>dW-\u00198\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a\u0005aq-\u001a;MK\u00064\u0017J\u001c3fqRA\u00111DA\u0011\u0003K\t\u0019\u0004E\u0002\u0010\u0003;I1!a\b\u0011\u0005\rIe\u000e\u001e\u0005\b\u0003G\t)\u00021\u0001y\u0003\u0011\u0001\u0018\r\u001e5\t\u000fm\u000b)\u00021\u0001\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.E\nAA\\8eK&!\u0011\u0011GA\u0016\u0005%\t%O]1z\u001d>$W\rC\u0004\u0002\n\u0005U\u0001\u0019\u0001%\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\u0005qa.\u001a=u\u001d>$WMQ=QCRDGcB\u0018\u0002<\u0005u\u0012q\b\u0005\b\u0003G\t)\u00041\u0001y\u0011\u0019Y\u0016Q\u0007a\u0001_!9\u0011\u0011BA\u001b\u0001\u0004A\u0005bBA\"\u0001\u0011%\u0011QI\u0001\fg\u00064WmR3u\u001d>$W\rF\u00040\u0003\u000f\nI%a\u0013\t\u000f\u0005\r\u0012\u0011\ta\u0001q\"11,!\u0011A\u0002=Bq!!\u0003\u0002B\u0001\u0007\u0001\n\u000b\u0003\u0002B\u0005=\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005U\u0003#\u0001\u0006b]:|G/\u0019;j_:LA!!\u0017\u0002T\t9A/Y5me\u0016\u001c\u0007bBA/\u0001\u0011%\u0011qL\u0001\bC\u0012$gj\u001c3f)\u001d\u0011\u0016\u0011MA2\u0003OBq!a\t\u0002\\\u0001\u0007\u0001\u0010C\u0004\u0002f\u0005m\u0003\u0019A\u0018\u0002\u000bY\fG.^3\t\rm\u000bY\u00061\u00010Q\u0011\tY&a\u0014\t\u000f\u00055\u0004\u0001\"\u0003\u0002p\u0005Q!/Z7pm\u0016tu\u000eZ3\u0015\u000bI\u000b\t(a\u001d\t\u000f\u0005\r\u00121\u000ea\u0001q\"11,a\u001bA\u0002=BC!a\u001b\u0002P!9\u0011\u0011\u0010\u0001\u0005\n\u0005m\u0014a\u0003:fa2\f7-\u001a(pI\u0016$rAUA?\u0003\u007f\n\t\tC\u0004\u0002$\u0005]\u0004\u0019\u0001=\t\u000f\u0005\u0015\u0014q\u000fa\u0001_!11,a\u001eA\u0002=BC!a\u001e\u0002P!9\u0011q\u0011\u0001\u0005\n\u0005%\u0015\u0001C7pm\u0016tu\u000eZ3\u0015\u000fI\u000bY)!$\u0002\u0010\"9\u00111EAC\u0001\u0004A\bBB.\u0002\u0006\u0002\u0007q\u0006C\u0004\u0002\u0012\u0006\u0015\u0005\u0019\u0001=\u0002\t\u0019\u0014x.\u001c\u0005\b\u0003+\u0003A\u0011BAL\u0003!\u0019w\u000e]=O_\u0012,Gc\u0002*\u0002\u001a\u0006m\u0015Q\u0014\u0005\b\u0003G\t\u0019\n1\u0001y\u0011\u0019Y\u00161\u0013a\u0001_!9\u0011\u0011SAJ\u0001\u0004A\bbBAQ\u0001\u0011%\u00111U\u0001\ti\u0016\u001cHOT8eKR9!+!*\u0002(\u0006%\u0006bBA\u0012\u0003?\u0003\r\u0001\u001f\u0005\u00077\u0006}\u0005\u0019A\u0018\t\u000f\u0005\u0015\u0014q\u0014a\u0001_!\u001a\u0001!!,\u0011\u0007\u0011\ny+C\u0002\u00022\u0016\u0012\u0011bU5oO2,Go\u001c8")
public class JsonPatchOperator {
    private final ScalaObjectMapper mapper;
    private final JsonPointer lastElementPointer;

    public <T> JsonNode toJsonNode(T original) {
        String str = this.mapper.writeValueAsString(original);
        return (JsonNode)this.mapper.parse(str, ManifestFactory$.MODULE$.classType(JsonNode.class));
    }

    public JsonNode toJsonNode(String original) {
        return (JsonNode)this.mapper.parse(original, ManifestFactory$.MODULE$.classType(JsonNode.class));
    }

    public void add(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option = patch2.value();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode v = (JsonNode)some.x();
            this.addNode(patch2.path(), v, target);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for add operation");
    }

    public void remove(PatchOperation patch2, JsonNode target) {
        this.removeNode(patch2.path(), target);
    }

    public void replace(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option = patch2.value();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode v = (JsonNode)some.x();
            this.replaceNode(patch2.path(), v, target);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for replace operation");
    }

    public void move(PatchOperation patch2, JsonNode target) {
        Option<JsonPointer> option = patch2.from();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            JsonPointer f = (JsonPointer)some.x();
            JsonPointer jsonPointer = patch2.path();
            JsonPointer jsonPointer2 = f;
            if (!(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.moveNode(patch2.path(), target, f);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new JsonPatchException("invalid from for move operation");
    }

    public void copy(PatchOperation patch2, JsonNode target) {
        Option<JsonPointer> option = patch2.from();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonPointer f = (JsonPointer)some.x();
            this.copyNode(patch2.path(), target, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid from for copy operation");
    }

    public void test(PatchOperation patch2, JsonNode target) {
        Option<JsonNode> option = patch2.value();
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNode v = (JsonNode)some.x();
            this.testNode(patch2.path(), target, v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new JsonPatchException("invalid value for test operation");
    }

    private JsonPointer lastElementPointer() {
        return this.lastElementPointer;
    }

    private void checkBound(String operation, boolean condition) {
        if (((Object)BoxesRunTime.boxToBoolean((boolean)condition)).equals(BoxesRunTime.boxToBoolean((boolean)true))) {
            return;
        }
        throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid path for ", " operation, array index out of bounds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
    }

    private int getLeafIndex(JsonPointer path, ArrayNode target, String operation) {
        JsonPointer jsonPointer = path;
        JsonPointer jsonPointer2 = this.lastElementPointer();
        int index = !(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null) ? target.size() - 1 : path.getMatchingIndex();
        this.checkBound(operation, index < target.size() && index >= 0);
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonNode nextNodeByPath(JsonPointer path, JsonNode target, String operation) {
        JsonNode jsonNode = target;
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            if (!path.mayMatchElement()) throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid path for ", " operation, expected array index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
            int index = path.getMatchingIndex();
            this.checkBound(operation, index < arrayNode.size() && index >= 0);
            return arrayNode.get(index);
        }
        if (jsonNode != null) return target.get(path.getMatchingProperty());
        throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid target for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
    }

    private JsonNode safeGetNode(JsonPointer path, JsonNode target, String operation) {
        while (true) {
            block5: {
                block8: {
                    JsonNode jsonNode;
                    block7: {
                        JsonNode jsonNode2;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid path for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode2 = target;
                            if (!(jsonNode2 instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode2;
                            jsonNode = objectNode.get(path.getMatchingProperty());
                            break block7;
                        }
                        if (!(jsonNode2 instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode2;
                        jsonNode = arrayNode.get(this.getLeafIndex(path, arrayNode, operation));
                    }
                    return jsonNode;
                }
                throw new JsonPatchException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid target for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
            }
            JsonNode jsonNode = this.nextNodeByPath(path, target, operation);
            target = jsonNode;
            path = path.tail();
        }
    }

    private void addNode(JsonPointer path, JsonNode value, JsonNode target) {
        while (true) {
            block5: {
                block8: {
                    block7: {
                        JsonNode jsonNode;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException("invalid path for add operation");
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode = target;
                            if (!(jsonNode instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode;
                            objectNode.set(path.getMatchingProperty(), value);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (!(jsonNode instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        JsonPointer jsonPointer = path;
                        JsonPointer jsonPointer2 = this.lastElementPointer();
                        int index = !(jsonPointer != null ? !jsonPointer.equals(jsonPointer2) : jsonPointer2 != null) ? arrayNode.size() : path.getMatchingIndex();
                        this.checkBound("add", index <= arrayNode.size() && index >= 0);
                        arrayNode.insert(index, value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new JsonPatchException("invalid target for add");
            }
            target = this.nextNodeByPath(path, target, "add");
            path = path.tail();
        }
    }

    private void removeNode(JsonPointer path, JsonNode target) {
        while (true) {
            block5: {
                block8: {
                    block7: {
                        JsonNode jsonNode;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException("invalid path for remove operation");
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode = target;
                            if (!(jsonNode instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode;
                            objectNode.remove(path.getMatchingProperty());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (!(jsonNode instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        arrayNode.remove(this.getLeafIndex(path, arrayNode, "remove"));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new JsonPatchException("invalid target for remove");
            }
            target = this.nextNodeByPath(path, target, "remove");
            path = path.tail();
        }
    }

    private void replaceNode(JsonPointer path, JsonNode value, JsonNode target) {
        while (true) {
            block5: {
                block8: {
                    block7: {
                        JsonNode jsonNode;
                        block6: {
                            if (path.tail() == null) {
                                throw new JsonPatchException("invalid path for replace operation");
                            }
                            if (!path.tail().matches()) break block5;
                            jsonNode = target;
                            if (!(jsonNode instanceof ObjectNode)) break block6;
                            ObjectNode objectNode = (ObjectNode)jsonNode;
                            objectNode.set(path.getMatchingProperty(), value);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (!(jsonNode instanceof ArrayNode)) break block8;
                        ArrayNode arrayNode = (ArrayNode)jsonNode;
                        arrayNode.set(this.getLeafIndex(path, arrayNode, "replace"), value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new JsonPatchException("invalid target for replace");
            }
            target = this.nextNodeByPath(path, target, "replace");
            path = path.tail();
        }
    }

    private void moveNode(JsonPointer path, JsonNode target, JsonPointer from) {
        JsonNode nodeToMove = this.safeGetNode(from, target, "move");
        this.removeNode(from, target);
        this.addNode(path, nodeToMove, target);
    }

    private void copyNode(JsonPointer path, JsonNode target, JsonPointer from) {
        this.addNode(path, this.safeGetNode(from, target, "copy"), target);
    }

    private void testNode(JsonPointer path, JsonNode target, JsonNode value) {
        JsonNode jsonNode = this.safeGetNode(path, target, "test");
        JsonNode jsonNode2 = value;
        if (!(jsonNode != null ? !jsonNode.equals(jsonNode2) : jsonNode2 != null)) {
            return;
        }
        throw new JsonPatchException("test operation failed");
    }

    @Inject
    public JsonPatchOperator(ScalaObjectMapper mapper2) {
        this.mapper = mapper2;
        this.lastElementPointer = JsonPointer.compile((String)"/-");
    }
}

