/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.json.internal.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import com.twitter.finatra.json.internal.caseclass.exceptions.FinatraJsonMappingException;
import com.twitter.util.Return;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y3Q!\u0001\u0002\u0001\u00119\u0011\u0001DS8eC\u0012\u000bG/\u001a;j[\u0016$Um]3sS\u0006d\u0017N_3s\u0015\t\u0019A!A\u0003tKJ$WM\u0003\u0002\u0006\r\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\b\u0011\u0005!!n]8o\u0015\tI!\"A\u0004gS:\fGO]1\u000b\u0005-a\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0014\u0005\u0001y\u0001c\u0001\t\u001c;5\t\u0011C\u0003\u0002\u0013'\u0005)A-Z:fe*\u0011A#F\u0001\u0005U>$\u0017M\u0003\u0002\u0017/\u0005AA-\u0019;bif\u0004XM\u0003\u0002\u00193\u00059!.Y2lg>t'B\u0001\u000e\r\u0003%1\u0017m\u001d;feblG.\u0003\u0002\u001d#\tA\"j\u001c3b\t\u0006$X\rR3tKJL\u0017\r\\5{KJ\u0014\u0015m]3\u0011\u0005y!S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001\u0002;j[\u0016T!\u0001\u0006\u0012\u000b\u0003\r\n1a\u001c:h\u0013\t)sD\u0001\u0005ECR,G+[7f\u0011!9\u0003A!A!\u0002\u0013I\u0013A\u00024pe6\fGo\u0001\u0001\u0011\u0005)jS\"A\u0016\u000b\u00051\u001a\u0012aA2gO&\u0011af\u000b\u0002\u0016\u0015\u0006\u001c7n]8o\u0015>$\u0017\rR1uK\u001a{'/\\1u\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003\u0019a\u0014N\\5u}Q\u0011!\u0007\u000e\t\u0003g\u0001i\u0011A\u0001\u0005\u0006O=\u0002\r!\u000b\u0005\u0006m\u0001!\teN\u0001\u000bo&$\bNR8s[\u0006$HC\u0001\u001a9\u0011\u0015IT\u00071\u0001*\u0003UQ\u0017mY6t_:Tu\u000eZ1ECR,gi\u001c:nCRDQa\u000f\u0001\u0005\u0002q\n1\u0002Z3tKJL\u0017\r\\5{KR\u0019Q$P#\t\u000byR\u0004\u0019A \u0002\u0005)\u0004\bC\u0001!D\u001b\u0005\t%B\u0001\"\u0018\u0003\u0011\u0019wN]3\n\u0005\u0011\u000b%A\u0003&t_:\u0004\u0016M]:fe\")aI\u000fa\u0001\u000f\u0006!1\r\u001e=u!\tA5*D\u0001J\u0015\tQu#\u0001\u0005eCR\f'-\u001b8e\u0013\ta\u0015J\u0001\fEKN,'/[1mSj\fG/[8o\u0007>tG/\u001a=u\u0011\u0015q\u0005\u0001\"\u0003P\u00035\u0001\u0018M]:f\rJ|W\u000eT8oOR\u0019Q\u0004U)\t\u000b\u0019k\u0005\u0019A$\t\u000bIk\u0005\u0019A*\u0002\u000bY\fG.^3\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\t1{gn\u001a\u0005\u000b5\u0002\u0001\n\u0011!A\u0001\n\u0003Y\u0016!\u00059s_R,7\r^3eI}3wN]7biR\u0011\u0011\u0006\u0018\u0005\b;f\u000b\t\u00111\u00013\u0003\rAH%\r")
public class JodaDatetimeDeserializer
extends JodaDateDeserializerBase<DateTime> {
    private final JacksonJodaDateFormat format;

    public /* synthetic */ JacksonJodaDateFormat protected$_format(JodaDatetimeDeserializer x$1) {
        return x$1._format;
    }

    public JodaDatetimeDeserializer withFormat(JacksonJodaDateFormat jacksonJodaDateFormat) {
        return new JodaDatetimeDeserializer(this.format);
    }

    public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) {
        try {
            DateTime dateTime;
            JsonToken jsonToken = jp.getCurrentToken();
            if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken)) {
                long value = jp.getLongValue();
                dateTime = this.parseFromLong(ctxt, value);
            } else if (JsonToken.VALUE_STRING.equals(jsonToken)) {
                DateTime dateTime2;
                String value = jp.getText().trim();
                if (value.isEmpty()) {
                    throw new FinatraJsonMappingException("field cannot be empty");
                }
                Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, ctxt, value){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JodaDatetimeDeserializer $outer;
                    private final DeserializationContext ctxt$1;
                    private final String value$1;

                    public final DateTime apply() {
                        return this.$outer.protected$_format(this.$outer).createParser(this.ctxt$1).parseDateTime(this.value$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ctxt$1 = ctxt$1;
                        this.value$1 = value$1;
                    }
                });
                if (try_ instanceof Return) {
                    DateTime result;
                    Return return_ = (Return)try_;
                    dateTime2 = result = (DateTime)return_.r();
                } else {
                    dateTime2 = this.parseFromLong(ctxt, new StringOps(Predef$.MODULE$.augmentString(value)).toLong());
                }
                dateTime = dateTime2;
            } else {
                dateTime = (DateTime)this._handleNotNumberOrString(jp, ctxt);
            }
            return dateTime;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FinatraJsonMappingException jme = new FinatraJsonMappingException(new StringBuilder().append((Object)"error parsing '").append((Object)jp.getText()).append((Object)"' into an ISO 8601 datetime").toString());
            jme.addSuppressed(illegalArgumentException);
            throw jme;
        }
    }

    private DateTime parseFromLong(DeserializationContext ctxt, long value) {
        if (value < 0L) {
            throw new FinatraJsonMappingException("field cannot be negative");
        }
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone());
        return new DateTime(value, tz);
    }

    public JodaDatetimeDeserializer(JacksonJodaDateFormat format) {
        this.format = format;
        super(DateTime.class, format);
    }
}

