/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.jackson.serde;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import com.twitter.util.Return;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000154Q\u0001C\u0005\u0001\u001bMA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006e\u0001!\ta\r\u0005\u0006o\u0001!\t\u0005\u000f\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006\u001b\u0002!IA\u0014\u0005\u0006-\u0002!Ia\u0016\u0005\u000bC\u0002\u0001\n\u0011!A\u0001\n\u0003\u0011'\u0001\u0007&pI\u0006$\u0015\r^3uS6,G)Z:fe&\fG.\u001b>fe*\u0011!bC\u0001\u0006g\u0016\u0014H-\u001a\u0006\u0003\u00195\tqA[1dWN|gN\u0003\u0002\u000f\u001f\u00059a-\u001b8biJ\f'B\u0001\t\u0012\u0003\u001d!x/\u001b;uKJT\u0011AE\u0001\u0004G>l7C\u0001\u0001\u0015!\r)r$I\u0007\u0002-)\u0011q\u0003G\u0001\u0006I\u0016\u001cXM\u001d\u0006\u00033i\tAA[8eC*\u00111\u0004H\u0001\tI\u0006$\u0018\r^=qK*\u0011A\"\b\u0006\u0003=E\t\u0011BZ1ti\u0016\u0014\b0\u001c7\n\u0005\u00012\"\u0001\u0007&pI\u0006$\u0015\r^3EKN,'/[1mSj,'OQ1tKB\u0011!\u0005K\u0007\u0002G)\u0011A%J\u0001\u0005i&lWM\u0003\u0002\u001aM)\tq%A\u0002pe\u001eL!!K\u0012\u0003\u0011\u0011\u000bG/\u001a+j[\u0016\faAZ8s[\u0006$8\u0001\u0001\t\u0003[Aj\u0011A\f\u0006\u0003_a\t1a\u00194h\u0013\t\tdFA\u000bKC\u000e\\7o\u001c8K_\u0012\fG)\u0019;f\r>\u0014X.\u0019;\u0002\rqJg.\u001b;?)\t!d\u0007\u0005\u00026\u00015\t\u0011\u0002C\u0003+\u0005\u0001\u0007A&\u0001\u0006xSRDgi\u001c:nCR$\"\u0001N\u001d\t\u000bi\u001a\u0001\u0019\u0001\u0017\u0002+)\f7m[:p]*{G-\u0019#bi\u00164uN]7bi\u0006YA-Z:fe&\fG.\u001b>f)\r\tS(\u0012\u0005\u0006}\u0011\u0001\raP\u0001\u0003UB\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u000f\u0002\t\r|'/Z\u0005\u0003\t\u0006\u0013!BS:p]B\u000b'o]3s\u0011\u00151E\u00011\u0001H\u0003\u0011\u0019G\u000f\u001f;\u0011\u0005![U\"A%\u000b\u0005)c\u0012\u0001\u00033bi\u0006\u0014\u0017N\u001c3\n\u00051K%A\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0017!\fg\u000e\u001a7f)>\\WM\u001c\u000b\u0005C=#V\u000bC\u0003Q\u000b\u0001\u0007\u0011+A\u0003u_.,g\u000e\u0005\u0002A%&\u00111+\u0011\u0002\n\u0015N|g\u000eV8lK:DQAP\u0003A\u0002}BQAR\u0003A\u0002\u001d\u000bQ\u0002]1sg\u00164%o\\7M_:<GcA\u0011Y3\")aI\u0002a\u0001\u000f\")!L\u0002a\u00017\u0006)a/\u00197vKB\u0011AlX\u0007\u0002;*\ta,A\u0003tG\u0006d\u0017-\u0003\u0002a;\n!Aj\u001c8h\u0003E\u0001(o\u001c;fGR,G\rJ0g_Jl\u0017\r\u001e\u000b\u0003Y\rDq\u0001Z\u0004\u0002\u0002\u0003\u0007A'A\u0002yIEBC\u0001\u00014jWB\u0011AlZ\u0005\u0003Qv\u0013!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005Q\u0017AS+tKJ\u001c\be\u001d5pk2$\u0007\u0005\u001d:fM\u0016\u0014\bE\u0013#Lq\u0001*\u0017/^5wC2,g\u000e\u001e\u0011dY\u0006\u001c8/Z:!C:$\u0007%Y:t_\u000eL\u0017\r^3eA)\u000b7m[:p]\u0002\u001aX\u000f\u001d9peR\f\u0013\u0001\\\u0001\u000beA\u0012\u0014'\f\u00195[E\u0012\u0004")
public class JodaDatetimeDeserializer
extends JodaDateDeserializerBase<DateTime> {
    private final JacksonJodaDateFormat format;

    public /* synthetic */ JacksonJodaDateFormat protected$_format(JodaDatetimeDeserializer x$1) {
        return x$1._format;
    }

    public JodaDatetimeDeserializer withFormat(JacksonJodaDateFormat jacksonJodaDateFormat) {
        return new JodaDatetimeDeserializer(this.format);
    }

    public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) {
        DateTime dateTime;
        try {
            JsonToken jsonToken = jp.getCurrentToken();
            boolean bl = JsonToken.NOT_AVAILABLE.equals(jsonToken) ? true : JsonToken.START_OBJECT.equals(jsonToken);
            DateTime dateTime2 = bl ? this.handleToken(jp.nextToken(), jp, ctxt) : this.handleToken(jp.currentToken(), jp, ctxt);
            dateTime = dateTime2;
        }
        catch (IllegalArgumentException e) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)new StringBuilder(42).append("error parsing '").append(jp.getText()).append("' into an ISO 8601 datetime").toString(), (Throwable)e);
        }
        return dateTime;
    }

    private DateTime handleToken(JsonToken token, JsonParser jp, DeserializationContext ctxt) {
        DateTime dateTime;
        JsonToken jsonToken = token;
        if (JsonToken.VALUE_NUMBER_INT.equals(jsonToken)) {
            long value = jp.getLongValue();
            dateTime = this.parseFromLong(ctxt, value);
        } else if (JsonToken.VALUE_STRING.equals(jsonToken)) {
            DateTime dateTime2;
            String value = jp.getText().trim();
            if (value.isEmpty()) {
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)"field cannot be empty");
            }
            Try try_ = Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> this.protected$_format(this).createParser(ctxt).parseDateTime(value));
            if (try_ instanceof Return) {
                DateTime result;
                Return return_ = (Return)try_;
                dateTime2 = result = (DateTime)return_.r();
            } else {
                dateTime2 = this.parseFromLong(ctxt, new StringOps(Predef$.MODULE$.augmentString(value)).toLong());
            }
            dateTime = dateTime2;
        } else {
            dateTime = (DateTime)this._handleNotNumberOrString(jp, ctxt);
        }
        return dateTime;
    }

    private DateTime parseFromLong(DeserializationContext ctxt, long value) {
        if (value < 0L) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)"field cannot be negative");
        }
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone((TimeZone)ctxt.getTimeZone());
        return new DateTime(value, tz);
    }

    public JodaDatetimeDeserializer(JacksonJodaDateFormat format) {
        this.format = format;
        super(DateTime.class, format);
    }
}

