/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.mustache.marshalling;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.twitter.io.Buf;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Singleton;
import scala.reflect.ScalaSignature;

@Singleton
@ScalaSignature(bytes="\u0006\u0005E3A!\u0002\u0004\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u00030\u0001\u0011\u0005\u0001\u0007\u0003\u0004D\u0001\u0011\u0005!\u0002\u0012\u0002\u0010\u001bV\u001cH/Y2iKN+'O^5dK*\u0011q\u0001C\u0001\f[\u0006\u00148\u000f[1mY&twM\u0003\u0002\n\u0015\u0005AQ.^:uC\u000eDWM\u0003\u0002\f\u0019\u00059a-\u001b8biJ\f'BA\u0007\u000f\u0003\u001d!x/\u001b;uKJT\u0011aD\u0001\u0004G>l7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0017aD7vgR\f7\r[3GC\u000e$xN]=\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012\u0001D7vgR\f7\r[3kCZ\f'B\u0001\u0010\u000f\u0003\u00199\u0017\u000e\u001e5vE&\u0011\u0001e\u0007\u0002\u0010\u001bV\u001cH/Y2iK\u001a\u000b7\r^8ss\u00061A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0004\t\u000ba\u0011\u0001\u0019A\r)\u0005\t9\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0019IgN[3di*\tA&A\u0003kCZ\f\u00070\u0003\u0002/S\t1\u0011J\u001c6fGR\fAb\u0019:fCR,7\u000b\u001e:j]\u001e$2!\r\u001f?!\t\u0011\u0014H\u0004\u00024oA\u0011A\u0007F\u0007\u0002k)\u0011a\u0007E\u0001\u0007yI|w\u000e\u001e \n\u0005a\"\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\u000b\t\u000bu\u001a\u0001\u0019A\u0019\u0002\u0019Q,W\u000e\u001d7bi\u0016t\u0015-\\3\t\u000b}\u001a\u0001\u0019\u0001!\u0002\u0007=\u0014'\u000e\u0005\u0002\u0014\u0003&\u0011!\t\u0006\u0002\u0004\u0003:L\u0018\u0001D2sK\u0006$XMQ;gM\u0016\u0014HcA#L\u0019B\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nD\u0001\u0003S>L!AS$\u0003\u0007\t+h\rC\u0003>\t\u0001\u0007\u0011\u0007C\u0003@\t\u0001\u0007\u0001\t\u000b\u0002\u0001\u001dB\u0011\u0001fT\u0005\u0003!&\u0012\u0011bU5oO2,Go\u001c8")
public class MustacheService {
    private final MustacheFactory mustacheFactory;

    public String createString(String templateName, Object obj) {
        Mustache mustache = this.mustacheFactory.compile(templateName);
        StringWriter writer = new StringWriter();
        mustache.execute((Writer)writer, obj).flush();
        return writer.toString();
    }

    public Buf createBuffer(String templateName, Object obj) {
        Mustache mustache = this.mustacheFactory.compile(templateName);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);){
            mustache.execute((Writer)writer, obj);
        }
        return Buf.ByteArray$.Owned$.MODULE$.apply(outputStream.toByteArray());
    }

    @Inject
    public MustacheService(MustacheFactory mustacheFactory) {
        this.mustacheFactory = mustacheFactory;
    }
}

