/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finatra.utils;

import com.twitter.finatra.utils.FileResolver$;
import com.twitter.inject.conversions.boolean;
import com.twitter.inject.conversions.boolean$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javax.activation.MimetypesFileTypeMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\rs!B\u000f\u001f\u0011\u00039c!B\u0015\u001f\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004\"B\u001a\u0002\t\u0003!\u0004bBA\u0014\u0003\u0011\u0005\u0011\u0011\u0006\u0005\n\u0003[\t!\u0019!C\u0005\u0003_A\u0001\"!\u0011\u0002A\u0003%\u0011\u0011\u0007\u0004\u0005Sy\u0001a\u0007\u0003\u00058\u000f\t\u0005\t\u0015!\u00039\u0011!\u0019uA!A!\u0002\u0013A\u0004\"B\u0019\b\t\u0003!\u0005bB$\b\u0005\u0004%I\u0001\u0013\u0005\u0007#\u001e\u0001\u000b\u0011B%\t\u000fI;!\u0019!C\u0005'\"1qk\u0002Q\u0001\nQCq\u0001W\u0004C\u0002\u0013%\u0011\f\u0003\u0004[\u000f\u0001\u0006I\u0001\u000f\u0005\u00067\u001e!\t\u0001\u0018\u0005\u0006U\u001e!\ta\u001b\u0005\u0006[\u001e!\tA\u001c\u0005\u0006c\u001e!\tA\u001d\u0005\u0007k\u001e\u0001\u000bQ\u0002<\t\ra<\u0001\u0015!\u0004z\u0011\u0019Yx\u0001)A\u0007y\"1ap\u0002Q\u0005\n}D\u0001\"!\u0003\bA\u0013%\u00111\u0002\u0005\t\u0003\u001f9\u0001\u0015\"\u0003\u0002\u0012!A\u0011QC\u0004!\n\u0013\t9\u0002\u0003\u0005\u0002\u001c\u001d\u0001K\u0011BA\u000f\u000311\u0015\u000e\\3SKN|GN^3s\u0015\ty\u0002%A\u0003vi&d7O\u0003\u0002\"E\u00059a-\u001b8biJ\f'BA\u0012%\u0003\u001d!x/\u001b;uKJT\u0011!J\u0001\u0004G>l7\u0001\u0001\t\u0003Q\u0005i\u0011A\b\u0002\r\r&dWMU3t_24XM]\n\u0003\u0003-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001(\u0003AqWm\u001e'pG\u0006d'+Z:pYZ,'\u000fF\u00026\u0003G\u0001\"\u0001K\u0004\u0014\u0005\u001dY\u0013\u0001\u00047pG\u0006dGi\\2S_>$\bCA\u001dA\u001d\tQd\b\u0005\u0002<[5\tAH\u0003\u0002>M\u00051AH]8pizJ!aP\u0017\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007f5\nq\u0001Z8d%>|G\u000fF\u00026\u000b\u001aCQa\u000e\u0006A\u0002aBQa\u0011\u0006A\u0002a\na!\u001a=u\u001b\u0006\u0004X#A%\u0011\u0005){U\"A&\u000b\u00051k\u0015AC1di&4\u0018\r^5p]*\ta*A\u0003kCZ\f\u00070\u0003\u0002Q\u0017\n!R*[7fif\u0004Xm\u001d$jY\u0016$\u0016\u0010]3NCB\fq!\u001a=u\u001b\u0006\u0004\b%A\u0007m_\u000e\fGNR5mK6{G-Z\u000b\u0002)B\u0011A&V\u0005\u0003-6\u0012qAQ8pY\u0016\fg.\u0001\bm_\u000e\fGNR5mK6{G-\u001a\u0011\u0002\u001b\u0005\u001cG/^1m\t>\u001c'k\\8u+\u0005A\u0014AD1diV\fG\u000eR8d%>|G\u000fI\u0001\u000fO\u0016$\u0018J\u001c9viN#(/Z1n)\ti\u0006\u000eE\u0002-=\u0002L!aX\u0017\u0003\r=\u0003H/[8o!\t\tg-D\u0001c\u0015\t\u0019G-\u0001\u0002j_*\tQ-\u0001\u0003kCZ\f\u0017BA4c\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000b%\f\u0002\u0019\u0001\u001d\u0002\tA\fG\u000f[\u0001\u0007KbL7\u000f^:\u0015\u0005Qc\u0007\"B5\u0013\u0001\u0004A\u0014AD4fi\u000e{g\u000e^3oiRK\b/\u001a\u000b\u0003q=DQ\u0001]\nA\u0002a\nAAZ5mK\u0006\u0001r-\u001a;GS2,W\t\u001f;f]NLwN\u001c\u000b\u0003qMDQ\u0001\u001e\u000bA\u0002a\n\u0001BZ5mK:\fW.Z\u0001\u000f+:K\u0005lX*F!\u0006\u0013\u0016\tV(S\u001f\u00059H$A\u0018\u0002#]Ke\nR(X'~\u001bV\tU!S\u0003R{%kD\u0001{9\u0005a\u0016aE#Y)\u0016s5+S(O?N+\u0005+\u0011*B)>\u0013v\"A?\u001d\u00039\nQcZ3u\u0019\u0006\u001cHoU3qCJ\fGo\u001c:J]\u0012,\u0007\u0010\u0006\u0003\u0002\u0002\u0005\u001d\u0001c\u0001\u0017\u0002\u0004%\u0019\u0011QA\u0017\u0003\u0007%sG\u000fC\u0003u1\u0001\u0007\u0001(A\u0006jg\u0012K'/Z2u_JLHc\u0001+\u0002\u000e!)\u0011.\u0007a\u0001q\u00059r-\u001a;DY\u0006\u001c8\u000f]1uQ&s\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0004;\u0006M\u0001\"B5\u001b\u0001\u0004A\u0014aF4fi2{7-\u00197GS2,\u0017J\u001c9viN#(/Z1n)\ri\u0016\u0011\u0004\u0005\u0006Sn\u0001\r\u0001O\u0001\u0014I>$H/\u001a3GS2,W\t\u001f;f]NLwN\u001c\u000b\u0004q\u0005}\u0001BBA\u00119\u0001\u0007\u0001(A\u0002ve&Da!!\n\u0004\u0001\u0004A\u0014\u0001\u0002:p_R\f1B\\3x%\u0016\u001cx\u000e\u001c<feR\u0019Q'a\u000b\t\r\u0005\u0015B\u00011\u00019\u0003\u0019awnZ4feV\u0011\u0011\u0011\u0007\t\u0005\u0003g\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u001dawnZ4j]\u001eT1!a\u000f#\u0003\u0011)H/\u001b7\n\t\u0005}\u0012Q\u0007\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0001")
public class FileResolver {
    private final String localDocRoot;
    private final String docRoot;
    private final MimetypesFileTypeMap extMap;
    private final boolean localFileMode;
    private final String actualDocRoot;

    public static FileResolver newResolver(String root) {
        return FileResolver$.MODULE$.newResolver(root);
    }

    public static FileResolver newLocalResolver(String root) {
        return FileResolver$.MODULE$.newLocalResolver(root);
    }

    private MimetypesFileTypeMap extMap() {
        return this.extMap;
    }

    private boolean localFileMode() {
        return this.localFileMode;
    }

    private String actualDocRoot() {
        return this.actualDocRoot;
    }

    public Option<InputStream> getInputStream(String path) {
        Predef$.MODULE$.assert(path.startsWith("/"));
        return this.isDirectory(path) ? None$.MODULE$ : (this.localFileMode() ? this.getLocalFileInputStream(path) : this.getClasspathInputStream(path));
    }

    public boolean exists(String path) {
        Predef$.MODULE$.assert(path.startsWith("/"));
        return this.isDirectory(path) ? false : (this.localFileMode() ? Files.exists(Paths.get(path, new String[0]), new LinkOption[0]) || Files.exists(Paths.get(this.localDocRoot, path), new LinkOption[0]) : this.getClasspathInputStream(path).isDefined());
    }

    public String getContentType(String file) {
        return this.extMap().getContentType(this.dottedFileExtension(file));
    }

    public String getFileExtension(String filename) {
        int extensionPos;
        int lastSeparator = this.getLastSeparatorIndex(filename);
        return lastSeparator >= (extensionPos = filename.lastIndexOf(46)) ? "" : filename.substring(extensionPos);
    }

    /*
     * WARNING - void declaration
     */
    private int getLastSeparatorIndex(String filename) {
        void var3_3;
        int lastWindowPos;
        int lastUnixPos = filename.lastIndexOf(47);
        return lastUnixPos > (lastWindowPos = filename.lastIndexOf(92)) ? lastUnixPos : var3_3;
    }

    private boolean isDirectory(String path) {
        return path.endsWith("/");
    }

    private Option<InputStream> getClasspathInputStream(String path) {
        String actualPath = !this.docRoot.isEmpty() ? new StringBuilder(0).append(this.actualDocRoot()).append(path).toString() : path;
        return Option$.MODULE$.apply((Object)this.getClass().getResourceAsStream(actualPath)).map((Function1 & Serializable)is -> {
            BufferedInputStream bis = new BufferedInputStream((InputStream)is);
            return new Tuple2(is, (Object)bis);
        }).withFilter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileResolver.$anonfun$getClasspathInputStream$2(x$1))).map((Function1 & Serializable)x$2 -> {
            BufferedInputStream bis;
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BufferedInputStream bufferedInputStream = bis = (BufferedInputStream)tuple2._2();
            return bufferedInputStream;
        });
    }

    private Option<InputStream> getLocalFileInputStream(String path) {
        File file = Files.exists(Paths.get(path, new String[0]), new LinkOption[0]) ? new File(path) : new File(this.localDocRoot, path);
        return file.exists() ? Option$.MODULE$.apply((Object)new BufferedInputStream(new FileInputStream(file))) : None$.MODULE$;
    }

    private String dottedFileExtension(String uri) {
        return new StringBuilder(1).append(".").append(this.getFileExtension(uri)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getClasspathInputStream$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BufferedInputStream bis = (BufferedInputStream)tuple2._2();
        boolean bl = bis.available() > 0;
        return bl;
    }

    public FileResolver(String localDocRoot, String docRoot) {
        this.localDocRoot = localDocRoot;
        this.docRoot = docRoot;
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(localDocRoot)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(docRoot))) {
            throw new AssertionError((Object)"assertion failed: Cannot set both -local.doc.root and -doc.root flags.");
        }
        this.extMap = new MimetypesFileTypeMap();
        this.localFileMode = boolean.RichBoolean$.MODULE$.onTrue$extension(boolean$.MODULE$.RichBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(localDocRoot))), (Function0)(JFunction0.mcV.sp & Serializable)() -> FileResolver$.MODULE$.com$twitter$finatra$utils$FileResolver$$logger().info("Local file mode enabled"));
        this.actualDocRoot = docRoot.startsWith("/") ? docRoot : new StringBuilder(1).append("/").append(docRoot).toString();
    }
}

