/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.core.endpoint;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.twitter.hbc.core.HttpConstants;
import com.twitter.hbc.core.endpoint.Endpoint;
import com.twitter.joauth.UrlCodec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BaseEndpoint
implements Endpoint {
    protected final ConcurrentMap<String, String> queryParameters;
    protected final ConcurrentMap<String, String> postParameters;
    protected final String path;
    protected final String httpMethod;
    protected volatile String apiVersion;

    public BaseEndpoint(String path, String httpMethod) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.httpMethod = (String)Preconditions.checkNotNull((Object)httpMethod);
        Preconditions.checkArgument((boolean)HttpConstants.checkHttpMethod(httpMethod));
        this.queryParameters = new ConcurrentHashMap<String, String>();
        this.postParameters = new ConcurrentHashMap<String, String>();
        this.apiVersion = "1.1";
    }

    public String getPath(String apiVersion) {
        return "/" + apiVersion + this.path;
    }

    public final String getPath() {
        return this.getPath(this.apiVersion);
    }

    @Override
    public String getURI() {
        this.addDefaultParams();
        if (this.queryParameters.isEmpty()) {
            return this.getPath();
        }
        return this.getPath() + "?" + this.generateParamString(this.queryParameters);
    }

    protected void addDefaultParams() {
    }

    protected String generateParamString(Map<String, String> params) {
        return Joiner.on((String)"&").withKeyValueSeparator("=").join(params);
    }

    @Override
    public String getQueryParamString() {
        return this.generateParamString(this.queryParameters);
    }

    @Override
    public String getPostParamString() {
        return this.generateParamString(this.postParameters);
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void addPostParameter(String param, String value) {
        this.postParameters.put(UrlCodec.encode((String)param), UrlCodec.encode((String)value));
    }

    @Override
    public void removePostParameter(String param) {
        this.postParameters.remove(UrlCodec.encode((String)param));
    }

    @Override
    public void addQueryParameter(String param, String value) {
        this.queryParameters.put(UrlCodec.encode((String)param), UrlCodec.encode((String)value));
    }

    @Override
    public void removeQueryParameter(String param) {
        this.queryParameters.remove(UrlCodec.encode((String)param));
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = (String)Preconditions.checkNotNull((Object)apiVersion);
    }
}

