/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.hooks;

import backtype.storm.hooks.ITaskHook;
import backtype.storm.hooks.info.BoltAckInfo;
import backtype.storm.hooks.info.BoltExecuteInfo;
import backtype.storm.hooks.info.BoltFailInfo;
import backtype.storm.hooks.info.EmitInfo;
import backtype.storm.hooks.info.SpoutAckInfo;
import backtype.storm.hooks.info.SpoutFailInfo;
import com.twitter.heron.api.topology.TopologyContext;
import com.twitter.heron.common.basics.TypeUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ITaskHookDelegate
implements com.twitter.heron.api.hooks.ITaskHook {
    private List<ITaskHook> hooks = new LinkedList<ITaskHook>();
    private Map<String, Object> conf;

    public void addHook(ITaskHook iTaskHook) {
        this.hooks.add(iTaskHook);
    }

    public List<ITaskHook> getHooks() {
        return this.hooks;
    }

    public Map<String, Object> getConf() {
        return this.conf;
    }

    @Override
    public void prepare(Map<String, Object> map, TopologyContext topologyContext) {
        this.conf = map;
        if (!map.containsKey("stormcompat.topology.auto.task.hooks")) {
            throw new RuntimeException("StormCompat Translation not done for task hooks");
        }
        List<String> list = TypeUtils.getListOfStrings(map.get("stormcompat.topology.auto.task.hooks"));
        for (String object : list) {
            ITaskHook iTaskHook;
            try {
                iTaskHook = (ITaskHook)Class.forName(object).newInstance();
            }
            catch (ClassNotFoundException instantiationException) {
                throw new RuntimeException(instantiationException + " ITaskHook class must be in class path.");
            }
            catch (InstantiationException illegalAccessException) {
                throw new RuntimeException(illegalAccessException + " ITaskHook class must be concrete.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException + " ITaskHook class must have a no-arg constructor.");
            }
            this.hooks.add(iTaskHook);
        }
        backtype.storm.task.TopologyContext topologyContext2 = new backtype.storm.task.TopologyContext(topologyContext);
        for (ITaskHook iTaskHook : this.hooks) {
            iTaskHook.prepare(map, topologyContext2);
        }
    }

    @Override
    public void cleanup() {
        for (ITaskHook iTaskHook : this.hooks) {
            iTaskHook.cleanup();
        }
    }

    @Override
    public void emit(com.twitter.heron.api.hooks.info.EmitInfo emitInfo) {
        EmitInfo emitInfo2 = new EmitInfo(emitInfo);
        for (ITaskHook iTaskHook : this.hooks) {
            iTaskHook.emit(emitInfo2);
        }
    }

    @Override
    public void spoutAck(com.twitter.heron.api.hooks.info.SpoutAckInfo spoutAckInfo) {
        SpoutAckInfo spoutAckInfo2 = new SpoutAckInfo(spoutAckInfo);
        for (ITaskHook iTaskHook : this.hooks) {
            iTaskHook.spoutAck(spoutAckInfo2);
        }
    }

    @Override
    public void spoutFail(com.twitter.heron.api.hooks.info.SpoutFailInfo spoutFailInfo) {
        SpoutFailInfo spoutFailInfo2 = new SpoutFailInfo(spoutFailInfo);
        for (ITaskHook iTaskHook : this.hooks) {
            iTaskHook.spoutFail(spoutFailInfo2);
        }
    }

    @Override
    public void boltAck(com.twitter.heron.api.hooks.info.BoltAckInfo boltAckInfo) {
        BoltAckInfo boltAckInfo2 = new BoltAckInfo(boltAckInfo);
        for (ITaskHook iTaskHook : this.hooks) {
            iTaskHook.boltAck(boltAckInfo2);
        }
    }

    @Override
    public void boltFail(com.twitter.heron.api.hooks.info.BoltFailInfo boltFailInfo) {
        BoltFailInfo boltFailInfo2 = new BoltFailInfo(boltFailInfo);
        for (ITaskHook iTaskHook : this.hooks) {
            iTaskHook.boltFail(boltFailInfo2);
        }
    }

    @Override
    public void boltExecute(com.twitter.heron.api.hooks.info.BoltExecuteInfo boltExecuteInfo) {
        BoltExecuteInfo boltExecuteInfo2 = new BoltExecuteInfo(boltExecuteInfo);
        for (ITaskHook iTaskHook : this.hooks) {
            iTaskHook.boltExecute(boltExecuteInfo2);
        }
    }
}

