/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.serialization;

import backtype.storm.serialization.SerializationFactory;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.twitter.heron.api.serializer.IPluggableSerializer;
import java.util.Map;

public class HeronPluggableSerializerDelegate
implements IPluggableSerializer {
    private Kryo kryo;
    private Output kryoOut;
    private Input kryoIn;

    @Override
    public void initialize(Map<String, Object> map) {
        this.kryo = SerializationFactory.getKryo(map);
        this.kryoOut = new Output(2000, 2000000000);
        this.kryoIn = new Input(1);
    }

    @Override
    public byte[] serialize(Object object) {
        this.kryoOut.clear();
        this.kryo.writeClassAndObject(this.kryoOut, object);
        return this.kryoOut.toBytes();
    }

    @Override
    public Object deserialize(byte[] byArray) {
        this.kryoIn.setBuffer(byArray);
        return this.kryo.readClassAndObject(this.kryoIn);
    }
}

