/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.serialization;

import backtype.storm.serialization.IKryoDecorator;
import backtype.storm.serialization.IKryoFactory;
import backtype.storm.serialization.types.ArrayListSerializer;
import backtype.storm.serialization.types.HashMapSerializer;
import backtype.storm.serialization.types.HashSetSerializer;
import backtype.storm.tuple.Values;
import backtype.storm.utils.ListDelegate;
import backtype.storm.utils.Utils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public final class SerializationFactory {
    public static final Logger LOG = Logger.getLogger(SerializationFactory.class.getName());

    private SerializationFactory() {
    }

    public static Kryo getKryo(Map<String, Object> map) {
        Object object;
        Object object2;
        IKryoFactory iKryoFactory = (IKryoFactory)Utils.newInstance((String)map.get("topology.kryo.factory"));
        Kryo kryo = iKryoFactory.getKryo(map);
        kryo.register(byte[].class);
        kryo.register(ListDelegate.class);
        kryo.register(ArrayList.class, new ArrayListSerializer());
        kryo.register(HashMap.class, new HashMapSerializer());
        kryo.register(HashSet.class, new HashSetSerializer());
        kryo.register(BigInteger.class, new DefaultSerializers.BigIntegerSerializer());
        kryo.register(Values.class);
        Map<String, String> map2 = SerializationFactory.normalizeKryoRegister(map);
        iKryoFactory.preRegister(kryo, map);
        boolean bl = (Boolean)map.get("topology.skip.missing.kryo.registrations");
        for (String string : map2.keySet()) {
            object2 = map2.get(string);
            try {
                object = Class.forName(string);
                Class<?> clazz = null;
                if (object2 != null) {
                    clazz = Class.forName((String)object2);
                }
                LOG.info("Doing kryo.register for class " + object);
                if (clazz == null) {
                    kryo.register((Class)object);
                    continue;
                }
                kryo.register((Class)object, SerializationFactory.resolveSerializerInstance(kryo, (Class)object, clazz));
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    LOG.info("Could not find serialization or class for " + (String)object2 + ". Skipping registration...");
                    continue;
                }
                throw new RuntimeException(classNotFoundException);
            }
        }
        iKryoFactory.postRegister(kryo, map);
        if (map.get("topology.kryo.decorators") != null) {
            for (String string : (List)map.get("topology.kryo.decorators")) {
                try {
                    object2 = Class.forName(string);
                    object = (IKryoDecorator)((Class)object2).newInstance();
                    object.decorate(kryo);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        LOG.info("Could not find kryo decorator named " + string + ". Skipping registration...");
                        continue;
                    }
                    throw new RuntimeException(classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
            }
        }
        iKryoFactory.postDecorate(kryo, map);
        return kryo;
    }

    private static Serializer resolveSerializerInstance(Kryo kryo, Class clazz, Class<? extends Serializer> clazz2) {
        try {
            Constructor<? extends Serializer> constructor = clazz2.getConstructor(Kryo.class, Class.class);
            return constructor.newInstance(kryo, clazz);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            try {
                Constructor<? extends Serializer> constructor = clazz2.getConstructor(Kryo.class);
                return constructor.newInstance(kryo);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException2) {
                try {
                    Constructor<? extends Serializer> constructor = clazz2.getConstructor(Class.class);
                    return constructor.newInstance(kryo);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException3) {
                    throw new IllegalArgumentException(String.format("Unable to create serializer \"%s\" for class: %s", clazz2.getName(), clazz.getName()));
                }
            }
        }
    }

    private static Map<String, String> normalizeKryoRegister(Map<String, Object> map) {
        Object object = map.get("topology.kryo.register");
        if (object == null) {
            return new TreeMap<String, String>();
        }
        Map map2 = new HashMap();
        if (object instanceof Map) {
            map2 = (Map)object;
        } else {
            for (Object e : (List)object) {
                if (e instanceof Map) {
                    map2.putAll((Map)e);
                    continue;
                }
                map2.put((String)e, null);
            }
        }
        return new TreeMap<String, String>(map2);
    }
}

