/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.topology;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.FailedException;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.ReportedFailedException;
import backtype.storm.tuple.Tuple;
import java.util.Map;

public class BasicBoltExecutor
implements IRichBolt {
    private static final long serialVersionUID = 4359767045622072660L;
    private IBasicBolt delegate;
    private transient BasicOutputCollector collector;

    public BasicBoltExecutor(IBasicBolt iBasicBolt) {
        this.delegate = iBasicBolt;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        this.delegate.declareOutputFields(outputFieldsDeclarer);
    }

    @Override
    public void prepare(Map map, TopologyContext topologyContext, OutputCollector outputCollector) {
        this.delegate.prepare(map, topologyContext);
        this.collector = new BasicOutputCollector(outputCollector);
    }

    @Override
    public void execute(Tuple tuple) {
        this.collector.setContext(tuple);
        try {
            this.delegate.execute(tuple, this.collector);
            this.collector.getOutputter().ack(tuple);
        }
        catch (FailedException failedException) {
            if (failedException instanceof ReportedFailedException) {
                this.collector.reportError(failedException);
            }
            this.collector.getOutputter().fail(tuple);
        }
    }

    @Override
    public void cleanup() {
        this.delegate.cleanup();
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.delegate.getComponentConfiguration();
    }
}

