/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.hooks.ITaskHookDelegate;
import com.twitter.heron.api.Config;
import java.lang.constant.Constable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static Config translateConfig(Map<String, Object> map) {
        Constable constable;
        Config config = new Config(map);
        ConfigUtils.doSerializationTranslation(config);
        if (config.containsKey("topology.enable.message.timeouts")) {
            config.put("topology.enable.message.timeouts", config.get("topology.enable.message.timeouts").toString());
        }
        if (config.containsKey("topology.workers")) {
            constable = (Integer)config.get("topology.workers");
            Config.setNumStmgrs(config, (Integer)constable);
        }
        if (config.containsKey("topology.acker.executors")) {
            constable = (Integer)config.get("topology.acker.executors");
            Config.setEnableAcking(config, (Integer)constable > 0);
        }
        if (config.containsKey("topology.message.timeout.secs")) {
            constable = (Integer)config.get("topology.message.timeout.secs");
            Config.setMessageTimeoutSecs(config, (Integer)constable);
        }
        if (config.containsKey("topology.max.spout.pending")) {
            constable = Integer.valueOf(Integer.parseInt(config.get("topology.max.spout.pending").toString()));
            Config.setMaxSpoutPending(config, (Integer)constable);
        }
        if (config.containsKey("topology.tick.tuple.freq.secs")) {
            constable = Integer.valueOf(Integer.parseInt(config.get("topology.tick.tuple.freq.secs").toString()));
            Config.setTickTupleFrequency(config, (Integer)constable);
        }
        if (config.containsKey("topology.debug")) {
            constable = Boolean.valueOf(Boolean.parseBoolean(config.get("topology.debug").toString()));
            Config.setDebug(config, (Boolean)constable);
        }
        ConfigUtils.doTaskHooksTranslation(config);
        return config;
    }

    private static void doSerializationTranslation(Config config) {
        if (config.containsKey("topology.fall.back.on.java.serialization") && config.get("topology.fall.back.on.java.serialization") instanceof Boolean && ((Boolean)config.get("topology.fall.back.on.java.serialization")).booleanValue()) {
            Config.setSerializationClassName(config, "com.twitter.heron.api.serializer.JavaSerializer");
        } else {
            config.put("topology.fall.back.on.java.serialization", false);
            Config.setSerializationClassName(config, "backtype.storm.serialization.HeronPluggableSerializerDelegate");
            if (!config.containsKey("topology.kryo.factory")) {
                config.put("topology.kryo.factory", "backtype.storm.serialization.DefaultKryoFactory");
            } else if (!(config.get("topology.kryo.factory") instanceof String)) {
                throw new RuntimeException("topology.kryo.factory has to be set to a class name");
            }
            if (!config.containsKey("topology.skip.missing.kryo.registrations")) {
                config.put("topology.skip.missing.kryo.registrations", false);
            } else if (!(config.get("topology.skip.missing.kryo.registrations") instanceof Boolean)) {
                throw new RuntimeException("topology.skip.missing.kryo.registrations has to be boolean");
            }
        }
    }

    private static void doTaskHooksTranslation(Config config) {
        List<String> list = config.getAutoTaskHooks();
        if (list != null) {
            config.put("stormcompat.topology.auto.task.hooks", list);
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(ITaskHookDelegate.class.getName());
            config.setAutoTaskHooks(linkedList);
        }
    }
}

