/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api;

import com.twitter.heron.common.basics.TypeUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;

public class Config
extends HashMap<String, Object> {
    private static final long serialVersionUID = 2550967708478837032L;
    public static final String TOPOLOGY_WORKER_CHILDOPTS = "topology.worker.childopts";
    public static final String TOPOLOGY_COMPONENT_JVMOPTS = "topology.component.jvmopts";
    public static final String TOPOLOGY_TICK_TUPLE_FREQ_SECS = "topology.tick.tuple.freq.secs";
    public static final String TOPOLOGY_ENABLE_MESSAGE_TIMEOUTS = "topology.enable.message.timeouts";
    public static final String TOPOLOGY_DEBUG = "topology.debug";
    public static final String TOPOLOGY_STMGRS = "topology.stmgrs";
    public static final String TOPOLOGY_MESSAGE_TIMEOUT_SECS = "topology.message.timeout.secs";
    public static final String TOPOLOGY_COMPONENT_PARALLELISM = "topology.component.parallelism";
    public static final String TOPOLOGY_MAX_SPOUT_PENDING = "topology.max.spout.pending";
    public static final String TOPOLOGY_AUTO_TASK_HOOKS = "topology.auto.task.hooks";
    public static final String TOPOLOGY_SERIALIZER_CLASSNAME = "topology.serializer.classname";
    public static final String TOPOLOGY_ENABLE_ACKING = "topology.acking";
    public static final String TOPOLOGY_CONTAINER_CPU_REQUESTED = "topology.container.cpu";
    public static final String TOPOLOGY_CONTAINER_RAM_REQUESTED = "topology.container.ram";
    public static final String TOPOLOGY_CONTAINER_DISK_REQUESTED = "topology.container.disk";
    public static final String TOPOLOGY_COMPONENT_RAMMAP = "topology.component.rammap";
    public static final String TOPOLOGY_NAME = "topology.name";
    public static final String TOPOLOGY_TEAM_NAME = "topology.team.name";
    public static final String TOPOLOGY_TEAM_EMAIL = "topology.team.email";
    public static final String TOPOLOGY_CAP_TICKET = "topology.cap.ticket";
    public static final String TOPOLOGY_PROJECT_NAME = "topology.project.name";
    public static final String TOPOLOGY_ADDITIONAL_CLASSPATH = "topology.additional.classpath";
    private static Set<String> apiVars = new HashSet<String>();

    public Config() {
    }

    public Config(Map<String, Object> map) {
        super(map);
    }

    public static void setDebug(Map<String, Object> map, boolean bl) {
        map.put(TOPOLOGY_DEBUG, String.valueOf(bl));
    }

    public static void setTeamName(Map<String, Object> map, String string) {
        map.put(TOPOLOGY_TEAM_NAME, string);
    }

    public static void setTeamEmail(Map<String, Object> map, String string) {
        map.put(TOPOLOGY_TEAM_EMAIL, string);
    }

    public static void setTopologyCapTicket(Map<String, Object> map, String string) {
        map.put(TOPOLOGY_CAP_TICKET, string);
    }

    public static void setTopologyProjectName(Map<String, Object> map, String string) {
        map.put(TOPOLOGY_PROJECT_NAME, string);
    }

    public static void setNumStmgrs(Map<String, Object> map, int n) {
        map.put(TOPOLOGY_STMGRS, Integer.toString(n));
    }

    public static void setSerializationClassName(Map<String, Object> map, String string) {
        map.put(TOPOLOGY_SERIALIZER_CLASSNAME, string);
    }

    public static void setEnableAcking(Map<String, Object> map, boolean bl) {
        map.put(TOPOLOGY_ENABLE_ACKING, String.valueOf(bl));
    }

    public static void setMessageTimeoutSecs(Map<String, Object> map, int n) {
        map.put(TOPOLOGY_MESSAGE_TIMEOUT_SECS, Integer.toString(n));
    }

    public static void setComponentParallelism(Map<String, Object> map, int n) {
        map.put(TOPOLOGY_COMPONENT_PARALLELISM, Integer.toString(n));
    }

    public static void setMaxSpoutPending(Map<String, Object> map, int n) {
        map.put(TOPOLOGY_MAX_SPOUT_PENDING, Integer.toString(n));
    }

    public static void setTickTupleFrequency(Map<String, Object> map, int n) {
        map.put(TOPOLOGY_TICK_TUPLE_FREQ_SECS, Integer.toString(n));
    }

    public static void setContainerCpuRequested(Map<String, Object> map, float f) {
        map.put(TOPOLOGY_CONTAINER_CPU_REQUESTED, Float.toString(f));
    }

    public static void setContainerDiskRequested(Map<String, Object> map, long l) {
        map.put(TOPOLOGY_CONTAINER_DISK_REQUESTED, Long.toString(l));
    }

    public static void setContainerRamRequested(Map<String, Object> map, long l) {
        map.put(TOPOLOGY_CONTAINER_RAM_REQUESTED, Long.toString(l));
    }

    public static void setComponentRamMap(Map<String, Object> map, String string) {
        map.put(TOPOLOGY_COMPONENT_RAMMAP, string);
    }

    public static void setAutoTaskHooks(Map<String, Object> map, List<String> list) {
        map.put(TOPOLOGY_AUTO_TASK_HOOKS, list);
    }

    public static List<String> getAutoTaskHooks(Map<String, Object> map) {
        return TypeUtils.getListOfStrings(map.get(TOPOLOGY_AUTO_TASK_HOOKS));
    }

    public static void setComponentRam(Map<String, Object> map, String string, long l) {
        if (map.containsKey(TOPOLOGY_COMPONENT_RAMMAP)) {
            String string2 = (String)map.get(TOPOLOGY_COMPONENT_RAMMAP);
            String string3 = String.format("%s,%s:%d", string2, string, l);
            map.put(TOPOLOGY_COMPONENT_RAMMAP, string3);
        } else {
            String string4 = String.format("%s:%d", string, l);
            map.put(TOPOLOGY_COMPONENT_RAMMAP, string4);
        }
    }

    public static void setComponentJvmOptions(Map<String, Object> map, String string, String string2) {
        String string3;
        String string4 = DatatypeConverter.printBase64Binary((byte[])string2.getBytes(StandardCharsets.UTF_8));
        String string5 = DatatypeConverter.printBase64Binary((byte[])string.getBytes(StandardCharsets.UTF_8));
        String string6 = (String)map.get(TOPOLOGY_COMPONENT_JVMOPTS);
        if (string6 == null) {
            string3 = String.format("{\"%s\":\"%s\"}", string5, string4);
        } else {
            string6 = string6.substring(1, string6.length() - 1);
            string3 = String.format("{%s,\"%s\":\"%s\"}", string6, string5, string4);
        }
        map.put(TOPOLOGY_COMPONENT_JVMOPTS, string3);
    }

    public void setDebug(boolean bl) {
        Config.setDebug(this, bl);
    }

    public void setTeamName(String string) {
        Config.setTeamName(this, string);
    }

    public void setTeamEmail(String string) {
        Config.setTeamEmail(this, string);
    }

    public void setTopologyCapTicket(String string) {
        Config.setTopologyCapTicket(this, string);
    }

    public void setTopologyProjectName(String string) {
        Config.setTopologyProjectName(this, string);
    }

    public void setNumStmgrs(int n) {
        Config.setNumStmgrs(this, n);
    }

    public void setSerializationClassName(String string) {
        Config.setSerializationClassName(this, string);
    }

    public void setEnableAcking(boolean bl) {
        Config.setEnableAcking(this, bl);
    }

    public void setMessageTimeoutSecs(int n) {
        Config.setMessageTimeoutSecs(this, n);
    }

    public void setComponentParallelism(int n) {
        Config.setComponentParallelism(this, n);
    }

    public void setMaxSpoutPending(int n) {
        Config.setMaxSpoutPending(this, n);
    }

    public void setTickTupleFrequency(int n) {
        Config.setTickTupleFrequency(this, n);
    }

    public void setContainerCpuRequested(float f) {
        Config.setContainerCpuRequested(this, f);
    }

    public void setContainerDiskRequested(long l) {
        Config.setContainerDiskRequested(this, l);
    }

    public void setContainerRamRequested(long l) {
        Config.setContainerRamRequested(this, l);
    }

    public void setComponentRamMap(String string) {
        Config.setComponentRamMap(this, string);
    }

    public void setComponentRam(String string, long l) {
        Config.setComponentRam(this, string, l);
    }

    public List<String> getAutoTaskHooks() {
        return Config.getAutoTaskHooks(this);
    }

    public void setAutoTaskHooks(List<String> list) {
        Config.setAutoTaskHooks(this, list);
    }

    public void addClasspath(Map<String, Object> map, String string) {
        String string2 = TOPOLOGY_ADDITIONAL_CLASSPATH;
        if (map.containsKey(string2)) {
            String string3 = String.format("%s:%s", map.get(string2), string);
            map.put(string2, string3);
        } else {
            map.put(string2, string);
        }
    }

    public void setComponentJvmOptions(String string, String string2) {
        Config.setComponentJvmOptions(this, string, string2);
    }

    public Set<String> getApiVars() {
        return apiVars;
    }

    static {
        apiVars.add(TOPOLOGY_DEBUG);
        apiVars.add(TOPOLOGY_STMGRS);
        apiVars.add(TOPOLOGY_MESSAGE_TIMEOUT_SECS);
        apiVars.add(TOPOLOGY_COMPONENT_PARALLELISM);
        apiVars.add(TOPOLOGY_MAX_SPOUT_PENDING);
        apiVars.add(TOPOLOGY_WORKER_CHILDOPTS);
        apiVars.add(TOPOLOGY_COMPONENT_JVMOPTS);
        apiVars.add(TOPOLOGY_SERIALIZER_CLASSNAME);
        apiVars.add(TOPOLOGY_TICK_TUPLE_FREQ_SECS);
        apiVars.add(TOPOLOGY_ENABLE_MESSAGE_TIMEOUTS);
        apiVars.add(TOPOLOGY_ENABLE_ACKING);
        apiVars.add(TOPOLOGY_CONTAINER_CPU_REQUESTED);
        apiVars.add(TOPOLOGY_CONTAINER_DISK_REQUESTED);
        apiVars.add(TOPOLOGY_CONTAINER_RAM_REQUESTED);
        apiVars.add(TOPOLOGY_COMPONENT_RAMMAP);
        apiVars.add(TOPOLOGY_NAME);
        apiVars.add(TOPOLOGY_TEAM_NAME);
        apiVars.add(TOPOLOGY_TEAM_EMAIL);
        apiVars.add(TOPOLOGY_CAP_TICKET);
        apiVars.add(TOPOLOGY_PROJECT_NAME);
        apiVars.add(TOPOLOGY_ADDITIONAL_CLASSPATH);
    }
}

