/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api;

import com.twitter.heron.api.Config;
import com.twitter.heron.api.HeronTopology;
import com.twitter.heron.api.exception.AlreadyAliveException;
import com.twitter.heron.api.exception.InvalidTopologyException;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.utils.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HeronSubmitter {
    private static final Logger LOG = Logger.getLogger(HeronSubmitter.class.getName());

    private HeronSubmitter() {
    }

    public static void submitTopology(String string, Config config, HeronTopology heronTopology) throws AlreadyAliveException, InvalidTopologyException {
        Map<String, String> map = Utils.readCommandLineOpts();
        TopologyAPI.TopologyState topologyState = map.get("cmdline.topology.initial.state") != null ? TopologyAPI.TopologyState.valueOf(map.get("cmdline.topology.initial.state")) : TopologyAPI.TopologyState.RUNNING;
        LOG.log(Level.FINE, "To deploy a topology in initial state {0}", topologyState);
        TopologyAPI.Topology topology = heronTopology.setConfig(config).setName(string).setState(topologyState).getTopology();
        assert (topology.isInitialized());
        if (map.get("cmdline.topologydefn.tmpdirectory") == null) {
            throw new RuntimeException("topology definition temp directory not specified");
        }
        HeronSubmitter.submitTopologyToFile(topology, map);
    }

    private static void submitTopologyToFile(TopologyAPI.Topology topology, Map<String, String> map) {
        String string = map.get("cmdline.topologydefn.tmpdirectory");
        if (string == null || string.isEmpty()) {
            throw new RuntimeException("Improper specification of directory");
        }
        String string2 = string + "/" + topology.getName() + ".defn";
        BufferedOutputStream bufferedOutputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string2));
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = topology.toByteArray();
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing topology defn to temp directory " + string);
        }
    }

    public static String submitJar(Config config, String string) {
        throw new UnsupportedOperationException("submitJar unsupported");
    }
}

