/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api;

import com.google.protobuf.ByteString;
import com.twitter.heron.api.Config;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.utils.Utils;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class HeronTopology {
    private TopologyAPI.Topology.Builder topologyBuilder;
    private String name;
    private TopologyAPI.TopologyState state;
    private Config heronConfig;

    public HeronTopology(TopologyAPI.Topology.Builder builder) {
        this.topologyBuilder = builder;
    }

    private static TopologyAPI.Config.Builder getConfigBuilder(Config config) {
        TopologyAPI.Config.Builder builder = TopologyAPI.Config.newBuilder();
        Set<String> set = config.getApiVars();
        for (Map.Entry entry : config.entrySet()) {
            TopologyAPI.Config.KeyValue.Builder builder2 = TopologyAPI.Config.KeyValue.newBuilder();
            builder2.setKey((String)entry.getKey());
            if (set.contains(entry.getKey())) {
                builder2.setValue(entry.getValue().toString());
            } else {
                builder2.setJavaSerializedValue(ByteString.copyFrom(Utils.serialize(entry.getValue())));
            }
            builder.addKvs(builder2);
        }
        return builder;
    }

    private static void addDefaultTopologyConfig(Map<String, Object> map) {
        if (!map.containsKey("topology.debug")) {
            map.put("topology.debug", "false");
        }
        if (!map.containsKey("topology.stmgrs")) {
            map.put("topology.stmgrs", "1");
        }
        if (!map.containsKey("topology.message.timeout.secs")) {
            map.put("topology.message.timeout.secs", "30");
        }
        if (!map.containsKey("topology.component.parallelism")) {
            map.put("topology.component.parallelism", "1");
        }
        if (!map.containsKey("topology.max.spout.pending")) {
            map.put("topology.max.spout.pending", "100");
        }
        if (!map.containsKey("topology.acking")) {
            map.put("topology.acking", "false");
        }
        if (!map.containsKey("topology.enable.message.timeouts")) {
            map.put("topology.enable.message.timeouts", "true");
        }
    }

    public TopologyAPI.Topology getTopology() {
        if (this.name == null || this.state == null || this.heronConfig == null) {
            throw new IllegalArgumentException("Failed to build topology; missing necessary info.");
        }
        String string = this.name + UUID.randomUUID().toString();
        this.topologyBuilder.setId(string);
        this.topologyBuilder.setName(this.name);
        this.topologyBuilder.setState(this.state);
        HeronTopology.addDefaultTopologyConfig(this.heronConfig);
        this.heronConfig.put("topology.name", this.name);
        this.topologyBuilder.setTopologyConfig(HeronTopology.getConfigBuilder(this.heronConfig));
        return this.topologyBuilder.build();
    }

    public HeronTopology setName(String string) {
        this.name = string;
        return this;
    }

    public HeronTopology setState(TopologyAPI.TopologyState topologyState) {
        this.state = topologyState;
        return this;
    }

    public HeronTopology setConfig(Config config) {
        this.heronConfig = config;
        return this;
    }
}

