/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.bolt;

import com.twitter.heron.api.bolt.BasicOutputCollector;
import com.twitter.heron.api.bolt.IBasicBolt;
import com.twitter.heron.api.bolt.IRichBolt;
import com.twitter.heron.api.bolt.OutputCollector;
import com.twitter.heron.api.exception.FailedException;
import com.twitter.heron.api.exception.ReportedFailedException;
import com.twitter.heron.api.topology.OutputFieldsDeclarer;
import com.twitter.heron.api.topology.TopologyContext;
import com.twitter.heron.api.tuple.Tuple;
import java.util.Map;

public class BasicBoltExecutor
implements IRichBolt {
    private static final long serialVersionUID = 7021447981762957626L;
    private IBasicBolt bolt;
    private transient BasicOutputCollector collector;

    public BasicBoltExecutor(IBasicBolt iBasicBolt) {
        this.bolt = iBasicBolt;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        this.bolt.declareOutputFields(outputFieldsDeclarer);
    }

    @Override
    public void prepare(Map<String, Object> map, TopologyContext topologyContext, OutputCollector outputCollector) {
        this.bolt.prepare(map, topologyContext);
        this.collector = new BasicOutputCollector(outputCollector);
    }

    @Override
    public void execute(Tuple tuple) {
        this.collector.setContext(tuple);
        try {
            this.bolt.execute(tuple, this.collector);
            this.collector.getOutputter().ack(tuple);
        }
        catch (FailedException failedException) {
            if (failedException instanceof ReportedFailedException) {
                this.collector.reportError(failedException);
            }
            this.collector.getOutputter().fail(tuple);
        }
    }

    @Override
    public void cleanup() {
        this.bolt.cleanup();
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.bolt.getComponentConfiguration();
    }
}

