/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.metric;

import com.twitter.heron.api.metric.AssignableMetric;
import com.twitter.heron.api.metric.IMetric;
import java.util.HashMap;
import java.util.Map;

public class MultiAssignableMetric<T extends Number>
implements IMetric<Map<String, T>> {
    private final Map<String, AssignableMetric<T>> value = new HashMap<String, AssignableMetric<T>>();
    private T initialValue;

    public MultiAssignableMetric(T t) {
        this.initialValue = t;
    }

    public AssignableMetric<T> scope(String string) {
        AssignableMetric<T> assignableMetric = this.value.get(string);
        if (assignableMetric == null) {
            assignableMetric = new AssignableMetric<T>(this.initialValue);
            this.value.put(string, assignableMetric);
        }
        return assignableMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssignableMetric<T> safeScope(String string) {
        AssignableMetric<T> assignableMetric;
        Map<String, AssignableMetric<T>> map = this.value;
        synchronized (map) {
            assignableMetric = this.value.get(string);
            if (assignableMetric == null) {
                assignableMetric = new AssignableMetric<T>(this.initialValue);
                this.value.put(string, assignableMetric);
            }
        }
        return assignableMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, T> getValueAndReset() {
        HashMap<String, T> hashMap = new HashMap<String, T>();
        Map<String, AssignableMetric<T>> map = this.value;
        synchronized (map) {
            for (Map.Entry<String, AssignableMetric<T>> entry : this.value.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().getValueAndReset());
            }
        }
        return hashMap;
    }
}

