/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.metric;

import com.twitter.heron.api.metric.IMetric;
import com.twitter.heron.api.metric.IReducer;

public class ReducedMetric<T, U, V>
implements IMetric<V> {
    private final IReducer<T, U, V> reducer;
    private T accumulator;

    public ReducedMetric(IReducer<T, U, V> iReducer) {
        this.reducer = iReducer;
        this.accumulator = this.reducer.init();
    }

    public void update(U u) {
        this.accumulator = this.reducer.reduce(this.accumulator, u);
    }

    @Override
    public V getValueAndReset() {
        V v = this.reducer.extractResult(this.accumulator);
        this.accumulator = this.reducer.init();
        return v;
    }
}

