/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.topology;

import com.google.protobuf.ByteString;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.topology.BaseConfigurationDeclarer;
import com.twitter.heron.api.topology.ComponentConfigurationDeclarer;
import com.twitter.heron.api.topology.IComponent;
import com.twitter.heron.api.utils.Utils;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseComponentDeclarer<T extends ComponentConfigurationDeclarer<?>>
extends BaseConfigurationDeclarer<T> {
    private String name;
    private IComponent component;
    private Map<String, Object> componentConfiguration;

    public BaseComponentDeclarer(String string, IComponent iComponent, Number number) {
        this.name = string;
        this.component = iComponent;
        this.componentConfiguration = iComponent.getComponentConfiguration();
        if (this.componentConfiguration == null) {
            this.componentConfiguration = new HashMap<String, Object>();
        }
        if (number != null) {
            this.componentConfiguration.put("topology.component.parallelism", number.toString());
        } else {
            this.componentConfiguration.put("topology.component.parallelism", "1");
        }
    }

    public abstract T returnThis();

    protected String getName() {
        return this.name;
    }

    @Override
    public T addConfigurations(Map<String, Object> map) {
        this.componentConfiguration.putAll(map);
        return this.returnThis();
    }

    public void dump(TopologyAPI.Component.Builder builder) {
        builder.setName(this.name);
        builder.setJavaObject(ByteString.copyFrom(Utils.serialize(this.component)));
        TopologyAPI.Config.Builder builder2 = TopologyAPI.Config.newBuilder();
        for (Map.Entry<String, Object> entry : this.componentConfiguration.entrySet()) {
            TopologyAPI.Config.KeyValue.Builder builder3 = TopologyAPI.Config.KeyValue.newBuilder();
            builder3.setKey(entry.getKey());
            builder3.setValue(entry.getValue().toString());
            builder2.addKvs(builder3);
        }
        builder.setConfig(builder2);
    }
}

