/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.topology;

import com.google.protobuf.ByteString;
import com.twitter.heron.api.bolt.IRichBolt;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.grouping.CustomStreamGrouping;
import com.twitter.heron.api.topology.BaseComponentDeclarer;
import com.twitter.heron.api.topology.OutputFieldsGetter;
import com.twitter.heron.api.tuple.Fields;
import com.twitter.heron.api.utils.Utils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BoltDeclarer
extends BaseComponentDeclarer<BoltDeclarer> {
    private OutputFieldsGetter output;
    private List<TopologyAPI.InputStream.Builder> inputs = new LinkedList<TopologyAPI.InputStream.Builder>();

    public BoltDeclarer(String string, IRichBolt iRichBolt, Number number) {
        super(string, iRichBolt, number);
        this.output = new OutputFieldsGetter();
        iRichBolt.declareOutputFields(this.output);
    }

    @Override
    public BoltDeclarer returnThis() {
        return this;
    }

    public void dump(TopologyAPI.Topology.Builder builder) {
        TopologyAPI.Bolt.Builder builder2 = TopologyAPI.Bolt.newBuilder();
        TopologyAPI.Component.Builder builder3 = TopologyAPI.Component.newBuilder();
        super.dump(builder3);
        builder2.setComp(builder3);
        for (TopologyAPI.InputStream.Builder object : this.inputs) {
            builder2.addInputs(object);
        }
        Map<String, TopologyAPI.StreamSchema.Builder> map = this.output.getFieldsDeclaration();
        for (Map.Entry entry : map.entrySet()) {
            TopologyAPI.OutputStream.Builder builder4 = TopologyAPI.OutputStream.newBuilder();
            TopologyAPI.StreamId.Builder builder5 = TopologyAPI.StreamId.newBuilder();
            builder5.setId((String)entry.getKey());
            builder5.setComponentName(this.getName());
            builder4.setStream(builder5);
            builder4.setSchema((TopologyAPI.StreamSchema.Builder)entry.getValue());
            builder2.addOutputs(builder4);
        }
        builder.addBolts(builder2);
    }

    public BoltDeclarer fieldsGrouping(String string, Fields fields) {
        return this.fieldsGrouping(string, "default", fields);
    }

    public BoltDeclarer fieldsGrouping(String string, String string2, Fields fields) {
        TopologyAPI.InputStream.Builder builder = TopologyAPI.InputStream.newBuilder();
        builder.setStream(TopologyAPI.StreamId.newBuilder().setId(string2).setComponentName(string));
        builder.setGtype(TopologyAPI.Grouping.FIELDS);
        TopologyAPI.StreamSchema.Builder builder2 = TopologyAPI.StreamSchema.newBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            TopologyAPI.StreamSchema.KeyType.Builder builder3 = TopologyAPI.StreamSchema.KeyType.newBuilder();
            builder3.setKey(fields.get(i));
            builder3.setType(TopologyAPI.Type.OBJECT);
            builder2.addKeys(builder3);
        }
        builder.setGroupingFields(builder2);
        return this.grouping(builder);
    }

    public BoltDeclarer globalGrouping(String string) {
        return this.globalGrouping(string, "default");
    }

    public BoltDeclarer globalGrouping(String string, String string2) {
        TopologyAPI.InputStream.Builder builder = TopologyAPI.InputStream.newBuilder();
        builder.setStream(TopologyAPI.StreamId.newBuilder().setId(string2).setComponentName(string));
        builder.setGtype(TopologyAPI.Grouping.LOWEST);
        return this.grouping(builder);
    }

    public BoltDeclarer shuffleGrouping(String string) {
        return this.shuffleGrouping(string, "default");
    }

    public BoltDeclarer shuffleGrouping(String string, String string2) {
        TopologyAPI.InputStream.Builder builder = TopologyAPI.InputStream.newBuilder();
        builder.setStream(TopologyAPI.StreamId.newBuilder().setId(string2).setComponentName(string));
        builder.setGtype(TopologyAPI.Grouping.SHUFFLE);
        return this.grouping(builder);
    }

    public BoltDeclarer localOrShuffleGrouping(String string) {
        return this.localOrShuffleGrouping(string, "default");
    }

    public BoltDeclarer localOrShuffleGrouping(String string, String string2) {
        return this.shuffleGrouping(string, string2);
    }

    public BoltDeclarer noneGrouping(String string) {
        return this.noneGrouping(string, "default");
    }

    public BoltDeclarer noneGrouping(String string, String string2) {
        TopologyAPI.InputStream.Builder builder = TopologyAPI.InputStream.newBuilder();
        builder.setStream(TopologyAPI.StreamId.newBuilder().setId(string2).setComponentName(string));
        builder.setGtype(TopologyAPI.Grouping.NONE);
        return this.grouping(builder);
    }

    public BoltDeclarer allGrouping(String string) {
        return this.allGrouping(string, "default");
    }

    public BoltDeclarer allGrouping(String string, String string2) {
        TopologyAPI.InputStream.Builder builder = TopologyAPI.InputStream.newBuilder();
        builder.setStream(TopologyAPI.StreamId.newBuilder().setId(string2).setComponentName(string));
        builder.setGtype(TopologyAPI.Grouping.ALL);
        return this.grouping(builder);
    }

    public BoltDeclarer directGrouping(String string) {
        return this.directGrouping(string, "default");
    }

    public BoltDeclarer directGrouping(String string, String string2) {
        throw new RuntimeException("direct Grouping not implemented");
    }

    public BoltDeclarer customGrouping(String string, CustomStreamGrouping customStreamGrouping) {
        return this.customGrouping(string, "default", customStreamGrouping);
    }

    public BoltDeclarer customGrouping(String string, String string2, CustomStreamGrouping customStreamGrouping) {
        TopologyAPI.InputStream.Builder builder = TopologyAPI.InputStream.newBuilder();
        builder.setStream(TopologyAPI.StreamId.newBuilder().setId(string2).setComponentName(string));
        builder.setGtype(TopologyAPI.Grouping.CUSTOM);
        builder.setCustomGroupingJavaObject(ByteString.copyFrom(Utils.serialize(customStreamGrouping)));
        return this.grouping(builder);
    }

    private BoltDeclarer grouping(TopologyAPI.InputStream.Builder builder) {
        this.inputs.add(builder);
        return this;
    }
}

