/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.topology;

import com.twitter.heron.api.HeronTopology;
import com.twitter.heron.api.bolt.BasicBoltExecutor;
import com.twitter.heron.api.bolt.IBasicBolt;
import com.twitter.heron.api.bolt.IRichBolt;
import com.twitter.heron.api.generated.TopologyAPI;
import com.twitter.heron.api.spout.IRichSpout;
import com.twitter.heron.api.topology.BaseComponentDeclarer;
import com.twitter.heron.api.topology.BoltDeclarer;
import com.twitter.heron.api.topology.SpoutDeclarer;
import java.util.HashMap;
import java.util.Map;

public class TopologyBuilder {
    private Map<String, BoltDeclarer> bolts = new HashMap<String, BoltDeclarer>();
    private Map<String, SpoutDeclarer> spouts = new HashMap<String, SpoutDeclarer>();

    public HeronTopology createTopology() {
        TopologyAPI.Topology.Builder builder = TopologyAPI.Topology.newBuilder();
        for (Map.Entry<String, SpoutDeclarer> entry : this.spouts.entrySet()) {
            entry.getValue().dump(builder);
        }
        for (Map.Entry<String, BaseComponentDeclarer> entry : this.bolts.entrySet()) {
            ((BoltDeclarer)entry.getValue()).dump(builder);
        }
        return new HeronTopology(builder);
    }

    public BoltDeclarer setBolt(String string, IRichBolt iRichBolt) {
        return this.setBolt(string, iRichBolt, null);
    }

    public BoltDeclarer setBolt(String string, IRichBolt iRichBolt, Number number) {
        this.validateComponentName(string);
        BoltDeclarer boltDeclarer = new BoltDeclarer(string, iRichBolt, number);
        this.bolts.put(string, boltDeclarer);
        return boltDeclarer;
    }

    public BoltDeclarer setBolt(String string, IBasicBolt iBasicBolt) {
        return this.setBolt(string, iBasicBolt, null);
    }

    public BoltDeclarer setBolt(String string, IBasicBolt iBasicBolt, Number number) {
        return this.setBolt(string, new BasicBoltExecutor(iBasicBolt), number);
    }

    public SpoutDeclarer setSpout(String string, IRichSpout iRichSpout) {
        return this.setSpout(string, iRichSpout, null);
    }

    public SpoutDeclarer setSpout(String string, IRichSpout iRichSpout, Number number) {
        this.validateComponentName(string);
        SpoutDeclarer spoutDeclarer = new SpoutDeclarer(string, iRichSpout, number);
        this.spouts.put(string, spoutDeclarer);
        return spoutDeclarer;
    }

    private void validateComponentName(String string) {
        if (string.contains(",")) {
            throw new IllegalArgumentException("Component name should not contain comma(,)");
        }
        if (string.contains(":")) {
            throw new IllegalArgumentException("Component name should not contain colon(:)");
        }
        this.validateUnusedName(string);
    }

    private void validateUnusedName(String string) {
        if (this.bolts.containsKey(string)) {
            throw new IllegalArgumentException("Bolt has already been declared for name " + string);
        }
        if (this.spouts.containsKey(string)) {
            throw new IllegalArgumentException("Spout has already been declared for name " + string);
        }
    }
}

