/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.tuple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Fields
implements Iterable<String>,
Serializable {
    private static final long serialVersionUID = -1045737418722082345L;
    private List<String> fields;
    private Map<String, Integer> mIndex = new HashMap<String, Integer>();

    public Fields(String ... stringArray) {
        this(Arrays.asList(stringArray));
    }

    public Fields(List<String> list) {
        this.fields = new ArrayList<String>(list.size());
        for (String string : list) {
            if (this.fields.contains(string)) {
                throw new IllegalArgumentException(String.format("duplicate field '%s'", string));
            }
            this.fields.add(string);
        }
        this.index();
    }

    public List<Object> select(Fields fields, List<Object> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(fields.size());
        for (String string : fields) {
            arrayList.add(list.get(this.mIndex.get(string)));
        }
        return arrayList;
    }

    public List<String> toList() {
        return new ArrayList<String>(this.fields);
    }

    public int size() {
        return this.fields.size();
    }

    public String get(int n) {
        return this.fields.get(n);
    }

    @Override
    public Iterator<String> iterator() {
        return this.fields.iterator();
    }

    public int fieldIndex(String string) {
        Integer n = this.mIndex.get(string);
        if (n == null) {
            throw new IllegalArgumentException(string + " does not exist");
        }
        return n;
    }

    public boolean contains(String string) {
        return this.mIndex.containsKey(string);
    }

    private void index() {
        for (int i = 0; i < this.fields.size(); ++i) {
            this.mIndex.put(this.fields.get(i), i);
        }
    }

    public String toString() {
        return this.fields.toString();
    }
}

