/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.utils;

public class DefaultMaxSpoutPendingTuner {
    static final long CONSERVATIVE_MAX_SPOUT_PENDING = 10L;
    static final int NOOP_THRESHOLD = 5;
    private Long adjustedMaxSpoutPending;
    private Long initialMaxSpoutPending;
    private Long prevProgress;
    private Long restoreAdjustedMaxSpoutPending;
    private Long restoreProgress;
    private int callsInNoop;
    private ACTION lastAction;
    private float autoTuneFactor;
    private double progressBound;
    private ACTION speculativeAction;

    public DefaultMaxSpoutPendingTuner(float f, double d) {
        this(null, f, d);
    }

    public DefaultMaxSpoutPendingTuner(Long l, float f, double d) {
        this.adjustedMaxSpoutPending = l == null ? Long.valueOf(10L) : l;
        this.initialMaxSpoutPending = this.adjustedMaxSpoutPending;
        this.prevProgress = new Long(-1L);
        this.restoreAdjustedMaxSpoutPending = this.adjustedMaxSpoutPending;
        this.restoreProgress = new Long(-1L);
        this.lastAction = ACTION.NOOP;
        this.callsInNoop = 0;
        this.autoTuneFactor = f;
        this.progressBound = d;
        this.speculativeAction = ACTION.INCREASE;
    }

    public static boolean similarToNum(Long l, Long l2, double d) {
        return (double)Math.abs(l - l2) / (double)l2.longValue() < d;
    }

    public static boolean moreThanNum(Long l, Long l2, double d) {
        if (!DefaultMaxSpoutPendingTuner.similarToNum(l, l2, d)) {
            return l > l2;
        }
        return false;
    }

    public static boolean lessThanNum(Long l, Long l2, double d) {
        if (!DefaultMaxSpoutPendingTuner.similarToNum(l, l2, d)) {
            return l < l2;
        }
        return false;
    }

    public Long get() {
        return this.adjustedMaxSpoutPending;
    }

    public void autoTune(Long l) {
        if (this.lastAction == ACTION.NOOP) {
            if (this.prevProgress == -1L) {
                this.doAction(ACTION.INCREASE, this.autoTuneFactor, l);
            } else if (DefaultMaxSpoutPendingTuner.moreThanNum(l, this.prevProgress, this.progressBound)) {
                this.doAction(ACTION.INCREASE, this.autoTuneFactor, l);
            } else if (DefaultMaxSpoutPendingTuner.lessThanNum(l, this.prevProgress, this.progressBound)) {
                this.doAction(ACTION.DECREASE, Math.max((float)(this.prevProgress - l) / (float)this.prevProgress.longValue(), this.autoTuneFactor), l);
            } else {
                ++this.callsInNoop;
                if (this.callsInNoop >= 5) {
                    this.doAction(this.speculativeAction, this.autoTuneFactor, l);
                    this.speculativeAction = this.speculativeAction == ACTION.INCREASE ? ACTION.DECREASE : ACTION.INCREASE;
                }
            }
        } else if (this.lastAction == ACTION.INCREASE) {
            if (DefaultMaxSpoutPendingTuner.moreThanNum(l, this.prevProgress, (double)this.autoTuneFactor - this.progressBound)) {
                this.doAction(ACTION.INCREASE, this.autoTuneFactor, l);
            } else if (DefaultMaxSpoutPendingTuner.lessThanNum(l, this.prevProgress, this.progressBound)) {
                float f = Math.max((float)(this.prevProgress - l) / (float)this.prevProgress.longValue(), this.autoTuneFactor);
                if (f > this.autoTuneFactor) {
                    this.doAction(ACTION.DECREASE, f, l);
                } else {
                    this.doAction(ACTION.RESTORE, this.autoTuneFactor, l);
                }
            } else {
                this.doAction(ACTION.RESTORE, this.autoTuneFactor, l);
            }
        } else if (this.lastAction == ACTION.DECREASE) {
            if (DefaultMaxSpoutPendingTuner.moreThanNum(l, this.prevProgress, this.progressBound)) {
                this.doAction(ACTION.DECREASE, this.autoTuneFactor, l);
            } else {
                this.doAction(ACTION.NOOP, this.autoTuneFactor, l);
            }
        } else if (this.lastAction == ACTION.RESTORE) {
            this.doAction(ACTION.NOOP, this.autoTuneFactor, l);
        }
    }

    void doAction(ACTION aCTION, float f, Long l) {
        if (aCTION == ACTION.INCREASE) {
            this.restoreAdjustedMaxSpoutPending = this.adjustedMaxSpoutPending;
            this.restoreProgress = this.prevProgress;
            this.adjustedMaxSpoutPending = this.adjustedMaxSpoutPending + (long)Math.max(1, Math.round(Float.valueOf(f * (float)this.adjustedMaxSpoutPending.longValue()).floatValue()));
            this.callsInNoop = 0;
            this.prevProgress = l;
        } else if (aCTION == ACTION.DECREASE) {
            this.restoreAdjustedMaxSpoutPending = this.adjustedMaxSpoutPending;
            this.restoreProgress = this.prevProgress;
            this.adjustedMaxSpoutPending = this.adjustedMaxSpoutPending - (long)Math.max(1, Math.round(Float.valueOf(f * (float)this.adjustedMaxSpoutPending.longValue()).floatValue()));
            this.adjustedMaxSpoutPending = Math.max(Math.min(10L, this.initialMaxSpoutPending), this.adjustedMaxSpoutPending);
            this.callsInNoop = 0;
            this.prevProgress = l;
        } else if (aCTION == ACTION.RESTORE) {
            this.adjustedMaxSpoutPending = this.restoreAdjustedMaxSpoutPending;
            this.prevProgress = this.restoreProgress;
            this.callsInNoop = 0;
        } else if (aCTION == ACTION.NOOP) {
            this.prevProgress = l;
        }
        this.lastAction = aCTION;
    }

    static enum ACTION {
        NOOP,
        INCREASE,
        DECREASE,
        RESTORE;

    }
}

