/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.api.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Utils {
    public static final String DEFAULT_STREAM_ID = "default";

    private Utils() {
    }

    public static List<Object> tuple(Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Collections.addAll(arrayList, Arrays.asList(objectArray));
        return arrayList;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public static Map<String, String> readCommandLineOpts() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = System.getProperty("heron.options");
        if (string != null) {
            String[] stringArray;
            string = string.replaceAll("%%%%", " ");
            for (String string2 : stringArray = string.split(",")) {
                String[] stringArray2 = string2.split("=");
                if (stringArray2.length != 2) continue;
                hashMap.put(stringArray2[0], stringArray2[1]);
            }
        }
        return hashMap;
    }

    public static byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Object deserialize(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public static byte[] toByteArray(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray, 0, byArray.length);
        return byArray;
    }

    public static <S, T> T get(Map<S, T> map, S s, T t) {
        T t2 = map.get(s);
        if (t2 == null) {
            t2 = t;
        }
        return t2;
    }
}

