/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.basics;

import com.twitter.heron.common.basics.WakeableLooper;
import java.util.Collection;
import java.util.concurrent.LinkedTransferQueue;

public class Communicator<E> {
    private final LinkedTransferQueue<E> buffer;
    private volatile WakeableLooper producer;
    private volatile WakeableLooper consumer;
    private volatile int capacity;
    private volatile int expectedAvailableCapacity;
    private volatile int expectedQueueSize;
    private volatile int averageSize;
    private volatile double currentSampleWeight;
    private volatile boolean isExpectNoMoreItems;

    public Communicator(WakeableLooper wakeableLooper, WakeableLooper wakeableLooper2) {
        this.producer = wakeableLooper;
        this.consumer = wakeableLooper2;
        this.buffer = new LinkedTransferQueue();
    }

    public Communicator() {
        this.isExpectNoMoreItems = false;
        this.producer = null;
        this.consumer = null;
        this.buffer = new LinkedTransferQueue();
    }

    public void setProducer(WakeableLooper wakeableLooper) {
        this.producer = wakeableLooper;
    }

    public void setConsumer(WakeableLooper wakeableLooper) {
        this.consumer = wakeableLooper;
    }

    public void init(int n, int n2, double d) {
        this.capacity = n;
        this.expectedQueueSize = n2;
        this.currentSampleWeight = d;
        this.expectedAvailableCapacity = this.capacity / 2;
    }

    public int size() {
        return this.buffer.size();
    }

    public int remainingCapacity() {
        return this.capacity - this.size();
    }

    public E poll() {
        E e = this.buffer.poll();
        if (this.producer != null) {
            this.producer.wakeUp();
        }
        return e;
    }

    public boolean offer(E e) {
        this.buffer.offer(e);
        if (this.consumer != null) {
            this.consumer.wakeUp();
        }
        return true;
    }

    public E peek() {
        return this.buffer.peek();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public void clear() {
        this.buffer.clear();
    }

    public int drainTo(Collection<? super E> collection) {
        int n = this.buffer.drainTo(collection);
        if (this.producer != null) {
            this.producer.wakeUp();
        }
        return n;
    }

    public int drainTo(Collection<? super E> collection, int n) {
        int n2 = this.buffer.drainTo(collection, n);
        if (this.producer != null) {
            this.producer.wakeUp();
        }
        return n2;
    }

    public void updateExpectedAvailableCapacity() {
        int n = (int)((1.0 - this.currentSampleWeight) * (double)this.averageSize + this.currentSampleWeight * (double)this.size());
        int n2 = this.expectedAvailableCapacity;
        if (n < this.expectedQueueSize && n2 < this.capacity) {
            this.expectedAvailableCapacity = n2 + 1;
        }
        if (n > this.expectedQueueSize && n2 > 0) {
            this.expectedAvailableCapacity = n2 / 2;
        }
        this.averageSize = n;
    }

    public int getExpectedAvailableCapacity() {
        return this.isExpectNoMoreItems ? -1 : this.expectedAvailableCapacity;
    }

    public void expectNoMoreItems() {
        this.isExpectNoMoreItems = true;
        this.informProducer();
    }

    public void expectMoreItems() {
        this.isExpectNoMoreItems = false;
        this.informProducer();
    }

    public void informProducer() {
        if (this.producer != null) {
            this.producer.wakeUp();
        }
    }

    public void informConsumer() {
        if (this.consumer != null) {
            this.consumer.wakeUp();
        }
    }
}

