/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.basics;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtils {
    private static final Logger LOG = Logger.getLogger(FileUtils.class.getName());

    private FileUtils() {
    }

    public static boolean deleteFile(String string) {
        Path path = new File(string).toPath();
        try {
            Files.delete(path);
        }
        catch (NoSuchFileException noSuchFileException) {
            LOG.severe("file does not exist: " + path);
            return false;
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            LOG.severe("Path is an not empty directory: " + path);
            return false;
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Failed to delete file due to unexpected exception:", iOException);
            return false;
        }
        return true;
    }

    public static boolean copyFile(String string, String string2) {
        Path path = new File(string).toPath();
        Path path2 = new File(string2).toPath();
        try {
            Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Failed to copy file from " + string + " to target: " + string2, iOException);
            return false;
        }
        return true;
    }

    public static boolean writeToFile(String string, byte[] byArray, boolean bl) {
        File file = new File(string);
        if (!bl && file.exists()) {
            LOG.severe("File exists. Topology exists: " + string);
            return false;
        }
        try {
            Files.write(new File(string).toPath(), byArray, new OpenOption[0]);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Failed to write content to file. ", iOException);
            return false;
        }
        return true;
    }

    public static byte[] readFromFile(String string) {
        byte[] byArray;
        Path path = new File(string).toPath();
        try {
            byArray = Files.readAllBytes(path);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Failed to read from file. ", iOException);
            byArray = new byte[]{};
        }
        return byArray;
    }

    public static boolean createDirectory(String string) {
        return new File(string).mkdirs();
    }

    public static boolean isDirectoryExists(String string) {
        return Files.isDirectory(new File(string).toPath(), new LinkOption[0]);
    }

    public static boolean isFileExists(String string) {
        return Files.exists(new File(string).toPath(), new LinkOption[0]);
    }

    public static boolean isOriginalPackageJar(String string) {
        return string.endsWith(".jar");
    }

    public static String getBaseName(String string) {
        return new File(string).getName();
    }

    public static String combinePaths(String string, String string2) {
        return Paths.get(string, string2).toString();
    }
}

