/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.basics;

import com.twitter.heron.common.basics.ISelectHandler;
import com.twitter.heron.common.basics.WakeableLooper;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;

public class NIOLooper
extends WakeableLooper {
    private final Selector selector = Selector.open();

    public NIOLooper() throws IOException {
        this.addNIOLooperTasks();
    }

    private void addNIOLooperTasks() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                NIOLooper.this.handleSelectedKeys();
            }
        };
        this.addTasksOnWakeup(runnable);
    }

    @Override
    public void doWait() {
        long l = this.getNextTimeoutIntervalMs();
        try {
            if (l > 0L) {
                this.selector.select(l);
            } else {
                this.selector.selectNow();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void wakeUp() {
        this.selector.wakeup();
    }

    public void removeAllInterest(SelectableChannel selectableChannel) {
        SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
        if (selectionKey != null) {
            selectionKey.cancel();
        }
    }

    private void handleSelectedKeys() {
        Set<SelectionKey> set = this.selector.selectedKeys();
        Iterator<SelectionKey> iterator = set.iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            iterator.remove();
            ISelectHandler iSelectHandler = (ISelectHandler)selectionKey.attachment();
            if (!selectionKey.isValid()) {
                iSelectHandler.handleError(selectionKey.channel());
                continue;
            }
            if (selectionKey.isValid() && selectionKey.isWritable()) {
                iSelectHandler.handleWrite(selectionKey.channel());
            }
            if (selectionKey.isValid() && selectionKey.isReadable()) {
                iSelectHandler.handleRead(selectionKey.channel());
            }
            if (selectionKey.isValid() && selectionKey.isConnectable()) {
                iSelectHandler.handleConnect(selectionKey.channel());
            }
            if (!selectionKey.isValid() || !selectionKey.isAcceptable()) continue;
            iSelectHandler.handleAccept(selectionKey.channel());
        }
    }

    public boolean isChannelValid(SelectableChannel selectableChannel) {
        SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
        return selectionKey != null && selectionKey.isValid();
    }

    public void registerRead(SelectableChannel selectableChannel, ISelectHandler iSelectHandler) throws ClosedChannelException {
        assert (selectableChannel.keyFor(this.selector) == null || (selectableChannel.keyFor(this.selector).interestOps() & 8) == 0);
        this.addInterest(selectableChannel, 1, iSelectHandler);
    }

    public void unregisterRead(SelectableChannel selectableChannel) {
        this.removeInterest(selectableChannel, 1);
    }

    public boolean isReadRegistered(SelectableChannel selectableChannel) {
        return this.isInterestRegistered(selectableChannel, 1);
    }

    public void registerConnect(SelectableChannel selectableChannel, ISelectHandler iSelectHandler) throws ClosedChannelException {
        assert (selectableChannel.keyFor(this.selector) == null);
        this.addInterest(selectableChannel, 8, iSelectHandler);
    }

    public void unregisterConnect(SelectableChannel selectableChannel) {
        this.removeInterest(selectableChannel, 8);
    }

    public boolean isConnectRegistered(SelectableChannel selectableChannel) {
        return this.isInterestRegistered(selectableChannel, 8);
    }

    public void registerAccept(SelectableChannel selectableChannel, ISelectHandler iSelectHandler) throws ClosedChannelException {
        this.addInterest(selectableChannel, 16, iSelectHandler);
    }

    public void unregisterAccept(SelectableChannel selectableChannel) {
        this.removeInterest(selectableChannel, 16);
    }

    public boolean isAcceptRegistered(SelectableChannel selectableChannel) {
        return this.isInterestRegistered(selectableChannel, 16);
    }

    public void registerWrite(SelectableChannel selectableChannel, ISelectHandler iSelectHandler) throws ClosedChannelException {
        this.addInterest(selectableChannel, 4, iSelectHandler);
    }

    public void unregisterWrite(SelectableChannel selectableChannel) {
        this.removeInterest(selectableChannel, 4);
    }

    public boolean isWriteRegistered(SelectableChannel selectableChannel) {
        return this.isInterestRegistered(selectableChannel, 4);
    }

    private void addInterest(SelectableChannel selectableChannel, int n, ISelectHandler iSelectHandler) throws ClosedChannelException {
        SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
        if (selectionKey == null) {
            selectableChannel.register(this.selector, n, iSelectHandler);
        } else {
            if (!selectionKey.isValid()) {
                throw new RuntimeException(String.format("Unable to add %d in %s due to key is invalid", n, selectableChannel));
            }
            if ((selectionKey.interestOps() & n) != 0) {
                throw new RuntimeException(String.format("%d has been registered in %s", n, selectableChannel));
            }
            if (selectionKey.attachment() == null) {
                selectionKey.attach(iSelectHandler);
            } else if (iSelectHandler != selectionKey.attachment()) {
                throw new RuntimeException("Unmatched SelectHandler has already been attached for other operation");
            }
            selectionKey.interestOps(selectionKey.interestOps() | n);
        }
    }

    private void removeInterest(SelectableChannel selectableChannel, int n) {
        SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
        selectionKey.interestOps(selectionKey.interestOps() & ~n);
    }

    private boolean isInterestRegistered(SelectableChannel selectableChannel, int n) {
        SelectionKey selectionKey = selectableChannel.keyFor(this.selector);
        return selectionKey != null && (selectionKey.interestOps() & n) != 0;
    }
}

