/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.basics;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SysUtils {
    private static final Logger LOG = Logger.getLogger(SysUtils.class.getName());

    private SysUtils() {
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFreePort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n2;
            int n = n2 = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public static void closeIgnoringExceptions(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, String.format("Failed to close %s", autoCloseable), exception);
            }
        }
    }
}

