/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.basics;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Integer getInteger(Object object) {
        if (object instanceof Long) {
            return ((Long)object).intValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Short) {
            return ((Short)object).intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Don't know how to convert " + object + " to int");
        }
    }

    public static Long getLong(Object object) {
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Don't know how to convert " + object + " to long");
        }
    }

    public static Double getDouble(Object object) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Short) {
            return ((Short)object).doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to convert " + object + " to double");
        }
    }

    public static Boolean getBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new IllegalArgumentException("Failed to convert " + object + " to boolean");
    }

    public static URI getURI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Don't know how to convert " + string + " to URI");
        }
    }

    public static List<String> getListOfStrings(Object object) {
        if (object == null) {
            return new ArrayList<String>();
        }
        if (object instanceof List) {
            return (List)object;
        }
        throw new IllegalArgumentException("Failed to convert " + object + " to List<String>");
    }
}

