/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.basics;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

public abstract class WakeableLooper {
    private final List<Runnable> tasksOnWakeup = new ArrayList<Runnable>();
    private final PriorityQueue<TimerTask> timers = new PriorityQueue();
    private final ArrayList<Runnable> exitTasks = new ArrayList();
    private static final long INFINITE_FUTURE = Integer.MAX_VALUE;
    private volatile boolean exitLoop = false;

    public void loop() {
        while (!this.exitLoop) {
            this.runOnce();
        }
        this.onExit();
    }

    private void runOnce() {
        this.doWait();
        this.executeTasksOnWakeup();
        this.triggerExpiredTimers(System.nanoTime());
    }

    private void onExit() {
        for (Runnable runnable : this.exitTasks) {
            runnable.run();
        }
    }

    protected abstract void doWait();

    public abstract void wakeUp();

    public void addTasksOnWakeup(Runnable runnable) {
        this.tasksOnWakeup.add(runnable);
        this.wakeUp();
    }

    public void addTasksOnExit(Runnable runnable) {
        this.exitTasks.add(runnable);
    }

    public void registerTimerEventInSeconds(long l, Runnable runnable) {
        this.registerTimerEventInNanoSeconds(l * 1000000000L, runnable);
    }

    public void registerTimerEventInNanoSeconds(long l, Runnable runnable) {
        assert (l >= 0L);
        assert (runnable != null);
        long l2 = System.nanoTime() + l;
        this.timers.add(new TimerTask(l2, runnable));
    }

    public void exitLoop() {
        this.exitLoop = true;
        this.wakeUp();
    }

    protected long getNextTimeoutIntervalMs() {
        long l = Integer.MAX_VALUE;
        if (!this.timers.isEmpty()) {
            l = (this.timers.peek().getExpirationNs() - System.nanoTime() + 1000000L) / 1000000L;
        }
        return l;
    }

    private void executeTasksOnWakeup() {
        int n = this.tasksOnWakeup.size();
        for (int i = 0; i < n; ++i) {
            this.tasksOnWakeup.get(i).run();
        }
    }

    private void triggerExpiredTimers(long l) {
        while (!this.timers.isEmpty()) {
            long l2 = this.timers.peek().getExpirationNs();
            if (l2 - l <= 0L) {
                this.timers.poll().handler.run();
                continue;
            }
            return;
        }
    }

    private static class TimerTask
    implements Comparable<TimerTask> {
        public final long expirationNs;
        public final Runnable handler;

        TimerTask(long l, Runnable runnable) {
            this.expirationNs = l;
            this.handler = runnable;
        }

        @Override
        public int compareTo(TimerTask timerTask) {
            if (this.expirationNs - timerTask.expirationNs < 0L) {
                return -1;
            }
            if (this.expirationNs - timerTask.expirationNs > 0L) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            throw new RuntimeException("TODO: implement");
        }

        public int hashCode() {
            throw new RuntimeException("TODO: implement");
        }

        public long getExpirationNs() {
            return this.expirationNs;
        }
    }
}

