/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public class ConfigReader {
    private static final Logger LOG = Logger.getLogger(ConfigReader.class.getName());

    protected ConfigReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> loadFile(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string == null) {
            LOG.warning("Config file name cannot be null");
            return hashMap;
        }
        if (string.isEmpty()) {
            LOG.warning("Config file name is empty");
            return hashMap;
        }
        Path path = Paths.get(string, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            LOG.fine("Config file " + string + " does not exist");
            return hashMap;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            LOG.warning("Config file " + string + " might be a directory.");
            return hashMap;
        }
        LOG.log(Level.FINE, "Reading config file {0}", string);
        Map<String, Object> map = null;
        try (FileInputStream fileInputStream = new FileInputStream(new File(string));){
            Yaml yaml = new Yaml();
            map = (Map)yaml.load(fileInputStream);
            LOG.log(Level.FINE, "Successfully read config file {0}", string);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Failed to load config file: " + string, iOException);
        }
        return map != null ? map : hashMap;
    }

    public static Map<String, Object> loadStream(InputStream inputStream) {
        LOG.fine("Reading config stream");
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(inputStream);
        LOG.fine("Successfully read config");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object k : map.keySet()) {
            hashMap.put(k.toString(), map.get(k));
        }
        return hashMap;
    }

    public static Integer getInt(Object object) {
        if (object instanceof Long) {
            return ((Long)object).intValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Short) {
            return ((Short)object).intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Don't know how to convert " + object + " + to int");
        }
    }

    public static Long getLong(Object object) {
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Don't know how to convert " + object + " + to long");
        }
    }
}

