/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.config;

import com.twitter.heron.common.basics.TypeUtils;
import com.twitter.heron.common.config.ConfigReader;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SystemConfig {
    public static final String HERON_SYSTEM_CONFIG = SystemConfig.class.getName();
    public static final String HERON_LOGGING_DIRECTORY = "heron.logging.directory";
    public static final String HERON_LOGGING_MAXIMUM_SIZE_MB = "heron.logging.maximum.size.mb";
    public static final String HERON_LOGGING_MAXIMUM_FILES = "heron.logging.maximum.files";
    public static final String HERON_LOGGING_ERR_THRESHOLD = "heron.logging.err.threshold";
    public static final String HERON_METRICS_EXPORT_INTERVAL_SEC = "heron.metrics.export.interval.sec";
    public static final String INSTANCE_INTERNAL_BOLT_READ_QUEUE_CAPACITY = "heron.instance.internal.bolt.read.queue.capacity";
    public static final String INSTANCE_INTERNAL_BOLT_WRITE_QUEUE_CAPACITY = "heron.instance.internal.bolt.write.queue.capacity";
    public static final String INSTANCE_INTERNAL_SPOUT_READ_QUEUE_CAPACITY = "heron.instance.internal.spout.read.queue.capacity";
    public static final String INSTANCE_INTERNAL_SPOUT_WRITE_QUEUE_CAPACITY = "heron.instance.internal.spout.write.queue.capacity";
    public static final String INSTANCE_INTERNAL_METRICS_WRITE_QUEUE_CAPACITY = "heron.instance.internal.metrics.write.queue.capacity";
    public static final String INSTANCE_NETWORK_READ_BATCH_TIME_MS = "heron.instance.network.read.batch.time.ms";
    public static final String INSTANCE_NETWORK_READ_BATCH_SIZE_BYTES = "heron.instance.network.read.batch.size.bytes";
    public static final String INSTANCE_NETWORK_WRITE_BATCH_TIME_MS = "heron.instance.network.write.batch.time.ms";
    public static final String INSTANCE_NETWORK_WRITE_BATCH_SIZE_BYTES = "heron.instance.network.write.batch.size.bytes";
    public static final String INSTANCE_NETWORK_OPTIONS_SOCKET_RECEIVED_BUFFER_SIZE_BYTES = "heron.instance.network.options.socket.received.buffer.size.bytes";
    public static final String INSTANCE_NETWORK_OPTIONS_SOCKET_SEND_BUFFER_SIZE_BYTES = "heron.instance.network.options.socket.send.buffer.size.bytes";
    public static final String INSTANCE_SET_DATA_TUPLE_CAPACITY = "heron.instance.set.data.tuple.capacity";
    public static final String INSTANCE_SET_CONTROL_TUPLE_CAPACITY = "heron.instance.set.control.tuple.capacity";
    public static final String INSTANCE_ACK_BATCH_TIME_MS = "heron.instance.ack.batch.time.ms";
    public static final String INSTANCE_EMIT_BATCH_TIME_MS = "heron.instance.emit.batch.time.ms";
    public static final String INSTANCE_EMIT_BATCH_SIZE_BYTES = "heron.instance.emit.batch.size.bytes";
    public static final String INSTANCE_EXECUTE_BATCH_TIME_MS = "heron.instance.execute.batch.time.ms";
    public static final String INSTANCE_EXECUTE_BATCH_SIZE_BYTES = "heron.instance.execute.batch.size.bytes";
    public static final String INSTANCE_STATE_CHECK_INTERVAL_SEC = "heron.instance.state.check.interval.sec";
    public static final String INSTANCE_FORCE_EXIT_TIMEOUT_MS = "heron.instance.force.exit.timeout.ms";
    public static final String INSTANCE_RECONNECT_STREAMMGR_INTERVAL_SEC = "heron.instance.reconnect.streammgr.interval.sec";
    public static final String INSTANCE_RECONNECT_METRICSMGR_INTERVAL_SEC = "heron.instance.reconnect.metricsmgr.interval.sec";
    public static final String INSTANCE_METRICS_SYSTEM_SAMPLE_INTERVAL_SEC = "heron.instance.metrics.system.sample.interval.sec";
    public static final String INSTANCE_ACKNOWLEDGEMENT_NBUCKETS = "heron.instance.acknowledgement.nbuckets";
    public static final String INSTANCE_SLAVE_FETCH_PPLAN_INTERVAL_SEC = "heron.instance.slave.fetch.pplan.interval.sec";
    public static final String INSTANCE_TUNING_EXPECTED_BOLT_READ_QUEUE_SIZE = "heron.instance.tuning.expected.bolt.read.queue.size";
    public static final String INSTANCE_TUNING_EXPECTED_BOLT_WRITE_QUEUE_SIZE = "heron.instance.tuning.expected.bolt.write.queue.size";
    public static final String INSTANCE_TUNING_EXPECTED_SPOUT_READ_QUEUE_SIZE = "heron.instance.tuning.expected.spout.read.queue.size";
    public static final String INSTANCE_TUNING_EXPECTED_SPOUT_WRITE_QUEUE_SIZE = "heron.instance.tuning.expected.spout.write.queue.size";
    public static final String INSTANCE_TUNING_EXPECTED_METRICS_WRITE_QUEUE_SIZE = "heron.instance.tuning.expected.metrics.write.queue.size";
    public static final String INSTANCE_TUNING_CURRENT_SAMPLE_WEIGHT = "heron.instance.tuning.current.sample.weight";
    public static final String INSTANCE_TUNING_INTERVAL_MS = "heron.instance.tuning.interval.ms";
    public static final String METRICSMGR_NETWORK_READ_BATCH_TIME_MS = "heron.metricsmgr.network.read.batch.time.ms";
    public static final String METRICSMGR_NETWORK_READ_BATCH_SIZE_BYTES = "heron.metricsmgr.network.read.batch.size.bytes";
    public static final String METRICSMGR_NETWORK_WRITE_BATCH_TIME_MS = "heron.metricsmgr.network.write.batch.time.ms";
    public static final String METRICSMGR_NETWORK_WRITE_BATCH_SIZE_BYTES = "heron.metricsmgr.network.write.batch.size.bytes";
    public static final String METRICSMGR_NETWORK_OPTIONS_SOCKET_RECEIVED_BUFFER_SIZE_BYTES = "heron.metricsmgr.network.options.socket.received.buffer.size.bytes";
    public static final String METRICSMGR_NETWORK_OPTIONS_SOCKET_SEND_BUFFER_SIZE_BYTES = "heron.metricsmgr.network.options.socket.send.buffer.size.bytes";
    private Map<String, Object> config = new HashMap<String, Object>();

    public SystemConfig() {
    }

    public SystemConfig(String string) {
        this(string, true);
    }

    public SystemConfig(String string, boolean bl) {
        this.config = SystemConfig.findAndReadLocalFile(string, bl);
    }

    public static Map<String, Object> findAndReadLocalFile(String string, boolean bl) {
        File file = new File(string);
        if (!file.exists() && bl) {
            throw new RuntimeException(String.format("Config file %s does not exist", string));
        }
        return ConfigReader.loadFile(string);
    }

    public int getInstanceInternalMetricsWriteQueueCapacity() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_INTERNAL_METRICS_WRITE_QUEUE_CAPACITY));
    }

    public int getInstanceTuningExpectedMetricsWriteQueueSize() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_TUNING_EXPECTED_METRICS_WRITE_QUEUE_SIZE));
    }

    public int getInstanceSetDataTupleCapacity() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_SET_DATA_TUPLE_CAPACITY));
    }

    public int getInstanceSetControlTupleCapacity() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_SET_CONTROL_TUPLE_CAPACITY));
    }

    public long getInstanceForceExitTimeoutMs() {
        return TypeUtils.getLong(this.config.get(INSTANCE_FORCE_EXIT_TIMEOUT_MS));
    }

    public int getInstanceStateCheckIntervalSec() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_STATE_CHECK_INTERVAL_SEC));
    }

    public int getInstanceInternalBoltReadQueueCapacity() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_INTERNAL_BOLT_READ_QUEUE_CAPACITY));
    }

    public int getInstanceInternalBoltWriteQueueCapacity() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_INTERNAL_BOLT_WRITE_QUEUE_CAPACITY));
    }

    public int getInstanceInternalSpoutReadQueueCapacity() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_INTERNAL_SPOUT_READ_QUEUE_CAPACITY));
    }

    public int getInstanceInternalSpoutWriteQueueCapacity() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_INTERNAL_SPOUT_WRITE_QUEUE_CAPACITY));
    }

    public long getInstanceAckBatchTimeMs() {
        return TypeUtils.getLong(this.config.get(INSTANCE_ACK_BATCH_TIME_MS));
    }

    public int getInstanceTuningExpectedBoltReadQueueSize() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_TUNING_EXPECTED_BOLT_READ_QUEUE_SIZE));
    }

    public int getInstanceTuningExpectedBoltWriteQueueSize() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_TUNING_EXPECTED_BOLT_WRITE_QUEUE_SIZE));
    }

    public int getInstanceTuningExpectedSpoutReadQueueSize() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_TUNING_EXPECTED_SPOUT_READ_QUEUE_SIZE));
    }

    public int getInstanceTuningExpectedSpoutWriteQueueSize() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_TUNING_EXPECTED_SPOUT_WRITE_QUEUE_SIZE));
    }

    public String getHeronLoggingDirectory() {
        return (String)this.config.get(HERON_LOGGING_DIRECTORY);
    }

    public int getHeronLoggingMaximumSizeMb() {
        return TypeUtils.getInteger(this.config.get(HERON_LOGGING_MAXIMUM_SIZE_MB));
    }

    public int getHeronLoggingMaximumFiles() {
        return TypeUtils.getInteger(this.config.get(HERON_LOGGING_MAXIMUM_FILES));
    }

    public int getHeronMetricsExportIntervalSec() {
        return TypeUtils.getInteger(this.config.get(HERON_METRICS_EXPORT_INTERVAL_SEC));
    }

    public long getInstanceNetworkReadBatchTimeMs() {
        return TypeUtils.getLong(this.config.get(INSTANCE_NETWORK_READ_BATCH_TIME_MS));
    }

    public long getInstanceNetworkReadBatchSizeBytes() {
        return TypeUtils.getLong(this.config.get(INSTANCE_NETWORK_READ_BATCH_SIZE_BYTES));
    }

    public long getInstanceNetworkWriteBatchTimeMs() {
        return TypeUtils.getLong(this.config.get(INSTANCE_NETWORK_WRITE_BATCH_TIME_MS));
    }

    public long getInstanceNetworkWriteBatchSizeBytes() {
        return TypeUtils.getLong(this.config.get(INSTANCE_NETWORK_WRITE_BATCH_SIZE_BYTES));
    }

    public int getInstanceNetworkOptionsSocketReceivedBufferSizeBytes() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_NETWORK_OPTIONS_SOCKET_RECEIVED_BUFFER_SIZE_BYTES));
    }

    public int getInstanceNetworkOptionsSocketSendBufferSizeBytes() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_NETWORK_OPTIONS_SOCKET_SEND_BUFFER_SIZE_BYTES));
    }

    public long getInstanceEmitBatchTimeMs() {
        return TypeUtils.getLong(this.config.get(INSTANCE_EMIT_BATCH_TIME_MS));
    }

    public long getInstanceEmitBatchSizeBytes() {
        return TypeUtils.getLong(this.config.get(INSTANCE_EMIT_BATCH_SIZE_BYTES));
    }

    public long getInstanceExecuteBatchTimeMs() {
        return TypeUtils.getLong(this.config.get(INSTANCE_EXECUTE_BATCH_TIME_MS));
    }

    public long getInstanceExecuteBatchSizeBytes() {
        return TypeUtils.getLong(this.config.get(INSTANCE_EXECUTE_BATCH_SIZE_BYTES));
    }

    public int getInstanceReconnectStreammgrIntervalSec() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_RECONNECT_STREAMMGR_INTERVAL_SEC));
    }

    public int getInstanceReconnectMetricsmgrIntervalSec() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_RECONNECT_METRICSMGR_INTERVAL_SEC));
    }

    public int getInstanceMetricsSystemSampleIntervalSec() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_METRICS_SYSTEM_SAMPLE_INTERVAL_SEC));
    }

    public int getInstanceAcknowledgementNbuckets() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_ACKNOWLEDGEMENT_NBUCKETS));
    }

    public int getInstanceSlaveFetchPplanIntervalSec() {
        return TypeUtils.getInteger(this.config.get(INSTANCE_SLAVE_FETCH_PPLAN_INTERVAL_SEC));
    }

    public long getInstanceTuningIntervalMs() {
        return TypeUtils.getLong(this.config.get(INSTANCE_TUNING_INTERVAL_MS));
    }

    public double getInstanceTuningCurrentSampleWeight() {
        return Double.parseDouble(this.config.get(INSTANCE_TUNING_CURRENT_SAMPLE_WEIGHT).toString());
    }

    public long getMetricsMgrNetworkReadBatchTimeMs() {
        return TypeUtils.getLong(this.config.get(METRICSMGR_NETWORK_READ_BATCH_TIME_MS));
    }

    public long getMetricsMgrNetworkReadBatchSizeBytes() {
        return TypeUtils.getLong(this.config.get(METRICSMGR_NETWORK_READ_BATCH_SIZE_BYTES));
    }

    public long getMetricsMgrNetworkWriteBatchTimeMs() {
        return TypeUtils.getLong(this.config.get(METRICSMGR_NETWORK_WRITE_BATCH_TIME_MS));
    }

    public long getMetricsMgrNetworkWriteBatchSizeBytes() {
        return TypeUtils.getLong(this.config.get(METRICSMGR_NETWORK_WRITE_BATCH_SIZE_BYTES));
    }

    public int getMetricsMgrNetworkOptionsSocketReceivedBufferSizeBytes() {
        return TypeUtils.getInteger(this.config.get(METRICSMGR_NETWORK_OPTIONS_SOCKET_RECEIVED_BUFFER_SIZE_BYTES));
    }

    public int getMetricsMgrNetworkOptionsSocketSendBufferSizeBytes() {
        return TypeUtils.getInteger(this.config.get(METRICSMGR_NETWORK_OPTIONS_SOCKET_SEND_BUFFER_SIZE_BYTES));
    }

    public Object put(String string, Object object) {
        return this.config.put(string, object);
    }
}

