/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.network;

import com.google.protobuf.Message;
import com.twitter.heron.common.basics.ISelectHandler;
import com.twitter.heron.common.basics.NIOLooper;
import com.twitter.heron.common.network.HeronSocketOptions;
import com.twitter.heron.common.network.IncomingPacket;
import com.twitter.heron.common.network.OutgoingPacket;
import com.twitter.heron.common.network.REQID;
import com.twitter.heron.common.network.SocketChannelHelper;
import com.twitter.heron.common.network.StatusCode;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HeronClient
implements ISelectHandler {
    private static final Logger LOG = Logger.getLogger(HeronClient.class.getName());
    protected Map<REQID, Object> contextMap;
    protected Map<REQID, Message.Builder> responseMessageMap;
    protected Map<String, Message.Builder> messageMap;
    private SocketChannel socketChannel;
    private InetSocketAddress endpoint;
    private NIOLooper nioLooper;
    private SocketChannelHelper socketChannelHelper;
    private HeronSocketOptions socketOptions;
    private boolean isConnected;

    public HeronClient(NIOLooper nIOLooper, String string, int n, HeronSocketOptions heronSocketOptions) {
        this.nioLooper = nIOLooper;
        this.endpoint = new InetSocketAddress(string, n);
        this.socketOptions = heronSocketOptions;
        this.isConnected = false;
        this.contextMap = new HashMap<REQID, Object>();
        this.responseMessageMap = new HashMap<REQID, Message.Builder>();
        this.messageMap = new HashMap<String, Message.Builder>();
    }

    public void registerOnMessage(Message.Builder builder) {
        this.messageMap.put(builder.getDescriptorForType().getFullName(), builder);
    }

    public void start() {
        try {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.configureBlocking(false);
            this.socketChannel.socket().setSendBufferSize(this.socketOptions.getSocketSendBufferSizeInBytes());
            this.socketChannel.socket().setReceiveBufferSize(this.socketOptions.getSocketReceivedBufferSizeInBytes());
            this.socketChannel.socket().setTcpNoDelay(true);
            LOG.info("Connecting to endpoint: " + this.endpoint);
            if (this.socketChannel.connect(this.endpoint)) {
                this.handleConnect(this.socketChannel);
            } else {
                this.nioLooper.registerConnect(this.socketChannel, this);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error connecting to remote endpoint: " + this.endpoint, iOException);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    HeronClient.this.onConnect(StatusCode.CONNECT_ERROR);
                }
            };
            this.nioLooper.registerTimerEventInSeconds(0L, runnable);
        }
    }

    public void stop() {
        if (!this.isConnected()) {
            return;
        }
        this.forceFlushWithBestEffort();
        LOG.info("To stop the HeronClient.");
        this.contextMap.clear();
        this.responseMessageMap.clear();
        this.messageMap.clear();
        this.socketChannelHelper.clear();
        this.nioLooper.removeAllInterest(this.socketChannel);
        try {
            this.socketChannel.close();
            this.onClose();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Failed to stop Client", iOException);
        }
    }

    @Override
    public void handleRead(SelectableChannel selectableChannel) {
        List<IncomingPacket> list = this.socketChannelHelper.read();
        for (IncomingPacket incomingPacket : list) {
            this.handlePacket(incomingPacket);
        }
    }

    @Override
    public void handleWrite(SelectableChannel selectableChannel) {
        this.socketChannelHelper.write();
    }

    public void sendRequest(Message message, Object object, Message.Builder builder, long l) {
        final REQID rEQID = REQID.generate();
        this.contextMap.put(rEQID, object);
        this.responseMessageMap.put(rEQID, builder);
        if (l > 0L) {
            this.registerTimerEventInSeconds(l, new Runnable(){

                @Override
                public void run() {
                    HeronClient.this.handleTimeout(rEQID);
                }
            });
        }
        OutgoingPacket outgoingPacket = new OutgoingPacket(rEQID, message);
        this.socketChannelHelper.sendPacket(outgoingPacket);
    }

    public void sendRequest(Message message, Message.Builder builder) {
        this.sendRequest(message, null, builder, -1L);
    }

    public void sendMessage(Message message) {
        OutgoingPacket outgoingPacket = new OutgoingPacket(REQID.zeroREQID, message);
        this.socketChannelHelper.sendPacket(outgoingPacket);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public NIOLooper getNIOLooper() {
        return this.nioLooper;
    }

    public void registerTimerEventInSeconds(long l, Runnable runnable) {
        this.nioLooper.registerTimerEventInSeconds(l, runnable);
    }

    public void registerTimerEventInNanoSeconds(long l, Runnable runnable) {
        this.nioLooper.registerTimerEventInNanoSeconds(l, runnable);
    }

    @Override
    public void handleAccept(SelectableChannel selectableChannel) {
        throw new RuntimeException("Client does not implement accept");
    }

    @Override
    public void handleConnect(SelectableChannel selectableChannel) {
        try {
            if (this.socketChannel.finishConnect()) {
                this.nioLooper.unregisterConnect(selectableChannel);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Failed to FinishConnect to endpoint: " + this.endpoint, iOException);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    HeronClient.this.onConnect(StatusCode.CONNECT_ERROR);
                }
            };
            this.nioLooper.registerTimerEventInSeconds(0L, runnable);
            return;
        }
        this.socketChannelHelper = new SocketChannelHelper(this.nioLooper, this, this.socketChannel, this.socketOptions);
        this.isConnected = true;
        this.onConnect(StatusCode.OK);
    }

    protected void handlePacket(IncomingPacket incomingPacket) {
        Message.Builder builder;
        String string = incomingPacket.unpackString();
        REQID rEQID = incomingPacket.unpackREQID();
        if (this.contextMap.containsKey(rEQID)) {
            Object object = this.contextMap.get(rEQID);
            Message.Builder builder2 = this.responseMessageMap.get(rEQID);
            this.contextMap.remove(rEQID);
            this.responseMessageMap.remove(rEQID);
            incomingPacket.unpackMessage(builder2);
            if (builder2.isInitialized()) {
                Message message = builder2.build();
                this.onResponse(StatusCode.OK, object, message);
                return;
            }
            this.onResponse(StatusCode.INVALID_PACKET, object, null);
            return;
        }
        if (rEQID.equals(REQID.zeroREQID) && (builder = this.messageMap.get(string)) != null) {
            builder.clear();
            incomingPacket.unpackMessage(builder);
            if (builder.isInitialized()) {
                this.onIncomingMessage(builder.build());
            }
        }
    }

    protected void handleTimeout(REQID rEQID) {
        if (this.contextMap.containsKey(rEQID)) {
            Object object = this.contextMap.get(rEQID);
            this.contextMap.remove(rEQID);
            this.responseMessageMap.remove(rEQID);
            this.onResponse(StatusCode.TIMEOUT_ERROR, object, null);
        }
    }

    @Override
    public void handleError(SelectableChannel selectableChannel) {
        LOG.info("Handling Error. Cleaning states in HeronClient.");
        this.contextMap.clear();
        this.responseMessageMap.clear();
        this.messageMap.clear();
        this.socketChannelHelper.clear();
        this.nioLooper.removeAllInterest(selectableChannel);
        try {
            selectableChannel.close();
            LOG.info("Successfully closed the channel: " + selectableChannel);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Failed to close connection in handleError", iOException);
        }
        this.isConnected = false;
        this.onError();
    }

    public void startReading() {
        this.socketChannelHelper.enableReading();
    }

    public void stopReading() {
        this.socketChannelHelper.disableReading();
    }

    public void startWriting() {
        this.socketChannelHelper.enableWriting();
    }

    public void stopWriting() {
        this.socketChannelHelper.disableWriting();
    }

    public int getOutstandingPackets() {
        return this.socketChannelHelper.getOutstandingPackets();
    }

    public void forceFlushWithBestEffort() {
        this.socketChannelHelper.forceFlushWithBestEffort();
    }

    public abstract void onError();

    public abstract void onConnect(StatusCode var1);

    public abstract void onResponse(StatusCode var1, Object var2, Message var3);

    public abstract void onIncomingMessage(Message var1);

    public abstract void onClose();

    protected Map<String, Message.Builder> getMessageMap() {
        return new HashMap<String, Message.Builder>(this.messageMap);
    }

    protected Map<REQID, Message.Builder> getResponseMessageMap() {
        return new HashMap<REQID, Message.Builder>(this.responseMessageMap);
    }

    protected Map<REQID, Object> getContextMap() {
        return new HashMap<REQID, Object>(this.contextMap);
    }

    protected SocketChannelHelper getSocketChannelHelper() {
        return this.socketChannelHelper;
    }

    protected SocketChannel getSocketChannel() {
        return this.socketChannel;
    }
}

