/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.network;

import com.google.protobuf.Message;
import com.twitter.heron.common.basics.ISelectHandler;
import com.twitter.heron.common.basics.NIOLooper;
import com.twitter.heron.common.network.HeronSocketOptions;
import com.twitter.heron.common.network.IncomingPacket;
import com.twitter.heron.common.network.OutgoingPacket;
import com.twitter.heron.common.network.REQID;
import com.twitter.heron.common.network.SocketChannelHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HeronServer
implements ISelectHandler {
    private static final Logger LOG = Logger.getLogger(HeronServer.class.getName());
    private ServerSocketChannel acceptChannel;
    private InetSocketAddress endpoint;
    private HeronSocketOptions socketOptions;
    private NIOLooper nioLooper;
    private Map<SocketChannel, SocketChannelHelper> activeConnections;
    private Map<String, Message.Builder> requestMap;
    private Map<String, Message.Builder> messageMap;

    public HeronServer(NIOLooper nIOLooper, String string, int n, HeronSocketOptions heronSocketOptions) {
        this.nioLooper = nIOLooper;
        this.endpoint = new InetSocketAddress(string, n);
        this.socketOptions = heronSocketOptions;
        this.requestMap = new HashMap<String, Message.Builder>();
        this.messageMap = new HashMap<String, Message.Builder>();
        this.activeConnections = new HashMap<SocketChannel, SocketChannelHelper>();
    }

    public void registerOnMessage(Message.Builder builder) {
        this.messageMap.put(builder.getDescriptorForType().getFullName(), builder);
    }

    public void registerOnRequest(Message.Builder builder) {
        this.requestMap.put(builder.getDescriptorForType().getFullName(), builder);
    }

    public boolean start() {
        try {
            this.acceptChannel = ServerSocketChannel.open();
            this.acceptChannel.configureBlocking(false);
            this.acceptChannel.socket().bind(this.endpoint);
            this.nioLooper.registerAccept(this.acceptChannel, this);
            return true;
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Failed to start server", iOException);
            return false;
        }
    }

    public void stop() {
        if (this.acceptChannel == null || !this.acceptChannel.isOpen()) {
            LOG.info("Fail to stop server; not yet open.");
            return;
        }
        for (Map.Entry<SocketChannel, SocketChannelHelper> entry : this.activeConnections.entrySet()) {
            SocketChannel socketChannel = entry.getKey();
            SocketAddress socketAddress = socketChannel.socket().getRemoteSocketAddress();
            LOG.info("Closing connected channel from client: " + socketAddress);
            LOG.info("Removing all interest on channel: " + socketAddress);
            this.nioLooper.removeAllInterest(socketChannel);
            this.onClose(socketChannel);
            entry.getValue().clear();
        }
        this.activeConnections.clear();
        this.requestMap.clear();
        this.messageMap.clear();
        try {
            this.acceptChannel.close();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Failed to close server", iOException);
        }
    }

    @Override
    public void handleAccept(SelectableChannel selectableChannel) {
        try {
            SocketChannel socketChannel = this.acceptChannel.accept();
            if (socketChannel != null) {
                socketChannel.configureBlocking(false);
                socketChannel.socket().setSendBufferSize(this.socketOptions.getSocketSendBufferSizeInBytes());
                socketChannel.socket().setReceiveBufferSize(this.socketOptions.getSocketReceivedBufferSizeInBytes());
                socketChannel.socket().setTcpNoDelay(true);
                SocketChannelHelper socketChannelHelper = new SocketChannelHelper(this.nioLooper, this, socketChannel, this.socketOptions);
                this.activeConnections.put(socketChannel, socketChannelHelper);
                this.onConnect(socketChannel);
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error while accepting a new connection ", iOException);
        }
    }

    @Override
    public void handleRead(SelectableChannel selectableChannel) {
        SocketChannelHelper socketChannelHelper = this.activeConnections.get(selectableChannel);
        if (socketChannelHelper == null) {
            LOG.severe("Unknown connection is ready for read");
            return;
        }
        List<IncomingPacket> list = socketChannelHelper.read();
        for (IncomingPacket incomingPacket : list) {
            this.handlePacket(selectableChannel, incomingPacket);
        }
    }

    @Override
    public void handleWrite(SelectableChannel selectableChannel) {
        SocketChannelHelper socketChannelHelper = this.activeConnections.get(selectableChannel);
        if (socketChannelHelper == null) {
            LOG.severe("Unknown connection is ready for read");
            return;
        }
        socketChannelHelper.write();
    }

    @Override
    public void handleConnect(SelectableChannel selectableChannel) {
        throw new RuntimeException("Server cannot have handleConnect");
    }

    private void handlePacket(SelectableChannel selectableChannel, IncomingPacket incomingPacket) {
        String string = incomingPacket.unpackString();
        REQID rEQID = incomingPacket.unpackREQID();
        Message.Builder builder = this.requestMap.get(string);
        boolean bl = false;
        if (builder != null) {
            bl = true;
        } else {
            builder = this.messageMap.get(string);
        }
        if (builder != null) {
            builder.clear();
            incomingPacket.unpackMessage(builder);
            if (builder.isInitialized()) {
                Message message = builder.build();
                if (bl) {
                    this.onRequest(rEQID, (SocketChannel)selectableChannel, message);
                } else {
                    this.onMessage((SocketChannel)selectableChannel, message);
                }
            } else {
                LOG.severe("Could not deserialize protobuf of type " + string);
                this.handleError(selectableChannel);
            }
            return;
        }
        LOG.severe("Unexpected protobuf type received " + string);
        this.handleError(selectableChannel);
    }

    @Override
    public void handleError(SelectableChannel selectableChannel) {
        SocketAddress socketAddress = ((SocketChannel)selectableChannel).socket().getRemoteSocketAddress();
        LOG.info("Handling error from channel: " + socketAddress);
        SocketChannelHelper socketChannelHelper = this.activeConnections.get(selectableChannel);
        if (socketChannelHelper == null) {
            LOG.severe("Inactive channel had error?");
            return;
        }
        socketChannelHelper.clear();
        LOG.info("Removing all interest on channel: " + socketAddress);
        this.nioLooper.removeAllInterest(selectableChannel);
        try {
            selectableChannel.close();
        }
        catch (IOException iOException) {
            LOG.severe("Error closing connection in handleError");
        }
        this.activeConnections.remove(selectableChannel);
        this.onClose((SocketChannel)selectableChannel);
    }

    public boolean sendResponse(REQID rEQID, SocketChannel socketChannel, Message message) {
        SocketChannelHelper socketChannelHelper = this.activeConnections.get(socketChannel);
        if (socketChannelHelper == null) {
            LOG.severe("Trying to send a response on an unknown connection");
            return false;
        }
        OutgoingPacket outgoingPacket = new OutgoingPacket(rEQID, message);
        socketChannelHelper.sendPacket(outgoingPacket);
        return true;
    }

    public boolean sendMessage(SocketChannel socketChannel, Message message) {
        return this.sendResponse(REQID.zeroREQID, socketChannel, message);
    }

    public NIOLooper getNIOLooper() {
        return this.nioLooper;
    }

    public void registerTimerEventInSeconds(long l, Runnable runnable) {
        this.nioLooper.registerTimerEventInSeconds(l, runnable);
    }

    public void registerTimerEventInNanoSeconds(long l, Runnable runnable) {
        this.nioLooper.registerTimerEventInNanoSeconds(l, runnable);
    }

    public abstract void onConnect(SocketChannel var1);

    public abstract void onRequest(REQID var1, SocketChannel var2, Message var3);

    public abstract void onMessage(SocketChannel var1, Message var2);

    public abstract void onClose(SocketChannel var1);

    protected Map<String, Message.Builder> getMessageMap() {
        return this.messageMap;
    }

    protected Map<String, Message.Builder> getRequestMap() {
        return this.requestMap;
    }

    protected ServerSocketChannel getAcceptChannel() {
        return this.acceptChannel;
    }

    protected Map<SocketChannel, SocketChannelHelper> getActiveConnections() {
        return this.activeConnections;
    }
}

