/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.network;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.twitter.heron.common.network.REQID;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IncomingPacket {
    private static final Logger LOG = Logger.getLogger(IncomingPacket.class.getName());
    private ByteBuffer header = ByteBuffer.allocate(4);
    private ByteBuffer data;
    private boolean headerRead = false;

    public int readFromChannel(SocketChannel socketChannel) {
        int n;
        if (!this.headerRead) {
            n = this.readFromChannel(socketChannel, this.header);
            if (n != 0) {
                return n;
            }
            this.headerRead = true;
            this.header.flip();
            this.data = ByteBuffer.allocate(this.header.getInt());
        }
        if ((n = this.readFromChannel(socketChannel, this.data)) == 0) {
            this.data.flip();
        }
        return n;
    }

    private int readFromChannel(SocketChannel socketChannel, ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        int n2 = 0;
        try {
            n2 = socketChannel.read(byteBuffer);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error in channel.read ", iOException);
            return -1;
        }
        if (n2 < 0) {
            LOG.severe("channel.read returned negative " + n2);
            return n2;
        }
        return n - n2;
    }

    public String unpackString() {
        int n = this.data.getInt();
        byte[] byArray = new byte[n];
        this.data.get(byArray);
        return new String(byArray);
    }

    public REQID unpackREQID() {
        return new REQID(this.data);
    }

    public void unpackMessage(Message.Builder builder) {
        int n = this.data.getInt();
        byte[] byArray = new byte[n];
        this.data.get(byArray);
        try {
            builder.mergeFrom(byArray);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            LOG.log(Level.SEVERE, "InvalidProtocolBufferException: ", invalidProtocolBufferException);
        }
    }

    public int size() {
        return this.data == null ? 0 : this.data.capacity();
    }
}

