/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.heron.common.network;

import com.google.protobuf.Message;
import com.twitter.heron.common.network.REQID;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutgoingPacket {
    private static final Logger LOG = Logger.getLogger(OutgoingPacket.class.getName());
    private ByteBuffer buffer;

    public OutgoingPacket(REQID rEQID, Message message) {
        assert (message.isInitialized());
        int n = 4;
        String string = message.getDescriptorForType().getFullName();
        int n2 = OutgoingPacket.sizeRequiredToPackString(string) + 32 + OutgoingPacket.sizeRequiredToPackMessage(message);
        this.buffer = ByteBuffer.allocate(n + n2);
        this.buffer.putInt(n2);
        this.buffer.putInt(string.length());
        this.buffer.put(string.getBytes());
        rEQID.pack(this.buffer);
        this.buffer.putInt(message.getSerializedSize());
        this.buffer.put(message.toByteArray());
        this.buffer.flip();
    }

    public static int sizeRequiredToPackString(String string) {
        return 4 + string.length();
    }

    public static int sizeRequiredToPackMessage(Message message) {
        return 4 + message.getSerializedSize();
    }

    public int writeToChannel(SocketChannel socketChannel) {
        int n = this.buffer.remaining();
        assert (n > 0);
        int n2 = 0;
        try {
            n2 = socketChannel.write(this.buffer);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error writing to channel ", iOException);
            return -1;
        }
        return n - n2;
    }

    public int size() {
        return this.buffer.capacity();
    }
}

